#version 330 core

layout (location = 0) in vec3 inPos;

out vec3 worldPos;

uniform mat4 camMatrix;

void main()
{
    worldPos = inPos;
    vec4 pos = camMatrix * vec4(inPos, 1.0);
    gl_Position = pos.xyww; // Set z to w for skybox effect (always at far plane)
}
