#version 330 core

out vec4 FragColor;

in vec2 textCoordinates;

uniform sampler2D diffuse0;
uniform sampler2D specular0;


void main()
{
    // Sample moon texture
    vec4 texColor = texture(diffuse0, textCoordinates);

    // Optional: circular alpha mask
    // (This prevents seeing the square shape of the quad)
    float dist = length(textCoordinates - vec2(0.5));
    float alphaMask = 1.0 - smoothstep(0.45, 0.5, dist);

    // Multiply texture alpha with circular mask
    float finalAlpha = texColor.a * alphaMask;

    // If fully transparent, discard (better look)
    if(finalAlpha < 0.01)
    discard;

    FragColor = vec4(texColor.rgb, finalAlpha);
}
