#version 330 core

layout (location = 0) in vec3 inPos;
layout (location = 3) in vec2 inTexture;

out vec2 texCoords;
out vec2 screenPos;

uniform mat4 model;
uniform vec2 flareScreenPos; // Screen space position of this flare element

void main()
{
    texCoords = inTexture;
    
    // Position is in screen space (-1 to 1)
    // Apply offset from flare position
    vec4 pos = model * vec4(inPos, 1.0);
    pos.xy += flareScreenPos;
    
    screenPos = pos.xy;
    gl_Position = pos;
}
