#version 330 core

out vec4 FragColor;
in vec2 texCoords;
in vec2 screenPos;

uniform vec3 flareColor;
uniform float flareIntensity;
uniform int flareType; // 0=soft circle, 1=very soft glow, 2=ring

void main()
{
    vec2 uv = texCoords - vec2(0.5);
    float dist = length(uv) * 2.0; // Scale to use full quad
    float alpha = 0.0;
    
    if (flareType == 0) {
        // Soft circular flare with very smooth edges
        alpha = 1.0 - smoothstep(0.0, 1.0, dist);
        alpha = pow(alpha, 2.5); // Smooth falloff
    }
    else if (flareType == 1) {
        // Very soft diffuse glow
        alpha = exp(-dist * 1.5);
        alpha = pow(alpha, 1.8);
    }
    else if (flareType == 2) {
        // Soft ring/halo
        float ringDist = abs(dist - 0.5);
        alpha = 1.0 - smoothstep(0.0, 0.3, ringDist);
        alpha *= smoothstep(1.0, 0.7, dist);
        alpha = pow(alpha, 1.5); // Softer
    }
    
    // Ensure alpha goes completely to zero at edges to prevent bounding box visibility
    float edgeFade = 1.0 - smoothstep(0.85, 1.0, dist);
    alpha *= edgeFade;
    
    // Strong fade based on distance from screen center
    // Most visible when light is centered, very transparent when off-center
    vec2 centerDist = screenPos;
    float distFromCenter = length(centerDist);
    float screenFade = 1.0 - smoothstep(0.0, 1.2, distFromCenter);
    screenFade = pow(screenFade, 1.2); // Moderate fade curve
    
    // Increase visibility
    alpha *= flareIntensity * screenFade;
    
    // For additive blending, output color directly multiplied by alpha
    vec3 outputColor = flareColor * alpha * 0.8; // Slightly reduced for subtlety
    
    // Output with actual alpha for proper transparency and smooth overlapping
    FragColor = vec4(outputColor, alpha);
}
