#version 330 core

in vec2 TexCoords;
out vec4 FragColor;

uniform sampler2D sceneTexture;
uniform sampler2D glowTexture;
uniform float glowIntensity;

void main()
{
    vec3 scene = texture(sceneTexture, TexCoords).rgb;
    vec3 glow = texture(glowTexture, TexCoords).rgb;
    
    // Additive blending with intensity control
    vec3 result = scene + glow * glowIntensity;
    
    FragColor = vec4(result, 1.0);
}
