#version 330 core

in vec2 TexCoords;
out vec4 FragColor;

uniform sampler2D image;
uniform bool horizontal;
uniform float blurSize;

// Optimized: 3-tap Gaussian blur weights
const float weight[3] = float[] (0.38774, 0.24477, 0.06136);

void main()
{
    vec2 tex_offset = blurSize / textureSize(image, 0);
    vec3 result = texture(image, TexCoords).rgb * weight[0];
    
    // Unrolled loop for better GPU performance (no branching in loop)
    if(horizontal)
    {
        result += texture(image, TexCoords + vec2(tex_offset.x, 0.0)).rgb * weight[1];
        result += texture(image, TexCoords - vec2(tex_offset.x, 0.0)).rgb * weight[1];
        result += texture(image, TexCoords + vec2(tex_offset.x * 2.0, 0.0)).rgb * weight[2];
        result += texture(image, TexCoords - vec2(tex_offset.x * 2.0, 0.0)).rgb * weight[2];
    }
    else
    {
        result += texture(image, TexCoords + vec2(0.0, tex_offset.y)).rgb * weight[1];
        result += texture(image, TexCoords - vec2(0.0, tex_offset.y)).rgb * weight[1];
        result += texture(image, TexCoords + vec2(0.0, tex_offset.y * 2.0)).rgb * weight[2];
        result += texture(image, TexCoords - vec2(0.0, tex_offset.y * 2.0)).rgb * weight[2];
    }
    
    FragColor = vec4(result, 1.0);
}
