#version 330 core

// Dual output for efficient glow system
layout(location = 0) out vec4 FragColor;      // Main scene color
layout(location = 1) out vec4 BrightColor;    // Bright areas for glow/bloom

in vec2 texCoord;

uniform sampler2D diffuse0;
uniform sampler2D emissive0;
uniform float glowStrength;

void main()
{
    // Sample textures
    vec4 texColor = texture(diffuse0, texCoord);
    float glowMask = texture(emissive0, texCoord).r;
    
    // Simple ambient lighting and glow
    vec3 baseColor = texColor.rgb * 0.25;
    vec3 glowContribution = vec3(1.0, 0.75, 0.15) * glowStrength * glowMask;
    
    // Output to main scene
    FragColor = vec4(baseColor + glowContribution, texColor.a);
    
    // Output ONLY the glow to bright buffer for efficient bloom
    BrightColor = vec4(glowContribution, texColor.a);
}
