#version 330 core

out vec4 FragColor;

in vec3 color;
in vec2 texCoord;
in vec3 Normal;
in vec3 crntPos;

uniform sampler2D diffuse0;
uniform vec4 lightColor;
uniform vec3 lightPos;
uniform vec3 camPos;
uniform vec3 pointLightPos;
uniform int bothLight;
uniform float glowStrength;
uniform float time;

void main()
{
    // DEBUG MODE: Visualize UV coordinates
    // This will help you identify which UV range corresponds to the back/tail
    
    // Option 1: Show UV as colors (Red = U, Green = V)
    vec3 uvDebug = vec3(texCoord.x, texCoord.y, 0.0);
    
    // Option 2: Show texture with grid overlay
    vec4 texColor = texture(diffuse0, texCoord);
    
    // Create a grid pattern to see UV mapping
    float gridSize = 0.1;
    float gridLineWidth = 0.02;
    float gridX = mod(texCoord.x, gridSize);
    float gridY = mod(texCoord.y, gridSize);
    bool isGridLine = (gridX < gridLineWidth || gridY < gridLineWidth);
    
    vec3 gridColor = isGridLine ? vec3(1.0, 1.0, 0.0) : texColor.rgb;
    
    // Show both: texture with UV coordinates as overlay
    // Red channel = U coordinate
    // Green channel = V coordinate  
    // Blue channel = texture
    vec3 debugColor = vec3(texCoord.x, texCoord.y, texColor.r * 0.5);
    
    // Uncomment ONE of these to see different debug modes:
    // FragColor = vec4(uvDebug, 1.0);           // Pure UV visualization
    // FragColor = vec4(gridColor, 1.0);         // Texture with grid
    FragColor = vec4(debugColor, 1.0);           // UV + texture mix
    
    // Also print UV ranges to help you identify regions
    // Look at the firefly and see which colors appear where
}
