#pragma once

#define MESHLET_MAX_TRIANGLES           124
#define MESHLET_MAX_VERTICES            64
#define AMPLIFICATION_SHADER_GROUP_SIZE 32
#define MESH_SHADER_GROUP_SIZE          128 // needs to be > MESHLET_MAX_TRIANGLES

struct PostParameters {
  float exposure;
  float brightness;
  float constrast;
  float saturation;
};

struct Vertex
{
  float4 tangent;
  float3 position;
  float3 normal;
  float2 uv;
};

struct Meshlet
{
  uint vertexOffset;
  uint triangleOffset;
  uint vertexCount;
  uint triangleCount;
  uint meshIndex; // TODO: move
  uint materialIndex; // TODO: move
  uint cone; // 24 bit axis, 8 bit cutoff
  float4 boundingSphere; // xyz center + radius
};

struct Mesh
{
  float4x4 transform;
  float scale; // needed extra to scale bounding sphere radius
};

struct Material
{
  float4 diffuseFactor;
  uint albedoTexture;
  uint normalTexture;
  uint _pad1;
  float3 emissiveFactor;
  uint emissiveTexture;
  uint metallicRoughnessTexture;
  float roughnessFactor;
  float metallicFactor;
};

struct GlobalShaderData
{
  float4x4 projection;
  float4x4 view;
  float4x4 fixatedView;
  float4x4 invViewProj;
  float4 viewFrustum;
  float3 viewPos;
  float _pad1;
  float3 lightPos; // changed for point light
  float lightStrength; // added for point light
  float lightRadius; // added for point light
  float ambientFactor;
  float zNear;
  float width;
  float height;
};

struct RenderHandles
{
    uint gbuffer0Index;
    uint gbuffer1Index;
    uint depthIndex;
    uint hdrRtIndex;
    uint shadowMapIndex;
};

struct RenderData
{
  uint vertexBufferIndex;
  uint meshletVertexBufferIndex;
  uint meshletTriangleBufferIndex;
  uint meshletBufferIndex;
  uint meshBufferIndex;
  uint materialBufferIndex;
  uint meshletCount;
};

struct DebugData
{
  // using ints because bool has different no. of bits in c++ and hlsl
  int showMeshlets;
  int disableBackfaceCulling;
};
