float3 SRGBToLinear(float3 c) {
    float3 cond = float3(0.04045, 0.04045, 0.04045);
    return select(c <= cond, c / 12.92, pow((c + 0.055) / 1.055, 2.4));
}

float3 LinearToSRGB(float3 c) {
    float3 cond = float3(0.0031308, 0.0031308, 0.0031308);
    return select(c <= cond, c * 12.92, 1.055 * pow(c, 1.0 / 2.4) - 0.055);
}

uint packRGBA8(float4 c)
{
    uint4 i = min(uint4(c * 255.0), 255);
    return i.x | (i.y << 8) | (i.z << 16) | (i.w << 24);
}

float4 unpackRGBA8(uint p)
{
    uint4 i = uint4(
        p & 0xFF,
        (p >> 8) & 0xFF,
        (p >> 16) & 0xFF,
        (p >> 24) & 0xFF
    );
    return float4(i) / 255.0;
}

uint packNormal11_11_10(float3 n)
{
    float3 un = n * 0.5 + 0.5; // -1:1 -> 0:1
    uint x = min(uint(un.x * 2047.0), 2047);
    uint y = min(uint(un.y * 2047.0), 2047);
    uint z = min(uint(un.z * 1023.0), 1023);
    return x | (y << 11) | (z << 22);
}

float3 unpackNormal11_11_10(uint p)
{
    float x = float(p & 2047) / 2047.0;
    float y = float((p >> 11) & 2047) / 2047.0;
    float z = float((p >> 22) & 1023) / 1023.0;
    return normalize(float3(x, y, z) * 2.0 - 1.0);
}

uint packEmissive(float3 emissive)
{
    emissive = max(emissive, 0.0f);

    uint r = f32tof16(emissive.r);
    uint g = f32tof16(emissive.g);
    uint b = f32tof16(emissive.b);

    uint packed = ((r & 0x7FF0) << 17) |
                  ((g & 0x7FF0) << 6)  |
                  ((b & 0x7FE0) >> 5);

    return packed;
}

float3 unpackEmissive(uint p)
{
    float3 emissive;

    emissive.r = f16tof32((p >> 17) & 0x7FF0);
    emissive.g = f16tof32((p >> 6)  & 0x7FF0);
    emissive.b = f16tof32((p << 5)  & 0x7FE0);

    return emissive;
}

uint packFloat2_16(float2 v)
{
    uint x = min(uint(v.x * 65535.0), 65535);
    uint y = min(uint(v.y * 65535.0), 65535);
    return x | (y << 16);
}

float2 unpackFloat2_16(uint p)
{
    float x = float(p & 65535) / 65535.0;
    float y = float(p >> 16) / 65535.0;
    return float2(x, y);
}
