#version 460
#pragma shader_stage(miss)
#extension GL_EXT_ray_tracing : require

layout(set = 0, binding = 5) uniform samplerCube skybox;

struct Payload {
    vec3 rayOrigin;
    vec3 rayDirection;
    vec3 color;
    float reflectionFactor;
};
layout(location = 0) rayPayloadInEXT Payload payload;

void main() {
    payload.color += texture(skybox, gl_WorldRayDirectionEXT).xyz * payload.reflectionFactor;
    payload.rayDirection = vec3(0.0);
}

