#version 460

layout(location = 0) in vec3 pos;
layout(location = 1) in vec3 color;
layout(location = 2) in vec3 normal;
layout(location = 3) in vec2 texCoord;

layout(binding = 0) uniform UniformBuffer{
    mat4 viewProj;
    vec3 viewPos;
} ubo;

layout(push_constant) uniform PushConstants {
    mat4 model;
    mat4 normal;
    int materialIndex;
} pc;

layout(location = 0) out vec3 fragPos;
layout(location = 1) out vec3 fragColor;
layout(location = 2) out vec3 fragNormal;
layout(location = 3) out vec2 fragTexCoord;

void main() {
    gl_Position = ubo.viewProj * pc.model * vec4(pos, 1.0);
    fragPos = mat3(pc.model) * pos;
    fragColor = color;
    fragNormal = normalize(mat3(pc.normal) * normal);
    fragTexCoord = texCoord;
}
