// VERTEX SHADER
#version 430 core

layout(location = 0) in vec3 aPos;
//layout(location = 1) in vec3 aNormal;
//layout(location = 2) in vec2 aUV;

struct InstanceData {
    vec4 position;
    vec4 orientation;
};

layout(std430, binding = 0) buffer PerBladeBuffer {
    InstanceData data[];
};

// can have random scale
// random bend amount

out vec3  vColor;

uniform mat4 view;
uniform mat4 projection;
uniform vec3 viewDir;
uniform mat4 scaleMatrix;
uniform float sinTimer;

mat3 makeRotationMatrix(vec3 dir)
{
    vec3 forward = normalize(dir);
    vec3 worldUp = vec3(0.0, 1.0, 0.0);
    vec3 right = normalize(cross(worldUp, forward));
    vec3 up    = cross(forward, right);

    return mat3(right, up, forward);
}

vec3 tipColor = vec3(0.9686, 0.8353, 0.4667);;
vec3 middleColor = vec3(0.5294, 0.5137, 0.0196);
vec3 bottomColor = vec3(0.3294, 0.2706, 0.0157);

void main() {
    uint id = gl_InstanceID;

    vec3 pos = data[id].position.xyz;

    // this did not work the way i intended, maybe we can reuse it later
    //vec3 bladePos = normalize(pos - cameraDirection);
    //vec3 viewDirectionNormalized = viewDir;
    //
    //float angle = acos(dot(bladePos, viewDirectionNormalized));
    //if (angle > 2.35619449019) {  // 2.35619449019 = pi/2 + pi/4;
    //    // if this vertex is completely behind camera then skip processing it
    //    return;
    //}

    // add random height
    if (aPos.y != 0) pos.y += data[id].position.w / 5;

    vec3 forward  = normalize(data[id].orientation.xyz);

    vec3 windDir = vec3(1.0,0,0);
    // add random sway strength per blade
    float strength = 0.2 * aPos.y * data[id].orientation.w;
    float windOffsetOnBlade = sinTimer * strength;

    windDir = windOffsetOnBlade * windDir;
    
    mat3 R = makeRotationMatrix(forward);
    vec3 right = R[0];

    // try to rotate the blade to face the camera
    float d = dot(normalize(forward), viewDir);
    float sideFactor = 1.0 - abs(d);
    float thicken = smoothstep(0.0, 0.2, sideFactor);

    float heightFactor = aPos.y;
    float str = 0.5;
    vec3 viewWarp = right * thicken * heightFactor * str;
    vec3 warpedLocal = aPos + viewWarp - 0.5 * aPos.y * forward;
    
    vec3 worldLocal = R * warpedLocal;
    vec3 worldPos = worldLocal + pos + windDir;

    gl_Position = projection * view * scaleMatrix * vec4(worldPos, 1.0);

    vColor = tipColor;
    if (aPos.y == 0) vColor = bottomColor;
}
