#version 330 core
in vec2 TexCoords;
out vec4 FragColor;

uniform sampler2D sceneTexture;
uniform sampler2D roughnessTexture;
uniform sampler2D metallicTexture;
uniform sampler2D ssrTexture;

void main()
{
    vec3 ref = texture(ssrTexture, TexCoords).rgb;
    vec3 scene = texture(sceneTexture, TexCoords).rgb;

    float roughness = clamp(texture(roughnessTexture, TexCoords), 0, 1).x;
    float metallic = clamp(texture(metallicTexture, TexCoords), 0, 1).x;

    float reflectivity = mix(0.04, 1.0, metallic) * pow(1.0 - roughness, 2.0);
    FragColor = vec4(mix(scene, ref, reflectivity), 1.0);
}

