#version 430 core

struct InstanceData {
    vec4 position;
    vec4 orientation;
    //vec4 perBladeSettings;
};

layout(std430, binding = 0) buffer PerBladeBuffer {
    InstanceData data[];
};

layout(local_size_x = 10, local_size_y = 10) in;

// source:  https://github.com/b0nes164/SimpleComputeShaderHashTable/blob/579f4db374e06e1fd2d0a7384aa99cf201efa643/src/Hash.compute#L22C1-L30C2 
// my fork of this in case it gets put down: https://github.com/AlexandruDanielBarbu/SimpleComputeShaderHashTable
uint hash_u32(uint x) {
    x ^= x >> 16;
    x *= 0x85ebca6bu;
    x ^= x >> 13;
    x *= 0xc2b2ae35u;
    x ^= x >> 16;
    return x;
}

// ChatGpt helper to correctly use the hash
// Convert uint -> float in [0,1)
float u01_from_u32(uint x) {
    // use top 24 bits to avoid precision issues
    return float(x >> 8) * (1.0 / 16777216.0); // 2^24
}

// Also a ChatGpt helper here
float hash(vec2 p) {
    uint x = floatBitsToUint(p.x);
    uint y = floatBitsToUint(p.y);
    uint h = hash_u32(x ^ (y * 0x9E3779B9u));
    return u01_from_u32(h);
}

float randSigned(vec2 p) { 
    return hash(p) * 2.0 - 1.0;
}

vec3 randomUnitVector(vec2 seed)
{
    float u = hash(seed);

    // Chat suggested changing this line
    float v = randSigned(seed + vec2(13.37, 42.0));

    float theta = u * 6.28318530718;
    float z = v;
    // Chat suggested changing this line
    float r = sqrt(max(0.0, 1.0 - z*z));

    return vec3(r * cos(theta), 0, r * sin(theta));
}

// TODO Set those here
uint patchSizeX   = 400;
uint patchSizeY   = 400;
uint grassDensity = 320;
vec3 origin       = vec3(-200,0,-200);

void main()
{
    uint x = gl_GlobalInvocationID.x;
    uint y = gl_GlobalInvocationID.y;

    // check for out of bounds - for some reason always fails me
    // if (x >= grassDensity || y >= grassDensity) return;

    uint index = y * grassDensity + x;
    
    float u = float(x) / float(grassDensity);
    float v = float(y) / float(grassDensity);

    // disperse the blades like an army on a X by Y plane
    float px = origin.x + u * patchSizeX;
    float py = origin.y + 0.0;
    float pz = origin.z + v * patchSizeY;

    // random xOz offset
    float ox = hash(vec2(px, pz)) * 1.0;
    float oz = hash(vec2(pz, px + 3.14)) * 1.0;

    vec3 pos = vec3(px + ox, py, pz + oz);
    vec3 dir = randomUnitVector(vec2(px, pz));
    
    float bladeScaleFactor = mix(0.8, 1.2, u01_from_u32(hash_u32(index)));
    float swayStrength     = mix(1, 3, u01_from_u32(hash_u32(index)));
    
    data[index].position    = vec4(pos, bladeScaleFactor);
    data[index].orientation = vec4(dir, swayStrength);
    
    // for some reason this line also fails me. It makes the grass look like a hairball for some reason
    //data[index].perBladeSettings = vec4(bladeScaleFactor, swayStrength, 0, 0);
}
