#version 430 core
/*
* Copyright 2019 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
	vec4 FragPosLightSpace;
} vert;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;
uniform mat3 normalMatrix;
uniform float time;
uniform mat4 lightSpaceMatrix;

void main() {
	vec3 transformedPos = vec3(position);
	float freq = 10.0;
	float amp = 0.06;
	float angleX = (time + position.x)*freq;
	float angleZ = (time + position.z)*freq;
	transformedPos.y += amp*sin(angleX)*sin(angleZ);
	vec4 position_world_ = modelMatrix * vec4(transformedPos, 1);
	vert.position_world = position_world_.xyz;
	vert.FragPosLightSpace = lightSpaceMatrix * vec4(vert.position_world,1.0);
	gl_Position = viewProjMatrix * position_world_;
 	
	vec3 diffX = vec3(1,amp * freq * sin(angleZ) * cos(angleX),0);
	vec3 diffZ = vec3(0,amp * freq * sin(angleX) * cos(angleZ),1);
	vec3 newNorm = normalize(cross(diffX,diffZ));
	vert.normal_world = normalMatrix * newNorm;
	vert.uv = uv;
}