#version 430 core
layout ( location = 0 ) in vec3 position;
layout ( location = 1 ) in vec3 normal;
layout ( location = 2 ) in vec2 texCoords;

out VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
} vert;

uniform mat4 model;
uniform mat4 viewProjMatrix;

void main( )
{
    vert.normal_world = mat3(transpose(inverse(model)))*normal;
    vert.uv = texCoords;
    vec4 position_world_ = model * vec4(position, 1.0);
    vert.position_world = position_world_.xyz;
    gl_Position = viewProjMatrix * position_world_;
}