#version 430 core

layout(location = 0) in vec3 vertices;
layout(location = 1) in vec4 centers;
layout(location = 2) in vec4 firecolor;

out vec4 partColor;

uniform mat4 viewProjMatrix;

void main() {
	vec3 partCenter = centers.xyz;
	float size = centers.w;
	
	vec3 partPos_world = vertices*size + partCenter; 
	gl_Position = viewProjMatrix * vec4(partPos_world, 1);
	partColor = firecolor;
}