unit ifs_win;
INTERFACE

uses dos,crt,graph,ifs_def;

const  XNOR_PUT		= 5;    { Konstanten fr SuperVGA - Image-}
       NOR_PUT		= 6;    { operationen }
       NAND_PUT		= 7;
       TRANS_COPY_PUT	= 8;	(* Doesn't work on 16-color systems *)

const Fkt_scroll : Boolean = False;
      sichtbar   = True;
      unsichtbar = False;
      aktiv      = True;
      inaktiv    = False;
      fix        = True;
      bewegt     = False;
      scroll_x   : Integer = 0;
      scroll_y   : Integer = 0;

type Polytyp = Array[0..4] of RPunkttyp;
     NPolytyp = Array[0..15] of RPunkttyp;
     VisiRec = record
                Bereich,
                Funktion,
                Fixpunkt : Boolean;
                end;
var Visible : Array[1..15] of VisiRec;

function sx(weltx : double) : double;
function sy(welty : double) : double;
function ry(revy : double) : double;    {invertiert Y-Achse fr Anzeige}
function wx(Bildx : longint) : double;
function wy(Bildy : longint) : double;
function Get_B_Koord_x(Bereichnr,Ecke : Byte): double;
function Get_B_Koord_y(Bereichnr,Ecke : Byte): double;
function Get_F_Koord_x(Bereichnr,FktNr,Ecke : Byte): double;
function Get_F_Koord_y(Bereichnr,FktNr,Ecke : Byte): double;
function Get_NF_Koord_x(Bereichnr,FktNr,Ecke : Byte): double;
function Get_NF_Koord_y(Bereichnr,FktNr,Ecke : Byte): double;

procedure berechne_Fixpunkt(Ber: B_Koordinaten; Funk : Lineare_Funktion;
                            var Fpunkt : RPunktTyp);
procedure recalc_B_Poly(nummer : Byte; Bereich : Single_IFS);
procedure remove_B_Poly(nummer : Byte);
procedure insert_B_Poly(nummer : Byte);
procedure Draw_Bereich(nummer: Byte; sichtbar,aktiv,fix: Boolean);
procedure recalc_F_Poly(Bnummer,nummer: Byte;
                        Bereich: B_Koordinaten; Funktion: lineare_Funktion);
procedure remove_F_Poly(Bnummer,nummer: Byte);
procedure insert_F_Poly(Bnummer,nummer: Byte);
procedure recalc_NF_Poly(Bnummer,nummer: Byte;
                        Bereich: B_Koordinaten; Funktion: nonlin_Funktion);
procedure remove_NF_Poly(Bnummer,nummer: Byte);
procedure insert_NF_Poly(Bnummer,nummer: Byte);
procedure restore_Visi(Bnummer: Byte);
procedure Scale_all(Faktor:double);
procedure Draw_Funktion(Bnummer,nummer: Byte; sichtbar,aktiv,fix: Boolean);
procedure Draw_Polygon(Pol: Polytyp; sichtbar,aktiv,fix: Boolean);
procedure Draw_NPolygon(Pol: NPolytyp; sichtbar,aktiv,fix: Boolean);
procedure Refresh(Akt_Ber,Akt_Fkt: Byte ; B_fix,F_fix: Boolean);
procedure Umrahmung;
procedure Bildloeschen;
procedure Funktion_ausblenden(Bereichnummer: Byte);
procedure Fixpunkt_ausblenden(Bereichnummer: Byte);

procedure Bereichsfeld;
procedure Bereich_anzeigen(nummer: char; name: Namenstring);
procedure Fkt_Fenster;
procedure Fkt_Header1(x,y : word);
procedure Fkt_Header2(x,y : word);
procedure Loesch_Fkt_Zeile(which : Byte);
procedure Funktion_anzeigen(Funk : Funktionstyp; aktiv : Boolean; woy : word);
procedure Update_pF(Funk : Funktionstyp; aktiv : Boolean);
procedure Alle_Fkt_anzeigen(Bereich : Single_IFS; aktiv : Byte);
procedure MRFS_anzeigen(Bereich: Single_IFS; aktiv: Byte);
procedure MRFS_update(FktNr: Byte; NeuBereich: char);

procedure Gib_mir_PSpeicher;

IMPLEMENTATION

const A_Fkt_Farbe = 70;
      P_Fkt_Farbe = 63;

type Polytypptr = ^Polytyp;
     NPolytypptr = ^NPolytyp;
     Polyliste = record
                 B_Poly : Polytypptr;
                 F_Poly : Array[1..15] of Polytypptr;
                 NF_Poly: Array[1..15] of NPolytypptr;
                 Fixpunkt : Array[1..15] of RPunkttyp;
                 end;

var Wk_Win : Array[0..3] of Punkttyp;
    Poly_Liste : Array[1..15] of Polyliste;
    i,j : Byte;
    Loesch_F_Poly : Polytypptr;
    Loesch_NF_Poly : NPolytypptr;
    Loesch_Fpkt : RPunkttyp;
    Loesch_Visi : VisiRec;

function sx(weltx : double) : double;
begin
  sx := weltx * (x-GraphWin_x)*Skalierung;
end;

function sy(welty : double) : double;
begin
  sy := welty * (y-Menue_y-Lineal_b)*Skalierung;
end;

function ry(revy : double) : double;    {invertiert Y-Achse fr Anzeige}
begin
  ry := y - Lineal_b - Menue_y - revy;
end;

function wx(Bildx : longint) : double;
begin
  wx := (Bildx - GraphWin_x) / (x-GraphWin_x) / Skalierung;
end;

function wy(Bildy : longint) : double;
begin
  wy := (-Bildy - Lineal_b + y) / (y-Menue_y-Lineal_b) / Skalierung;
end;

procedure berechne_Fixpunkt(Ber: B_Koordinaten; Funk : Lineare_Funktion;
                            var Fpunkt : RPunktTyp);
var temp1,temp2,tx,ty : double;
begin
  with Funk do begin
    temp1 := b * f - e * (d-1);
    temp2 := (a-1) * (d-1) - c * b;
    tx  := temp1 / temp2;
    temp1 := c * e - f * (a-1);
    ty := temp1 / temp2;
    end;
  with Ber do begin
    FPunkt.x := sx(tx * a + ty * b + e);
    FPunkt.y := sy(tx * c + ty * d + f);
    end;
end;

procedure Umrahmung;
begin
SetLineStyle(SolidLn,0,1);
SetColor(F_Linie);;
MoveTo(GraphWin_x,y-Lineal_b);
LineTo(x,y-Lineal_b);
LineTo(x,Menue_y);
LineTo(GraphWin_x,Menue_y);
LineTo(GraphWin_x,y-Lineal_b);
end;

procedure recalc_B_Poly(nummer : Byte; Bereich : Single_IFS);
var i : Byte;
begin
with Bereich.Form do
  for i := 0 to 3 do begin
    Poly_Liste[nummer].B_Poly^[i].x := sx(Wk_Win[i].x * a + Wk_Win[i].y * b + e);
    Poly_Liste[nummer].B_Poly^[i].y := sy(Wk_Win[i].x * c + Wk_Win[i].y * d + f);
    end;
with Poly_Liste[nummer] do
  B_Poly^[4] := B_Poly^[0];
end;

procedure remove_B_Poly(nummer : Byte);
var i : Byte;
begin
i := 1;
with Poly_LIste[nummer] do
  while (i <= Max_Funktionen) and
        ((F_Poly[i] <> nil) or (NF_Poly[i] <> nil)) do begin
    if F_Poly[i] <> nil then begin
      FreeMem(F_Poly[i],sizeof(Polytyp));
      F_Poly[i] := nil;
      end
    else begin
      FreeMem(NF_Poly[i],sizeof(Polytyp));   {*mu noch angepat werden*}
      NF_Poly[i] := nil;
      end;
    Inc(i);
    end;
Loesch_Visi := Visible[nummer];
if nummer < 15 then
  for i := nummer to 14 do begin
    Poly_Liste[i] := Poly_Liste[Succ(i)];
    Visible[i] := Visible[Succ(i)];
    end;
for i := 1 to 15 do
  Poly_Liste[15].F_Poly[i] := nil;
Poly_Liste[15].B_Poly := nil;
Visible[15].Bereich := True;
Visible[15].Funktion := True;
Visible[15].Fixpunkt := True;
end;

procedure insert_B_Poly(nummer: Byte);
var i : Byte;
begin
if nummer < 15 then
  for i := 15 downto Succ(nummer) do begin
    Poly_Liste[i] := Poly_Liste[Pred(i)];
    Visible[i] := Visible[Pred(i)];
    end;
GetMem(Poly_Liste[nummer].B_Poly,sizeof(Polytyp));
for i := 1 to 15 do
  Poly_Liste[nummer].F_Poly[i] := nil;
  Poly_Liste[nummer].NF_Poly[i] := nil;
end;

procedure recalc_F_Poly(Bnummer,nummer: Byte;
                        Bereich: B_Koordinaten; Funktion: lineare_Funktion);
var i : Byte;
    Transform : lineare_Funktion;
begin
with Bereich do begin
  Transform.a := Funktion.a*a + Funktion.c*b;
  Transform.b := Funktion.b*a + Funktion.d*b;
  Transform.c := Funktion.a*c + Funktion.c*d;
  Transform.d := Funktion.b*c + Funktion.d*d;
  Transform.e := Funktion.e*a + Funktion.f*b + e;
  Transform.f := Funktion.e*c + Funktion.f*d + f;
  end;
with Transform do
  for i := 0 to 3 do begin
    Poly_Liste[Bnummer].F_Poly[nummer]^[i].x := sx(Wk_Win[i].x * a + Wk_Win[i].y * b + e);
    Poly_Liste[Bnummer].F_Poly[nummer]^[i].y := sy(Wk_Win[i].x * c + Wk_Win[i].y * d + f);
    end;
with Poly_Liste[Bnummer] do begin
  F_Poly[nummer]^[4] := F_Poly[nummer]^[0];
  berechne_FixPunkt(Bereich,Funktion,Fixpunkt[nummer]);
  end;
end;

procedure remove_F_Poly(Bnummer,nummer: Byte);
var i : Byte;
begin
with Poly_Liste[Bnummer] do begin
  if Loesch_F_Poly <> nil then begin
    FreeMem(Loesch_F_Poly,sizeof(Polytyp));
    Loesch_F_Poly := nil;
    end;
  Loesch_F_Poly := F_Poly[nummer];
  Loesch_Fpkt := Fixpunkt[nummer];
  if nummer < 15 then
    for i := nummer to 14 do begin
      F_Poly[i] := F_Poly[Succ(i)];
      Fixpunkt[i] := Fixpunkt[Succ(i)];
      NF_Poly[i] := NF_Poly[Succ(i)];  {nichtlineare Fkt-Polygone nachziehen}
      end;
  F_Poly[15] := nil;
  NF_Poly[15] := nil;
  end;
end;

procedure insert_F_Poly(Bnummer,nummer: Byte);
var i : Byte;
begin
with Poly_Liste[Bnummer] do begin
  if nummer < Max_Funktionen then
    for i := Max_Funktionen downto Succ(nummer) do begin
      F_Poly[i] := F_Poly[Pred(i)];
      Fixpunkt[i] := Fixpunkt[Pred(i)];
      NF_Poly[i] := NF_Poly[Pred(i)];  {nichtlineare Fkt-Polygone nachziehen}
      end;
  GetMem(F_Poly[nummer],sizeof(Polytyp));
  NF_Poly[nummer] := nil;
  end;
end;

procedure recalc_NF_Poly(Bnummer,nummer: Byte;
                         Bereich: B_Koordinaten; Funktion: nonlin_Funktion);
var i : Byte;
    BF : NPolytyp;
begin
with Bereich do
  for i := 0 to 15 do begin
    BF[i].x := Funktion.Punkt[i].x * a + Funktion.Punkt[i].y * b + e;
    BF[i].y := Funktion.Punkt[i].x * c + Funktion.Punkt[i].y * d + f;
    end;
with Poly_Liste[Bnummer] do begin
  for i := 0 to 15 do begin
    NF_Poly[nummer]^[i].x := sx(BF[i].x);
    NF_Poly[nummer]^[i].y := sy(BF[i].y);
    end;
  end;
end;

procedure remove_NF_Poly(Bnummer,nummer: Byte);
var i : Byte;
begin
with Poly_Liste[Bnummer] do begin
  if Loesch_NF_Poly <> nil then begin
    FreeMem(Loesch_NF_Poly,sizeof(NPolytyp));
    Loesch_NF_Poly := nil;
    end;
  Loesch_NF_Poly := NF_Poly[nummer];
  if nummer < 15 then
    for i := nummer to 14 do begin
      NF_Poly[i] := NF_Poly[Succ(i)];
      F_Poly[i] := F_Poly[Succ(i)];       { lineare Fkt-Polygone nachziehen }
      Fixpunkt[i] := Fixpunkt[Succ(i)];
      end;
  NF_Poly[15] := nil;
  F_Poly[15] := nil;
  end;
end;

procedure insert_NF_Poly(Bnummer,nummer: Byte);
var i : Byte;
begin
with Poly_Liste[Bnummer] do begin
  if nummer < Max_Funktionen then
    for i := Max_Funktionen downto Succ(nummer) do begin
      NF_Poly[i] := NF_Poly[Pred(i)];
      F_Poly[i] := F_Poly[Pred(i)];       { lineare Fkt-Polygone nachziehen }
      Fixpunkt[i] := Fixpunkt[Pred(i)];
      end;
  GetMem(NF_Poly[nummer],sizeof(NPolytyp));
  F_Poly[nummer] := nil;
  end;
end;

procedure restore_Visi(Bnummer: Byte);
begin
Visible[Bnummer] := Loesch_Visi;
end;

function Get_B_Koord_x(Bereichnr,Ecke : Byte): double;
begin
with Poly_Liste[Bereichnr] do
  Get_B_Koord_x := B_Poly^[Ecke].x;
end;

function Get_B_Koord_y(Bereichnr,Ecke : Byte): double;
begin
with Poly_Liste[Bereichnr] do
  Get_B_Koord_y := B_Poly^[Ecke].y;
end;

function Get_F_Koord_x(Bereichnr,FktNr,Ecke : Byte): double;
begin
with Poly_Liste[Bereichnr] do
  Get_F_Koord_x := F_Poly[Fktnr]^[Ecke].x;
end;

function Get_F_Koord_y(Bereichnr,FktNr,Ecke : Byte): double;
begin
with Poly_Liste[Bereichnr] do
  Get_F_Koord_y := F_Poly[Fktnr]^[Ecke].y;
end;

function Get_NF_Koord_x(Bereichnr,FktNr,Ecke : Byte): double;
begin
with Poly_Liste[Bereichnr] do
  Get_NF_Koord_x := NF_Poly[Fktnr]^[Ecke].x;
end;

function Get_NF_Koord_y(Bereichnr,FktNr,Ecke : Byte): double;
begin
with Poly_Liste[Bereichnr] do
  Get_NF_Koord_y := NF_Poly[Fktnr]^[Ecke].y;
end;

function Nearest_to_Zero(Pol : Polytyp):Byte;
var i, i1 : Byte;
    dist1, dist2 : double;
begin
dist1 := sqr(longint(x)) + sqr(longint(y));
i1 := 0;
for i := 0 to 3 do begin
  dist2 := sqr(Pol[i].x) + sqr(Pol[i].y);
  if dist2 < dist1 then begin
    dist1 := dist2;
    i1 := i;
    end;
  end;
Nearest_to_Zero := i1
end;

function Gegen_Uhrzeigersinn(Pol : Polytyp):Boolean;
var i,j,k : integer;
begin
i := Nearest_to_Zero(Pol);
j := Succ(i) mod 4;
k := (i+3) mod 4;
if Pol[j].x > Pol[k].x then Gegen_Uhrzeigersinn := True
else Gegen_Uhrzeigersinn := False;
end;

procedure Draw_Bereich(nummer: Byte; sichtbar,aktiv,fix: Boolean);
var i,i1,i2 : Byte;
begin
if not Visible[nummer].Bereich then Exit;
SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
if not sichtbar then
  SetColor(0)
else if aktiv and fix then
    SetColor(F_B_Poly)
  else begin
    if not fix then
      SetLineStyle(DashedLn,0,1);
    SetColor(F_Linie);
    end;
with Poly_Liste[nummer] do begin
  MoveTo(round(B_Poly^[0].x)-scroll_x,round(ry(B_Poly^[0].y))+scroll_y);
  for i := 1 to 4 do
    LineTo(round(B_Poly^[i].x)-scroll_x,round(ry(B_Poly^[i].y))+scroll_y);
  end;
if fix then
  with Poly_Liste[nummer] do begin
    i := Nearest_to_Zero(B_Poly^);
    if Gegen_Uhrzeigersinn(B_Poly^) then begin
      i1 := (i+1) mod 4;
      i2 := (i+2) mod 4;
      end
    else begin
      i1 := (i+3) mod 4;
      i2 := (i+2) mod 4;
      end;
    Line(Succ(round(B_Poly^[i].x))-scroll_x,Succ(round(ry(B_Poly^[i].y)))+scroll_y,
         Succ(round(B_Poly^[i1].x))-scroll_x,Succ(round(ry(B_Poly^[i1].y)))+scroll_y);
    Line(Succ(round(B_Poly^[i1].x))-scroll_x,Succ(round(ry(B_Poly^[i1].y)))+scroll_y,
         Succ(round(B_Poly^[i2].x))-scroll_x,Succ(round(ry(B_Poly^[i2].y)))+scroll_y);
    end;
SetLineStyle(SolidLn,0,1);
SetViewPort(0,0,x,y,True);
end;

procedure Scale_all(Faktor : double);
var i,j,k : Byte;
begin
i := 1;
while (i <= Max_Bereiche) and (Poly_Liste[i].B_Poly <> nil) do begin
  for k := 0 to 4 do begin
    Poly_Liste[i].B_Poly^[k].x := Poly_Liste[i].B_Poly^[k].x * Faktor;
    Poly_Liste[i].B_Poly^[k].y := Poly_Liste[i].B_Poly^[k].y * Faktor;
    end;
  { und jetzt die Funktionen}
  j := 1;
  with Poly_Liste[i] do begin
    while (j <= Max_Funktionen) and
          ((F_Poly[j] <> nil) or (NF_Poly[j] <> nil)) do begin
      if F_Poly[j] <> nil then begin
        for k := 0 to 4 do begin
          F_Poly[j]^[k].x := F_Poly[j]^[k].x * Faktor;
          F_Poly[j]^[k].y := F_Poly[j]^[k].y * Faktor;
          end;
        Fixpunkt[j].x := Fixpunkt[j].x * Faktor;
        Fixpunkt[j].y := Fixpunkt[j].y * Faktor;
        end
      else begin
        for k := 0 to 15 do begin
          NF_Poly[j]^[k].x := NF_Poly[j]^[k].x * Faktor;
          NF_Poly[j]^[k].y := NF_Poly[j]^[k].y * Faktor;
          end;
        end;
      Inc(j);
      end;
    end;
  Inc(i);
  end;
end;

procedure Draw_Funktion(Bnummer,nummer: Byte; sichtbar,aktiv,fix: Boolean);
var i : Byte;
begin
if (Bnummer < 1) or (nummer < 1) then
  Exit;
if not Visible[Bnummer].Bereich or not Visible[Bnummer].Funktion then
  Exit;
SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
if sichtbar then begin
  if aktiv then
    SetColor(F_F_Poly)
  else
    SetColor(F_Linie);
  if fix then
    SetLineStyle(SolidLn,0,1)
  else
    SetLineStyle(DashedLn,0,1);
  end
else
  SetColor(0);
with Poly_Liste[Bnummer] do begin
  if F_Poly[nummer] <> nil then begin
    MoveTo(round(F_Poly[nummer]^[0].x)-scroll_x,round(ry(F_Poly[nummer]^[0].y))+scroll_y);
    for i := 1 to 4 do
      LineTo(round(F_Poly[nummer]^[i].x)-scroll_x,round(ry(F_Poly[nummer]^[i].y))+scroll_y);
    if Visible[Bnummer].Fixpunkt then
      with Fixpunkt[nummer] do
        Circle(round(x)-scroll_x,round(ry(y))+scroll_y,2);
    end
  else begin
    MoveTo(round(NF_Poly[nummer]^[0].x)-scroll_x,round(ry(NF_Poly[nummer]^[0].y))+scroll_y);
    for i := 1 to 3 do
      LineTo(round(NF_Poly[nummer]^[i].x)-scroll_x,round(ry(NF_Poly[nummer]^[i].y))+scroll_y);
    for i := 1 to 3 do
      LineTo(round(NF_Poly[nummer]^[3+4*i].x)-scroll_x,round(ry(NF_Poly[nummer]^[3+4*i].y))+scroll_y);
    for i := 15 downto 12 do
      LineTo(round(NF_Poly[nummer]^[i].x)-scroll_x,round(ry(NF_Poly[nummer]^[i].y))+scroll_y);
    for i := 3 downto 0 do
      LineTo(round(NF_Poly[nummer]^[4*i].x)-scroll_x,round(ry(NF_Poly[nummer]^[4*i].y))+scroll_y);
    MoveTo(round(NF_Poly[nummer]^[1].x)-scroll_x,round(ry(NF_Poly[nummer]^[1].y))+scroll_y);
    for i := 1 to 3 do
      LineTo(round(NF_Poly[nummer]^[1+4*i].x)-scroll_x,round(ry(NF_Poly[nummer]^[1+4*i].y))+scroll_y);
    MoveTo(round(NF_Poly[nummer]^[2].x)-scroll_x,round(ry(NF_Poly[nummer]^[2].y))+scroll_y);
    for i := 1 to 3 do
      LineTo(round(NF_Poly[nummer]^[2+4*i].x)-scroll_x,round(ry(NF_Poly[nummer]^[2+4*i].y))+scroll_y);
    MoveTo(round(NF_Poly[nummer]^[4].x)-scroll_x,round(ry(NF_Poly[nummer]^[4].y))+scroll_y);
    for i := 1 to 3 do
      LineTo(round(NF_Poly[nummer]^[4+i].x)-scroll_x,round(ry(NF_Poly[nummer]^[4+i].y))+scroll_y);
    MoveTo(round(NF_Poly[nummer]^[8].x)-scroll_x,round(ry(NF_Poly[nummer]^[8].y))+scroll_y);
    for i := 1 to 3 do
      LineTo(round(NF_Poly[nummer]^[8+i].x)-scroll_x,round(ry(NF_Poly[nummer]^[8+i].y))+scroll_y);
    end;
  end;
SetLineStyle(SolidLn,0,1);
SetViewPort(0,0,x,y,True);
end;

procedure Draw_Polygon(Pol: Polytyp; sichtbar,aktiv,fix: Boolean);
var i,i1,i2 : Byte;
begin
SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
if not sichtbar then
  SetColor(0)
else if aktiv and fix then
    SetColor(F_B_Poly)
  else begin
    if not fix then
      SetLineStyle(DashedLn,0,1);
    SetColor(F_Linie);
    end;
MoveTo(round(Pol[0].x)-scroll_x,round(ry(Pol[0].y))+scroll_y);
for i := 1 to 4 do
  LineTo(round(Pol[i].x)-scroll_x,round(ry(Pol[i].y))+scroll_y);
if fix then begin
  i := Nearest_to_Zero(Pol);
  if Gegen_Uhrzeigersinn(Pol) then begin
    i1 := (i+1) mod 4;
    i2 := (i+2) mod 4;
    end
  else begin
    i1 := (i+3) mod 4;
    i2 := (i+2) mod 4;
    end;
  Line(Succ(round(Pol[i].x))-scroll_x,Succ(round(ry(Pol[i].y)))+scroll_y,
       Succ(round(Pol[i1].x))-scroll_x,Succ(round(ry(Pol[i1].y)))+scroll_y);
  Line(Succ(round(Pol[i1].x))-scroll_x,Succ(round(ry(Pol[i1].y)))+scroll_y,
       Succ(round(Pol[i2].x))-scroll_x,Succ(round(ry(Pol[i2].y)))+scroll_y);
  end;
SetLineStyle(SolidLn,0,1);
SetViewPort(0,0,x,y,True);
end;

procedure Draw_NPolygon(Pol: NPolytyp; sichtbar,aktiv,fix: Boolean);
var i,i1,i2 : Byte;
begin
SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
if not sichtbar then
  SetColor(0)
else if aktiv and fix then
    SetColor(F_B_Poly)
  else begin
    if not fix then
      SetLineStyle(DashedLn,0,1);
    SetColor(F_Linie);
    end;
MoveTo(round(Pol[0].x)-scroll_x,round(ry(Pol[0].y))+scroll_y);
for i := 1 to 3 do
  LineTo(round(Pol[i].x)-scroll_x,round(ry(Pol[i].y))+scroll_y);
for i := 1 to 3 do
  LineTo(round(Pol[i*4+3].x)-scroll_x,round(ry(Pol[i*4+3].y))+scroll_y);
for i := 15 downto 12 do
  LineTo(round(Pol[i].x)-scroll_x,round(ry(Pol[i].y))+scroll_y);
for i := 2 downto 0 do
  LineTo(round(Pol[i*4].x)-scroll_x,round(ry(Pol[i*4].y))+scroll_y);
MoveTo(round(Pol[4].x)-scroll_x,round(ry(Pol[4].y))+scroll_y);
for i := 1 to 3 do
  LineTo(round(Pol[4+i].x)-scroll_x,round(ry(Pol[4+i].y))+scroll_y);
MoveTo(round(Pol[8].x)-scroll_x,round(ry(Pol[8].y))+scroll_y);
for i := 1 to 3 do
  LineTo(round(Pol[8+i].x)-scroll_x,round(ry(Pol[8+i].y))+scroll_y);
MoveTo(round(Pol[1].x)-scroll_x,round(ry(Pol[1].y))+scroll_y);
for i := 1 to 3 do
  LineTo(round(Pol[i*4+1].x)-scroll_x,round(ry(Pol[i*4+1].y))+scroll_y);
MoveTo(round(Pol[2].x)-scroll_x,round(ry(Pol[2].y))+scroll_y);
for i := 1 to 3 do
  LineTo(round(Pol[i*4+2].x)-scroll_x,round(ry(Pol[i*4+2].y))+scroll_y);
SetLineStyle(SolidLn,0,1);
SetViewPort(0,0,x,y,True);
end;

procedure Refresh(Akt_Ber,Akt_Fkt: Byte; B_fix,F_fix: Boolean);
var i,j : Byte;
begin
if Akt_Ber < 1 then
  Exit;
SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
i := 1;
while (i <= Max_Bereiche) and (Poly_Liste[i].B_Poly <> nil) do begin
  Draw_Bereich(i,True,i = Akt_Ber,(i <> Akt_Ber) or B_fix);
  j := 1;
  while (j <= Max_Funktionen) and
        ((Poly_Liste[i].F_Poly[j] <> nil) or (Poly_Liste[i].NF_Poly[j] <> nil)) do begin
    Draw_Funktion(i,j,True,(i = Akt_Ber) and (j = Akt_Fkt),(j <> Akt_Fkt) or F_fix);    
    Inc(j);
    end;
  Inc(i);
  end;
Draw_Bereich(Akt_Ber,True,True,B_fix);
Draw_Funktion(Akt_Ber,Akt_Fkt,True,True,F_fix);
SetViewPort(0,0,x,y,True);
end;

procedure Bildloeschen;
begin
SetFillStyle(SolidFill,0);
Bar(Succ(GraphWin_x),Succ(Menue_y),Pred(x),Pred(y-Lineal_b));
end;

procedure Funktion_ausblenden(Bereichnummer: Byte);
var i : Byte;
begin
i := 1;
with Poly_Liste[Bereichnummer] do
  while ((F_Poly[i] <> nil) or (NF_Poly[i] <> nil)) and
        (i <= Max_Funktionen) do begin
    Draw_Funktion(Bereichnummer,i,False,False,True);
    Inc(i);
    end;
end;

procedure Fixpunkt_ausblenden(Bereichnummer: Byte);
var i : Byte;
begin
i := 1;
SetColor(0);
SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
with Poly_Liste[Bereichnummer] do
  while (F_Poly[i] <> nil) and (i <= Max_Funktionen) do begin
    with Fixpunkt[i] do
      Circle(round(x),round(ry(y)),2);
    Inc(i);
    end;
SetViewPort(0,0,x,y,True);
end;

procedure Bereichsfeld;
begin
SetColor(F_Linie);
MoveTo(0,Menue_y);
LineTo(Bereich_x,Menue_y);
LineTo(Bereich_x,NumWin_y1);
LineTo(0,NumWin_y1);
LineTo(0,Menue_y);
SetFillStyle(Solidfill,170);
Bar(1,Menue_y+1,Bereich_x-1,NumWin_y1-1);                   {Bereichsanzeige}
end;

procedure Bereich_anzeigen(nummer: char; name: Namenstring);
begin
SetColor(F_Text_rot);
SetTextStyle(SmallFont,HorizDir,Menueschrift);
SetTextJustify(LeftText,BottomText);
OuttextXY(Bereichtext_x,Bereichtext_y,nummer+') '+name);
OuttextXY(Bereichtext_x+1,Bereichtext_y,nummer+') '+name);
end;

procedure Fkt_Fenster;
begin
SetColor(F_Linie);
MoveTo(0,NumWin_y1);
LineTo(Bereich_x,NumWin_y1);
LineTo(Bereich_x,NumWin_y2);
LineTo(0,NumWin_y2);
LineTo(0,NumWin_y1);
SetFillStyle(Solidfill,165);
Bar(1,NumWin_y1+1,Bereich_x-1,NumWin_y2-1);                 {num. Fenster}
end;

procedure Fkt_Header1(x,y : word);
begin
SetFillStyle(Solidfill,165);
Bar(x+1,y+1,x+Bereich_x-1,y+NumText_y-1);
SetColor(F_Text);
SettextStyle(smallfont,HorizDir,Wertezeile);
Leerfeld := Textwidth(' ');
SettextStyle(smallfont,HorizDir,Headline);
SetTextJustify(LeftText,BottomText);
OuttextXY(x+NumHead_x,y+NumHead_y,'a');
OuttextXY(x+NumHead_x+NumHead_abstand,y+NumHead_y,'b');
OuttextXY(x+NumHead_x+2*NumHead_abstand,y+NumHead_y,'c');
OuttextXY(x+NumHead_x+3*NumHead_abstand,y+NumHead_y,'d');
OuttextXY(x+NumHead_x+4*NumHead_abstand+Leerfeld,y+NumHead_y,'e');
OuttextXY(x+NumHead_x+5*NumHead_abstand+Leerfeld,y+NumHead_y,'f');
OuttextXY(x+NumHead_x+1,y+NumHead_y,'a');
OuttextXY(x+NumHead_x+NumHead_abstand+1,y+NumHead_y,'b');
OuttextXY(x+NumHead_x+2*NumHead_abstand+1,y+NumHead_y,'c');
OuttextXY(x+NumHead_x+3*NumHead_abstand+1,y+NumHead_y,'d');
OuttextXY(x+NumHead_x+4*NumHead_abstand+Leerfeld+1,y+NumHead_y,'e');
OuttextXY(x+NumHead_x+5*NumHead_abstand+Leerfeld+1,y+NumHead_y,'f');
end;

procedure Fkt_Header2(x,y : word);
begin
SetFillStyle(Solidfill,165);
Bar(x+1,y+1,x+Bereich_x-1,y+NumText_y-1);
SetColor(F_Text);
SettextStyle(smallfont,HorizDir,Wertezeile);
Leerfeld := Textwidth(' ');
SettextStyle(smallfont,HorizDir,Headline);
SetTextJustify(LeftText,BottomText);
OuttextXY(x+NumHead_x,y+NumHead_y,'c');
OuttextXY(x+NumHead_x+NumHead_abstand,y+NumHead_y,'d');
OuttextXY(x+NumHead_x+2*NumHead_abstand+Leerfeld,y+NumHead_y,'e');
OuttextXY(x+NumHead_x+3*NumHead_abstand+Leerfeld,y+NumHead_y,'f');
OuttextXY(x+NumHead_x+4*NumHead_abstand+2*Leerfeld-2,y+NumHead_y,'p(F)');
OuttextXY(x+NumHead_x+5*NumHead_abstand+3*Leerfeld-2,y+NumHead_y,'->B');
OuttextXY(x+NumHead_x+1,y+NumHead_y,'c');
OuttextXY(x+NumHead_x+NumHead_abstand+1,y+NumHead_y,'d');
OuttextXY(x+NumHead_x+2*NumHead_abstand+Leerfeld+1,y+NumHead_y,'e');
OuttextXY(x+NumHead_x+3*NumHead_abstand+Leerfeld+1,y+NumHead_y,'f');
OuttextXY(x+NumHead_x+4*NumHead_abstand+2*Leerfeld-1,y+NumHead_y,'p(F)');
OuttextXY(x+NumHead_x+5*NumHead_abstand+3*Leerfeld-1,y+NumHead_y,'->B');
end;

procedure Loesch_Fkt_Zeile(which : Byte);
begin
SetFillStyle(Solidfill,165);
Bar(1,NumText_y+Pred(which)*NumText_abstand+1,
    Bereich_x-1,NumText_y+which*NumText_abstand+1);
end;

procedure Funktion_anzeigen(Funk:Funktionstyp;aktiv:Boolean;woy:word);
var i : Byte;
    fa,fb,fc,
    fd,fe,ff,
    pf : string[5];
    ber : char;
begin
if aktiv then
  SetColor(A_Fkt_Farbe)
else
  SetColor(P_Fkt_Farbe);
if Funk.Art then begin
  with Funk.LFunk^ do begin
    str(a :5 :2,fa);
    str(b :5 :2,fb);
    str(c :5 :2,fc);
    str(d :5 :2,fd);
    str(e :5 :2,fe);
    str(f :5 :2,ff);
    end;
  end;
str(Funk.Wahrscheinlichkeit :4 :2,pf);
ber := Funk.Bereich;
SetViewPort(0,woy,Bereich_x,NumWin_y2,True);
SetTextJustify(LeftText,BottomText);
SettextStyle(smallfont,HorizDir,Wertezeile);
Loesch_Fkt_Zeile(Funk.nummer);
if Fkt_scroll then begin
  if Funk.Art then begin
    OutTextXY(NumText_x,NumText_y+Funk.nummer*NumText_abstand,
             fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'    '+ber);
    OutTextXY(NumText_x+1,NumText_y+Funk.nummer*NumText_abstand,
             fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'    '+ber);
    end
  else begin
    OutTextXY(NumText_x,NumText_y+Funk.nummer*NumText_abstand,
              '  nichtlineare Fkt.        '+pf+'    '+ber);
    OutTextXY(NumText_x+1,NumText_y+Funk.nummer*NumText_abstand,
              '  nichtlineare Fkt.        '+pf+'    '+ber);
    end;
  end
else begin
  if Funk.Art then begin
    OutTextXY(NumText_x,NumText_y+Funk.nummer*NumText_abstand,
             fa+' '+fb+' '+fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'   '+ber);
    OutTextXY(NumText_x+1,NumText_y+Funk.nummer*NumText_abstand,
             fa+' '+fb+' '+fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'   '+ber);
    end
  else begin
    OutTextXY(NumText_x,NumText_y+Funk.nummer*NumText_abstand,
              '  nichtlineare Fkt');
    OutTextXY(NumText_x+1,NumText_y+Funk.nummer*NumText_abstand,
              '  nichtlineare Fkt');
    end;
  end;
SetViewPort(0,0,x,y,True);
end;

procedure Update_pF(Funk : Funktionstyp; aktiv : Boolean);
var i : Byte;
    fa,fb,fc,
    fd,fe,ff,
    pf : string[5];
    ber : char;
begin
if aktiv then
  SetColor(A_Fkt_Farbe)
else
  SetColor(P_Fkt_Farbe);
with Funk.LFunk^ do begin
  str(a :5 :2,fa);
  str(b :5 :2,fb);
  str(c :5 :2,fc);
  str(d :5 :2,fd);
  str(e :5 :2,fe);
  str(f :5 :2,ff);
  end;
str(Funk.Wahrscheinlichkeit :4 :2,pf);
ber := Funk.Bereich;
SetViewPort(0,NumWin_y1,x div 4 - 1,NumWin_y2,True);
SetTextJustify(LeftText,BottomText);
SettextStyle(smallfont,HorizDir,Wertezeile);
Loesch_Fkt_Zeile(Funk.nummer);
if Funk.Art then begin
  OutTextXY(NumText_x,NumText_y+Funk.nummer*NumText_abstand,
            fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'    '+ber);
  OutTextXY(NumText_x+1,NumText_y+Funk.nummer*NumText_abstand,
            fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'    '+ber);
  end
else begin
  OutTextXY(NumText_x,NumText_y+Funk.nummer*NumText_abstand,
            '  nichtlineare Fkt.        '+pf+'    '+ber);
  OutTextXY(NumText_x+1,NumText_y+Funk.nummer*NumText_abstand,
            '  nichtlineare Fkt.        '+pf+'    '+ber);
  end;
SetViewPort(0,0,x,y,True);
end;

procedure Alle_Fkt_anzeigen(Bereich : Single_IFS; aktiv : Byte);
var i : Byte;
    fa,fb,fc,
    fd,fe,ff,
    pf : string[5];
    ber : char;
begin
Fkt_Fenster;
if Fkt_scroll then
  Fkt_Header2(0,Numwin_y1)
else
  Fkt_Header1(0,Numwin_y1);
if Bereich.Anzahl_Fkt < 1 then
  Exit;
SetViewPort(0,NumWin_y1,Bereich_x,NumWin_y2,True);
SetTextJustify(LeftText,BottomText);
SettextStyle(smallfont,HorizDir,Wertezeile);
for i := 1 to Bereich.Anzahl_Fkt do begin
  if Bereich.Funktion[i]^.Art then
    with Bereich.Funktion[i]^.LFunk^ do begin
      str(a :5 :2,fa);
      str(b :5 :2,fb);
      str(c :5 :2,fc);
      str(d :5 :2,fd);
      str(e :5 :2,fe);
      str(f :5 :2,ff);
      end;
  str(Bereich.Funktion[i]^.Wahrscheinlichkeit :4 :2,pf);
  ber := Bereich.Funktion[i]^.Bereich;
  if i = aktiv then
    SetColor(A_Fkt_Farbe)
  else
    SetColor(P_Fkt_Farbe);
  if Fkt_scroll then begin
    if Bereich.Funktion[i]^.Art then begin
      OutTextXY(NumText_x,NumText_y+i*NumText_abstand,
               fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'    '+ber);
      OutTextXY(NumText_x+1,NumText_y+i*NumText_abstand,
               fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'    '+ber);
      end
    else begin
      OutTextXY(NumText_x,NumText_y+i*NumText_abstand,
                '  nichtlineare Fkt.        '+pf+'    '+ber);
      OutTextXY(NumText_x+1,NumText_y+i*NumText_abstand,
                '  nichtlineare Fkt.        '+pf+'    '+ber);
      end;
    end
  else begin
    if Bereich.Funktion[i]^.Art then begin
      OutTextXY(NumText_x,NumText_y+i*NumText_abstand,
               fa+' '+fb+' '+fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'   '+ber);
      OutTextXY(NumText_x+1,NumText_y+i*NumText_abstand,
               fa+' '+fb+' '+fc+' '+fd+'  '+fe+' '+ff+'   '+pf+'   '+ber);
      end
    else begin
      OutTextXY(NumText_x,NumText_y+i*NumText_abstand,
                '  nichtlineare Fkt');
      OutTextXY(NumText_x+1,NumText_y+i*NumText_abstand,
                '  nichtlineare Fkt');
      end;
    end;
  end;
SetViewPort(0,0,x,y,True);
end;

procedure MRFS_anzeigen(Bereich:Single_IFS; aktiv:Byte);
var i,j,k : Byte;
    s : string;
begin
Fkt_Fenster;                         { lscht Darstellung der Funktionswerte}
if Bereich.Anzahl_Fkt = 0 then
  Exit;
SetTextStyle(SmallFont,HorizDir,5);
SetTextJustify(LeftText,BottomText);
MoveTo(10,NumWin_y1+40);
OutText(Bereich.Bereichsnummer + ' -> ');
MoveTo(11,NumWin_y1+40);
OutText(Bereich.Bereichsnummer + ' -> ');
k := 1;
i := 0;
repeat
  if k = aktiv then
    SetColor(F_Text_rot);
  MoveTo(50+(i mod 3)*56,NumWin_y1+40+(i div 3)*30);
  OutText('f');
  MoveTo(51+(i mod 3)*56,NumWin_y1+40+(i div 3)*30);
  OutText('f');
  SetTextStyle(SmallFont,HorizDir,4);
  if k < 10 then
    Str(k:1,s)
  else
    Str(k:2,s);
  MoveTo(55+(i mod 3)*56,NumWin_y1+43+(i div 3)*30);
  OutText(s);
  MoveTo(56+(i mod 3)*56,NumWin_y1+43+(i div 3)*30);
  OutText(s);
  SetTextStyle(SmallFont,HorizDir,5);
  MoveTo(71+(i mod 3)*56,NumWin_y1+40+(i div 3)*30);
  OutText('('+Bereich.Funktion[k]^.Bereich+')');
  MoveTo(72+(i mod 3)*56,NumWin_y1+40+(i div 3)*30);
  OutText('('+Bereich.Funktion[k]^.Bereich+')');
  SetColor(F_Text);
  if k < Bereich.Anzahl_Fkt then begin
    MoveTo(94+(i mod 3)*56,NumWin_y1+40+(i div 3)*30);
    OutText('+');
    end;
  Inc(i);
  Inc(k);
until k > Bereich.Anzahl_Fkt;
SetColor(F_Text);
Line(0,NumWin_y2-70,Bereich_x,NumWin_y2-70);
if Fkt_scroll then
  Fkt_Header2(0,Numwin_y2-70)
else
  Fkt_Header1(0,Numwin_y2-70);
j := Pred(Bereich.Funktion[aktiv]^.nummer) * NumText_abstand;
Funktion_anzeigen(Bereich.Funktion[aktiv]^,True,NumWin_y2-70-j);
end;

procedure MRFS_update(FktNr: Byte; NeuBereich: char);
var i,j,k : Byte;
    s : string;
begin
SetColor(F_Text_rot);
SetTextStyle(SmallFont,HorizDir,5);
SetTextJustify(LeftText,BottomText);
k := FktNr;
i := Pred(k);
SetFillStyle(SolidFill,F_Funktion);
Bar(71+(i mod 3)*56,NumWin_y1+40+(i div 3)*30-10,
    86+(i mod 3)*56,NumWin_y1+40+(i div 3)*30);
MoveTo(71+(i mod 3)*56,NumWin_y1+40+(i div 3)*30);
OutText('('+NeuBereich+')');
MoveTo(72+(i mod 3)*56,NumWin_y1+40+(i div 3)*30);
OutText('('+NeuBereich+')');
end;

procedure Gib_mir_PSpeicher;
var i,j : Byte;
begin
if Loesch_F_Poly <> nil then begin
  FreeMem(Loesch_F_Poly,sizeof(Polytyp));
  Loesch_F_Poly := nil;
  end;
i := 1;
while (i < Max_Bereiche) and (Poly_Liste[i].B_Poly <> nil) do begin
  with Poly_Liste[i] do begin
    FreeMem(B_Poly,sizeof(Polytyp));
    B_Poly := nil;
    j := 1;
    while (j < Max_Funktionen) and
          ((F_Poly[j] <> nil) or (NF_Poly[j] <> nil)) do begin
      if F_Poly[j] <> nil then begin                 { lineares Fkt-Polygon }
        FreeMem(F_Poly[j],sizeof(Polytyp));
        F_Poly[j] := nil;
        end;
      if NF_Poly[j] <> nil then begin           { nichtlineares Fkt-Polygon }
        FreeMem(NF_Poly[j],sizeof(NPolytyp));
        NF_Poly[j] := nil;
        end;
      Inc(j);
      end;
    end;
  Inc(i);
  end;
end;
{-------------------------------------------------------------------------}
begin
Wk_Win[0].x := 0; Wk_Win[0].y := 0;
Wk_Win[1].x := 1; Wk_Win[1].y := 0;
Wk_Win[2].x := 1; Wk_Win[2].y := 1;
Wk_Win[3].x := 0; Wk_Win[3].y := 1;
for i := 1 to 15 do begin
  Poly_Liste[i].B_Poly := nil;
  for j := 1 to 15 do begin
    Poly_Liste[i].F_Poly[j] := nil;
    Poly_Liste[i].NF_Poly[j] := nil;
    end;
  Visible[i].Bereich := True;
  Visible[i].Funktion := True;
  Visible[i].Fixpunkt := True;
  end;
Loesch_F_Poly := nil;
Loesch_NF_Poly := nil;
end.