{$O+}
unit ifs_menue;
INTERFACE
uses crt,graph,dos,mymouse,xms,ifs_def,ifs_item,ifs_win,
     ifs_gedit,ifs_algo,ifs_rgb,ifs_twin;

const Visible_Lineal : Boolean = TRUE;
const IfsAnzeige     : Boolean = TRUE;
const BildrechenFlag : Boolean = TRUE;

procedure Lineal_unten;
procedure Lineal_links;
procedure Lineal_loeschen(which: Byte);
procedure Fang_Werte;
procedure Menueleiste;
procedure Menue1;
procedure Menue2;
procedure Menue3;
procedure AusstiegsMenue(var raus: Boolean);

IMPLEMENTATION

const Out_of_menue = 255;
      in_spacebar  = 200;
      MaxFiles     = 50;
      saveit       : Boolean = TRUE;
      savergb      : Boolean = TRUE;
      loadrgb      : Boolean = TRUE;
      LinealFlag   : Boolean = FALSE;

type MRFS  = record
             Anzahl : Byte;
             Sicht  : Array[1..15] of Visirec;
             aktiv  : Array[0..15] of Byte;    {0 - Bereich, 1-15 - Funktion}
             ASicht : Array[1..15] of Byte;    {Modi fr Attraktorberechnung}
             scale  : Real;
             scrollx,
             scrolly: Integer;
             end;
     IFS_F = record
             _Funk : Funktionstyp;
             _Rest : LRTable;
             end;
     FLTyp = Array[1..MaxFiles] of String[12];
     Luprec = record
              LNummer : Byte;
              LFaktor : double;
              Lscrollx,
              Lscrolly: integer;
              end;

var Thoch, Breite,
    abstand, anfang: word;
    Sperre         : Array[1..15] of Boolean;
    HistoLup       : Array[1..5] of Luprec;
    LupAnz         : Byte;
    LadeFlag       : Boolean;
    AenderungsFlag : Boolean;
    Menue_already_closed : Boolean;
    MRFSFile : File of MRFS;
    BIFSFile : File of Single_IFS;
    FIFSFile : File of IFS_F;
    LFFile   : File of lineare_Funktion;
    NFFile   : File of NonLin_Funktion;

procedure Wahrscheinlichkeit_aendern; forward;
procedure BezugsBereich_aendern; forward;

{***************************************************************************}
{*   zeichnet das untere Lineal                                            *}
{***************************************************************************}
procedure Lineal_unten;
var i,temp1,temp2,
    xpos,lastpos : integer;
    abstand : real;
    wert : string;
begin
abstand := 5.5{*Skalierung};
SetColor(F_Text_rot);
lastpos := round(50{/Skalierung});
SetFillStyle(Solidfill,20);
Bar(GraphWin_x+1,y-Lineal_b+1,x-Lineal_b-1,y-1);
for i := 1 to lastpos do begin
  xpos := GraphWin_x+round(i*2*abstand);
  temp1 := scroll_x div 11;
  temp2 := (temp1+5) mod 5;
  if xpos < x - Lineal_b - 1 then
    if (i+temp2) mod 5 = 0 then begin
      Line(xpos,y-Lineal_b div 2,xpos,y-Lineal_b+ Lineal_b div 10);
      Str(round((i+temp1)*2/Skalierung),wert);
      SetTextStyle(Smallfont,HorizDir,4);
      SetTextJustify(CenterText,BottomText);
      OutTextXY(xpos,y-2,wert);
      OutTextXY(xpos+1,y-2,wert);
      SetColor(F_Text_rot);
      end
    else
      Line(xpos,y-Lineal_b div 2,xpos,y-Lineal_b div 4 * 3);
  end;
end;

{***************************************************************************}
{*   zeichnet das linke Lineal                                             *}
{***************************************************************************}
procedure Lineal_links;
var i,temp1,temp2,
    ypos,lastpos : integer;
    abstand : real;
    wert : string;
begin
abstand := 5.5{*Skalierung};
SetColor(F_Text_rot);
lastpos := round(50{/Skalierung});
SetFillStyle(Solidfill,20);
Bar(Bereich_x+1,Menue_y+Lineal_b+1,GraphWin_x-1,y-Lineal_b-1);
for i := 1 to lastpos do begin
  ypos := y-Lineal_b-round(i*2*abstand);
  temp1 := scroll_y div 11;
  temp2 := (temp1 + 5) mod 5;
  if ypos > Menue_y+Lineal_b+1 then
    if (i+temp2) mod 5 = 0 then begin
      Line(Bereich_x+Lineal_b div 2,ypos,Bereich_x+Lineal_b-Lineal_b div 10,ypos);
      Str(round((i+temp1)*2/Skalierung),wert);
      SetTextStyle(Smallfont,HorizDir,4);
      SetTextJustify(LeftText,BottomText);
      OutTextXY(Bereich_x + 2,ypos,wert);
      OutTextXY(Bereich_x + 3,ypos,wert);
      end
    else
      Line(Bereich_x+Lineal_b div 2,ypos,Bereich_x+Lineal_b div 4 * 3,ypos);
  end;
end;

procedure Lineal_loeschen(which: Byte);
begin
SetFillStyle(Solidfill,20);
if which = 0 then
  Bar(Bereich_x+1,Menue_y+Lineal_b+1,GraphWin_x-1,y-Lineal_b-1)
else
  Bar(GraphWin_x+1,y-Lineal_b+1,x-Lineal_b-1,y-1);
end;

{***************************************************************************}
{*   liefert eine Auswahlliste an Filenamen                                *}
{***************************************************************************}
procedure GetFileList(SearchPattern:String;x,y:Word;row,col:Byte;
                      var FileList:FLTyp; var Anzahl: Byte);
var S : Searchrec;
    Anz,i,j : Byte;
    swap    : string[12];
begin
S.Name := SearchPattern;
FindFirst('IFS\*.mfs',AnyFile,S);
if DosError <> 0 then begin
  FileList[1] := 'NOFILES';
  Exit;
  end;
FileList[1] := S.Name;
Anz := 1;
while (DosError = 0) and (Anz <= MaxFiles) do begin
  FindNext(S);
  if DosError = 0 then begin
    Inc(Anz);
    FileList[Anz] := S.Name;
    end;
  end;
for i := 2 to Anz do begin                         { alphabetisch sortieren }
  swap := FileList[i];
  j := i;
  while FileList[Pred(j)] > swap do begin
    FileList[j] := FileList[Pred(j)];
    Dec(j);
    end;
  FileList[j] := swap;
  end;
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(LeftText,BottomText);
SetColor(F_Text);
for i := 1 to Anz do begin
  OutTextXY(x+(Pred(i) mod col)*130,y+(Pred(i) div col)*15,FileList[i]);
  end;
Anzahl := Anz;
end;

{***************************************************************************}
{*   zeichnet einen Schalter (hell = On, dunkel = Off)                     *}
{***************************************************************************}
procedure Schalter(x,y: integer; On: Boolean; Text:string);
begin
SetColor(F_Text);
SetFillStyle(Solidfill,F_Text);
Bar(x,y,x+50,y+30);
if On then
  SetFillStyle(SolidFill,F_Funktion)
else
  SetFillStyle(SolidFill,F_Bereich);
Bar(Succ(x),Succ(y),x+48,y+28);
SetTextStyle(SmallFont,HorizDir,5);
SetTextJustify(CenterText,CenterText);
OutTextXY(x+25,y+14,Text);
end;

{***************************************************************************}
{*   zeichnet einen Dipschalter(0/1)                                       *}
{***************************************************************************}
procedure Dipschalter(x,y: integer; benutzt,On: Boolean);
begin
SetColor(F_Text);
MoveTo(x,y);
LineRel(20,0);
LineRel(0,40);
LineRel(-20,0);
LineRel(0,-40);
Line(x,y+20,x+20,y+20);
if benutzt then
  if On then begin
    SetFillStyle(SolidFill,F_Bereich);
    Bar(Succ(x),y+21,x+19,y+39);
    SetFillStyle(SolidFill,F_Funktion);
    Bar(Succ(x),Succ(y),x+19,y+19);
    end
  else begin
    SetFillStyle(SolidFill,F_Funktion);
    Bar(Succ(x),y+21,x+19,y+39);
    SetFillStyle(SolidFill,F_Bereich);
    Bar(Succ(x),Succ(y),x+19,y+19);
    end
else begin
  SetFillStyle(SolidFill,30);
  Bar(Succ(x),Succ(y),x+19,y+19);
  SetFillStyle(SolidFill,35);
  Bar(Succ(x),y+21,x+19,y+39);
  end;
SetTextStyle(SmallFont,HorizDir,5);
SetTextJustify(CenterText,CenterText);
OutTextXY(x+10,y+10,'1');
OutTextXY(x+10,y+30,'0');
end;

{***************************************************************************}
{*   ndert einen Wert einer linearen Funktion                             *}
{***************************************************************************}
procedure Edit_Fktwert(which: char; var Wert: real; var code:integer);
var Breite,Hoehe,
    winx,winy,    
    savemouse_x,
    savemouse_y,
    Zeile,Spalte : word;
    Anz_Zeichen,i: Byte;
    Ende         : Boolean;
    Wertestring  : String;
begin
savemouse_x := mx;
savemouse_y := my;
Breite := 300;
Hoehe := 150;
winx := 300;
winy := 100;
Ende := FALSE;
MouseWeg;
Open_Text_Win(1,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Funktionswert ndern');
OutTextXY(winx+1+Breite div 2,winy+20,'Funktionswert ndern');
SetFillStyle(SolidFill,F_Text);
Bar(winx+20,winy+Hoehe-50,winx+Breite div 2 - 10,winy+Hoehe-20);
Bar(winx+Breite div 2 + 10,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
Bar(winx+22,winy+Hoehe-48,winx+Breite div 2 - 15,winy+Hoehe-25);
Bar(winx+Breite div 2 + 12,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
OutTextXY(winx+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+1+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+3*(Breite div 4),winy+Hoehe-37,'OK');
OutTextXY(winx+1+3*(Breite div 4),winy+Hoehe-37,'OK');
Entprellen;
mx := winx+4*(Breite div 5);
my := winy+Hoehe-40;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
SetColor(F_Linie);
WriteXY(winx+80,winy+70,which);
i := 0;
if Abs(Wert) > 10 then
 if Abs(Wert) > 100 then
   i := 2
 else
   i := 1;
Str(Wert:5:4-i,Wertestring);
if Wert < 0 then
  Rectangle(winx+110,winy+55,winx+205,winy+75)
else
  Rectangle(winx+110,winy+55,winx+190,winy+75);
repeat
  repeat
    SetFillStyle(SolidFill,F_Fenster);
    Bar(winx+115,winy+56,winx+185,winy+74);
    if Wertestring[1] = '-' then
      Edit(Wertestring,E_Real,7,winx+115,winy+70,F_Text,F_Fenster,Code)
    else
      Edit(Wertestring,E_Real,6,winx+115,winy+70,F_Text,F_Fenster,Code);
    if Code = 255 then
      HelpMe(60);
  until ButtonPressed;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { Abbrechen }
     (mx > winx+20) and (mx < winx+Breite div 2 - 10) then begin
    Code := -1;
    Ende := TRUE;
    end;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { OK }
     (mx > winx+Breite div 2 + 10) and (mx < winx+Breite - 20) then begin
    Ende := TRUE;
    if Code = 0 then
      Val(Wertestring,Wert,Code);
    end;
until Ende;
MouseWeg;
Close_Text_Win(1,winx,winy);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
end;

procedure Fang_Werte;
var i,j,k,
    afold  : Byte;
    Code   : integer;
begin
if Anzahl_Bereiche = 0 then
  Exit;
if ArbeitsBereich^.Anzahl_Fkt = 0 then
  Exit;
if Funktionsanzeige then begin
  i := (my - NumWin_y1 - NumText_y) div NumText_abstand + 1;
  with ArbeitsBereich^ do begin
    if(i <= Anzahl_Fkt) and (i <> Aktive_Fkt[Aktiver_Bereich]) then begin
      MouseWeg;
      Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,inaktiv,fix);
      Draw_Funktion(Aktiver_Bereich,i,sichtbar,aktiv,fix);
      Funktion_anzeigen(Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                        inaktiv,NumWin_y1);
      Funktion_anzeigen(Funktion[i]^,aktiv,NumWin_y1);
      Aktive_Fkt[Aktiver_Bereich] := i;
      MouseHer;
      end
    else begin
      j := (mx - NumText_x) div ((NumWin_x-2*NumText_x) div 6)+1;
      if Fkt_scroll then
        Inc(j,2);
      if (i <= Anzahl_Fkt) and Funktion[i]^.Art then begin
        with Funktion[i]^.LFunk^ do
          case j of
            1 : Edit_Fktwert(chr(96+j),a,Code);
            2 : Edit_Fktwert(chr(96+j),b,Code);
            3 : Edit_Fktwert(chr(96+j),c,Code);
            4 : Edit_Fktwert(chr(96+j),d,Code);
            5 : Edit_Fktwert(chr(96+j),e,Code);
            6 : Edit_Fktwert(chr(96+j),f,Code);
            7 : Wahrscheinlichkeit_aendern;
            8 : BezugsBereich_aendern;
            end;
        if Code = 0 then begin
          Set_Lastop(3);
          Funk_sichern(Funktion[i]^);
          MouseWeg;
          Draw_Funktion(Aktiver_Bereich,i,unsichtbar,aktiv,fix);
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^);
          Draw_Funktion(Aktiver_Bereich,i,sichtbar,aktiv,fix);
          Funktion_anzeigen(Funktion[i]^,aktiv,NumWin_y1);
          if AttraktorFlag then
            BildLoeschen;
          Refresh(Aktiver_Bereich,i,fix,fix);
          MouseHer;
          end;
        if AenderungsFlag then begin 
          MouseWeg;
          Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                            aktiv,NumWin_y1);
          MouseHer;
          if AttraktorFlag then begin
            BildLoeschen;
            Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
            end;
          AenderungsFlag := False;
          end;
        end
      else
        if (i <= Anzahl_Fkt) then begin
          case j of
            7 : Wahrscheinlichkeit_aendern;
            8 : BezugsBereich_aendern;
            end;
          if AenderungsFlag then begin
            MouseWeg;
            Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                              aktiv,NumWin_y1);
            MouseHer;
            if AttraktorFlag then begin
              BildLoeschen;
              Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
              end;
            AenderungsFlag := False;
            end;
          end;
      end;
    end;
  end
else begin                                                 { MRFS - Anzeige }
  i := Aktive_Fkt[Aktiver_Bereich];
  if (my > NumWin_y2-40) and (my < NumWin_y2-20) then begin
    j := (mx - NumText_x) div ((NumWin_x-2*NumText_x) div 6)+1;
    if Fkt_scroll then
      Inc(j,2);
    with ArbeitsBereich^ do begin
      if Funktion[i]^.Art then begin
        with Funktion[i]^.LFunk^ do
          case j of
            1 : Edit_Fktwert(chr(96+j),a,Code);
            2 : Edit_Fktwert(chr(96+j),b,Code);
            3 : Edit_Fktwert(chr(96+j),c,Code);
            4 : Edit_Fktwert(chr(96+j),d,Code);
            5 : Edit_Fktwert(chr(96+j),e,Code);
            6 : Edit_Fktwert(chr(96+j),f,Code);
            7 : Wahrscheinlichkeit_aendern;
            8 : BezugsBereich_aendern;
            end;
        if Code = 0 then begin
          Set_Lastop(3);
          Funk_sichern(Funktion[i]^);
          MouseWeg;
          Draw_Funktion(Aktiver_Bereich,i,unsichtbar,aktiv,fix);
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^);
          Draw_Funktion(Aktiver_Bereich,i,sichtbar,aktiv,fix);
          k := Pred(Funktion[i]^.nummer) * NumText_abstand;
          Funktion_anzeigen(Funktion[i]^,aktiv,NumWin_y2-70-k);
          if AttraktorFlag then
            BildLoeschen;
          Refresh(Aktiver_Bereich,i,fix,fix);
          MouseHer;
          end;
        if AenderungsFlag then begin
          MouseWeg;
          k := Pred(Funktion[i]^.nummer) * NumText_abstand;
          Funktion_anzeigen(Funktion[i]^,aktiv,NumWin_y2-70-k);
          MRFS_Update(Aktive_Fkt[Aktiver_Bereich],
                      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Bereich);
          MouseHer;
          if AttraktorFlag then begin
            BildLoeschen;
            Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
            end;
          AenderungsFlag := False;
          end;
        end
      else
        if (i <= Anzahl_Fkt) then begin
          case j of
            7 : Wahrscheinlichkeit_aendern;
            8 : BezugsBereich_aendern;
            end;
          if AenderungsFlag then begin
            MouseWeg;
            k := Pred(Funktion[i]^.nummer) * NumText_abstand;
            Funktion_anzeigen(Funktion[i]^,aktiv,NumWin_y2-70-k);
            MRFS_Update(Aktive_Fkt[Aktiver_Bereich],
                        Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Bereich);
            MouseHer;
            if AttraktorFlag then begin
              BildLoeschen;
              Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
              end;
            AenderungsFlag := False;
            end;
          end;
      end;
    end;
  if my < NumWin_y1 + 26 then
    i := 0
  else
    i := (my - NumWin_y1 - 26) div 30 + 1;
  if (mx < 50) or (mx > 204) then
    j := 0
  else
    j := (mx - 50) div 56 + 1;
  if (i = 0) or (j = 0) or (Pred(i)*3+j > ArbeitsBereich^.Anzahl_Fkt) then
    Exit;
  k := (mx - 50 - Pred(j)*56) mod 56;
  case k of
     0..18 : begin
             Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                           sichtbar,inaktiv,fix);
             Aktive_Fkt[Aktiver_Bereich] := 3*Pred(i)+j;
             Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                           sichtbar,aktiv,fix);
             MouseWeg;
             MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
             MouseHer;
             end;
    21..44 : begin
             if Pred(i)*3 + j = Aktive_Fkt[Aktiver_Bereich] then begin
               BezugsBereich_aendern;
               if AenderungsFlag then begin
                 MouseWeg;
                 with ArbeitsBereich^ do begin
                   j := Pred(Funktion[i]^.nummer) * NumText_abstand;
                   Funktion_anzeigen(Funktion[i]^,aktiv,NumWin_y2-70-j);
                   MRFS_Update(Aktive_Fkt[Aktiver_Bereich],
                               Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Bereich);
                   end;
                 MouseHer;
                 if AttraktorFlag then begin
                   BildLoeschen;
                   Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
                   end;
                 AenderungsFlag := False;
                 end;
               end;
             end;
    end;
  end;
EntPrellen;
end;

{***************************************************************************}
{*   ndert den Mastab fr die Darstellung der Polygone                   *}
{***************************************************************************}
procedure Maszstab_aendern;
var Breite,winx,winy : word;
    savemouse_x,
    savemouse_y      : integer;
    Nummer           : Byte;
    ch               : char;
    Ende             : Boolean;
    Faktor,old_scale : double;
  procedure Balken(Nummer:Byte);
  var i : Byte;
  begin
  SetWriteMode(1);
  SetColor(64);
  for i := 1 to 20 do
    Line(winx+30,winy+20+20*Nummer+i,winx+Breite-30,winy+20+20*Nummer+i);
  setWriteMode(0);
  end;
begin
Ende := FALSE;
old_scale := Skalierung;
winx := 150;
winy := 80;
savemouse_x := mx;
savemouse_y := my;
MouseWeg;
Breite := 200;
Open_Text_Win(2,winx,winy,Breite,220,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Mastab ndern');
OutTextXY(winx+1+Breite div 2,winy+20,'Mastab ndern');
SetFillStyle(SolidFill,F_Text);
Bar(winx+50,winy+180,winx+150,winy+210);
SetFillStyle(SolidFill,70);
Bar(winx+52,winy+182,winx+145,winy+205);
OutTextXY(winx+Breite div 2,winy+193,'OK');
OutTextXY(winx+1+Breite div 2,winy+193,'OK');
OutTextXY(winx+Breite div 2,winy+50,' 50 %');
OutTextXY(winx+Breite div 2+1,winy+50,' 50 %');
OutTextXY(winx+Breite div 2,winy+70,' 75 %');
OutTextXY(winx+Breite div 2+1,winy+70,' 75 %');
OutTextXY(winx+Breite div 2,winy+90,'100 %');
OutTextXY(winx+Breite div 2+1,winy+90,'100 %');
OutTextXY(winx+Breite div 2,winy+110,'150 %');
OutTextXY(winx+Breite div 2+1,winy+110,'150 %');
OutTextXY(winx+Breite div 2,winy+130,'200 %');
OutTextXY(winx+Breite div 2+1,winy+130,'200 %');
OutTextXY(winx+Breite div 2,winy+150,'Wahlfrei');
OutTextXY(winx+Breite div 2+1,winy+150,'Wahlfrei');
EntPrellen;
if Skalierung = 1 then Nummer := 3
else if Skalierung = 0.5 then Nummer := 1
  else if Skalierung = 0.75 then Nummer := 2
    else if Skalierung = 1.5 then Nummer := 4
      else if Skalierung = 2 then Nummer := 5
        else Nummer := 6;
Balken(Nummer);
mx := winx+130;
my := winy+200;
MouseHer;
SetMouseBereich(winx,winy,winx+Breite,winy+200);
repeat
  repeat
    Mouse_bewegen;
    if KeyPressed then begin
      ch := ReadKey;
      if ch = Chr(0) then
        ch := Readkey;
        if ch = Chr(59) then begin
          SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
          HelpMe(21);
          SetMouseBereich(winx,winy,winx+Breite,winy+200);
          end;
      if KeyPressed then
      repeat ch := ReadKey; until not KeyPressed
      end;
  until ButtonPressed;
  if (mx > winx+50) and (mx < winx+150) and
     (my > winy+180) and (my < winy+210) then
    Ende := TRUE;
  if (mx > winx+50) and (mx < winx+150) then
    if (my > winy+40)  and (my < winy+60) then begin
      Skalierung := 0.5;
      MouseWeg;
      Balken(Nummer);
      Nummer := 1;
      Balken(Nummer);
      MouseHer;
      end
    else if (my > winy+60) and (my < winy+80) then begin
      Skalierung := 0.75;
      MouseWeg;
      Balken(Nummer);
      Nummer := 2;
      Balken(Nummer);
      MouseHer;
      end
    else if (my > winy+80) and (my < winy+100) then begin
      Skalierung := 1;
      MouseWeg;
      Balken(Nummer);
      Nummer := 3;
      Balken(Nummer);
      MouseHer;
      end
    else if (my > winy+100) and (my < winy+120) then begin
      Skalierung := 1.5;
      MouseWeg;
      Balken(Nummer);
      Nummer := 4;
      Balken(Nummer);
      MouseHer;
      end
    else if (my > winy+120) and (my < winy+140) then begin
      Skalierung := 2;
      MouseWeg;
      Balken(Nummer);
      Nummer := 5;
      Balken(Nummer);
      MouseHer;
      end;
until Ende;
EntPrellen;
if Nummer <> 6 then
  LupAnz := 0;
MouseWeg;
Close_Text_Win(2,winx,winy);
SetMouseBereich(0,0,x,y);
LinealFlag := True;
if Aktiver_Bereich > 0 then begin
  Bildloeschen;
  Faktor := Skalierung / old_scale;
  Scale_all(Faktor);
  Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],TRUE,TRUE);
  end;
mx := savemouse_x;
my := savemouse_y;
MouseHer;
end;

{***************************************************************************}
{*   Lupe, Auswahl eines Bereiches, der auf Arbeitsflche vergrert wird  *}
{***************************************************************************}
procedure Lupe;
var p1,p2,pold  : PunktTyp;
    savemouse_x,
    savemouse_y : integer;
    Faktor      : real;
    ch          : char;
begin
if RightButton then begin
  EntPrellen;
  if LupAnz < 1 then   begin
    MouseWeg;
    Close_Text_Win(1,0,Menue_y);
    Menue_already_closed := True;
    MouseHer;
    Exit;
    end;
  with HistoLup[LupAnz] do begin
    Skalierung := Skalierung / LFaktor;
    scroll_x := scroll_x - Lscrollx;
    scroll_y := scroll_y - Lscrolly;
    Scale_All(1/LFaktor);
    end;
  Dec(LupAnz);
  LinealFlag := True;
  Bildloeschen;
  MouseWeg;
  Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
  Close_Text_Win(1,0,Menue_y);
  Menue_already_closed := True;
  MouseHer;
  Exit;
  end;
Entprellen;
if LupAnz >= 5 then begin
  MouseWeg;
  Close_Text_Win(1,0,Menue_y);
  Menue_already_closed := True;
  MouseHer;
  Exit;
  end;
savemouse_x := mx;
savemouse_y := my;
MouseWeg;
mx := GraphWin_x + 10;
my := Menue_y + 10;
SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
MouseHer;
EntPrellen;
repeat
  Mouse_bewegen;                                {1.Punkt des Ausschnittes}
  if KeyPressed then begin
    ch := ReadKey;
    if ch = Chr(0) then
      ch := Readkey;
      if ch = Chr(59) then 
        HelpMe(22);
    if KeyPressed then
    repeat ch := ReadKey; until not KeyPressed
    end;
until ButtonPressed;
if RightButton then begin
  MouseWeg;
  mx := savemouse_x;
  my := savemouse_y;
  SetMouseBereich(0,0,x,y);
  Close_Text_Win(1,0,Menue_y);
  Menue_already_closed := True;
  MouseHer;
  Exit;
  end;
p1.x := mx;
p1.y := my;
p2 := p1;
EntPrellen;
SetColor(F_Text);
SetLineStyle(DashedLn,0,1);
repeat
  pold := p2;
  Mouse_bewegen;
  if KeyPressed then begin
    ch := ReadKey;
    if ch = Chr(0) then
      ch := Readkey;
      if ch = Chr(59) then
        HelpMe(22);
    if KeyPressed then
    repeat ch := ReadKey; until not KeyPressed
    end;
  p2.x := mx;
  p2.y := my;
  if (p2.x <> pold.x) or (p2.y <> pold.y) then begin
    MouseWeg;
    SetWriteMode(1);
    Rectangle(p1.x,p1.y,pold.x,pold.y);
    Rectangle(p1.x,p1.y,p2.x,p2.y);
    MouseHer;
    SetWriteMode(0);
    end;
until ButtonPressed;
MouseWeg;
SetWriteMode(1);
Rectangle(p1.x,p1.y,p2.x,p2.y);
SetWriteMode(0);
SetLineStyle(SolidLn,0,1);
MouseHer;
if RightButton then begin
  MouseWeg;
  mx := savemouse_x;
  my := savemouse_y;
  SetMouseBereich(0,0,x,y);
  Close_Text_Win(1,0,Menue_y);
  Menue_already_closed := True;
  MouseHer;
  Exit;
  end;
pold := p2;
if p1.x > p2.x then begin
  p2.x := p1.x - GraphWin_x;
  p1.x := pold.x - GraphWin_x;
  end
else begin
  p1.x := p1.x - GraphWin_x;
  p2.x := p2.x - GraphWin_x;
  end;
if p1.y < p2.y then begin
  p2.y := y - Lineal_b - p1.y;
  p1.y := y - Lineal_b - pold.y;
  end
else begin
  p2.y := y - Lineal_b - p2.y;
  p1.y := y - Lineal_b - p1.y;
  end;
if (p2.x-p1.x < 55) or (p2.y-p1.y < 55) then begin   { zu kleiner Ausschnitt }
  SetMouseBereich(0,0,x,y);
  Exit;
  end;
if (p2.x-p1.x) > (p2.y-p1.y) then
  Faktor := 550 / (p2.x-p1.x+5)
else
  Faktor := 550 / (p2.y-p1.y+5);
Faktor := trunc(Faktor * 100 + 1) / 100;
if Skalierung * Faktor >= 10 then begin
  MouseWeg;
  SetMouseBereich(0,0,x,y);
  mx := savemouse_x;
  my := savemouse_y;
  Close_Text_Win(1,0,Menue_y);
  Menue_already_closed := True;
  MouseHer;
  Exit;
  end;
Scale_all(Faktor);
scroll_x := scroll_x + trunc(p1.x*Faktor/11)*11;
scroll_y := scroll_y + trunc(p1.y*Faktor/11)*11;
Skalierung := Skalierung * Faktor;
Inc(LupAnz);
with HistoLup[LupAnz] do begin
  LFaktor := Faktor;
  Lscrollx := trunc(p1.x*Faktor/11)*11;
  Lscrolly := trunc(p1.y*Faktor/11)*11;
  end;
LinealFlag := True;
Bildloeschen;
MouseWeg;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
SetMouseBereich(0,0,x,y);
mx := savemouse_x;
my := savemouse_y;
Close_Text_Win(1,0,Menue_y);
Menue_already_closed := True;
MouseHer;
end;

{***************************************************************************}
{*   ndert die Sichtbarkeit von Arbeitsbereichen                          *}
{***************************************************************************}
procedure BereichSicht_aendern;
const benutzt = TRUE;
      unbenutzt = FALSE;
var Breite,
    winx,winy   : word;
    savemouse_x,
    savemouse_y : integer;
    i           : Byte;
    ch          : char;
    Ende        : Boolean;
begin
if Aktiver_Bereich = 0 then
  Exit;
Ende := FALSE;
winx := 150;
winy := 150;
savemouse_x := mx;
savemouse_y := my;
MouseWeg;
Breite := 400;
Open_Text_Win(2,winx,winy,Breite,160,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
Setcolor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'SichtBarkeit der Bereiche ndern');
OutTextXY(winx+1+Breite div 2,winy+20,'SichtBarkeit der Bereiche ndern');
SetFillStyle(SolidFill,F_Text);
Bar(winx+100,winy+120,winx+300,winy+150);
SetFillStyle(SolidFill,70);
Bar(winx+102,winy+122,winx+295,winy+145);
OutTextXY(winx+Breite div 2,winy+133,'Beenden');
OutTextXY(winx+1+Breite div 2,winy+133,'Beenden');
for i := 0 to Pred(Max_Bereiche) do begin
  if Succ(i) <= Anzahl_Bereiche then begin
    OutTextXY(winx+22+i*24,winy+50,Get_Bereichsnummer(Succ(i)));
    DipSchalter(winx+12+i*24,winy+70,benutzt,Visible[Succ(i)].Bereich);
    end
  else
    DipSchalter(winx+12+i*24,winy+70,unbenutzt,Visible[Succ(i)].Bereich);
  end;
mx := winx+300;
my := winy+135;
SetMouseBereich(winx,winy,winx+Breite,winy+160);
MouseHer;
repeat
  repeat
    Mouse_bewegen;
    if KeyPressed then begin
      ch := ReadKey;
      if ch = Chr(0) then
        ch := Readkey;
        if ch = Chr(59) then begin
          SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
          HelpMe(24);
          SetMouseBereich(winx,winy,winx+Breite,winy+160);
          end;
      if KeyPressed then
      repeat ch := ReadKey; until not KeyPressed
      end;
  until ButtonPressed;
  if (my > winy+120) and (my < winy+150) and
     (mx > winx+100)  and (mx < winx+300) then
    Ende := TRUE
  else begin
    if (my > winy + 70) and (my < winy + 110) then
      for i := 0 to Pred(Anzahl_Bereiche) do begin
        if (mx > (winx+12+i*24)) and (mx < (winx+32+i*24)) then begin
          if my < winy+90 then
            Visible[Succ(i)].Bereich := TRUE
          else
            Visible[Succ(i)].Bereich := FALSE;
          MouseWeg;
          DipSchalter(winx+12+i*24,winy+70,benutzt,Visible[Succ(i)].Bereich);
          MouseHer;
          end;
        end;
    end;
  Entprellen;
until Ende;
MouseWeg;
SetMouseBereich(0,0,x,y);
EntPrellen;
Close_Text_Win(2,winx,winy);
for i := 1 to Anzahl_Bereiche do
  if not Visible[i].Bereich then begin
    Visible[i].Bereich := not Visible[i].Bereich;
    Funktion_ausblenden(i);
    Draw_Bereich(i,unsichtbar,inaktiv,fix);
    Visible[i].Bereich := not Visible[i].Bereich;
    end;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],TRUE,TRUE);
mx := savemouse_x;
my := savemouse_y;
MouseHer;
end;

{***************************************************************************}
{*   Einstellungen fr die Berechnung und Anzeige des Attraktors           *}
{***************************************************************************}
procedure Bildmenue;
var Breite,Hoehe,
    winx,winy   : word;
    savemouse_x,
    savemouse_y : integer;
    i,j, Nummer : Byte;
    Ende,WegFlag: Boolean;
    Bereich,ch  : char;
begin
if Anzahl_Bereiche = 0 then
  Exit;
Ende := FALSE;
WegFlag := FALSE;
winx := 150;
winy := 150;
savemouse_x := mx;
savemouse_y := my;
MouseWeg;
Breite := 400;
Hoehe := 200+50*(Pred(Anzahl_Bereiche) div 5);
Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
Setcolor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Einstellungen fr Attraktor');
OutTextXY(winx+1+Breite div 2,winy+20,'Einstellungen fr Attraktor');
SetFillStyle(SolidFill,F_Text);
Bar(winx+50,winy+Hoehe-50,winx+Breite-50,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
Bar(winx+52,winy+Hoehe-48,winx+Breite-55,winy+Hoehe-25);
OutTextXY(winx+Breite div 2,winy+Hoehe-37,'Beenden');
OutTextXY(winx+1+Breite div 2,winy+Hoehe-37,'Beenden');
Bereich := Get_Bereichsnummer(Aktiver_Bereich);
for i := 1 to Anzahl_Bereiche do begin
  if Bereich = Get_Bereichsnummer(i) then
    Nummer := i;
  Schalter(winx+37+68*(Pred(i) mod 5),winy+55+50*(Pred(i) div 5),
           Bereich = Get_Bereichsnummer(i),Get_Bereichsnummer(i));
  end;
SetColor(F_Linie);
Circle(winx+50,winy+Hoehe-80,8);
Circle(winx+165,winy+Hoehe-80,8);
Circle(winx+265,winy+Hoehe-80,8);
SetTextJustify(LeftText,CenterText);
OutTextXY(winx+65,winy+Hoehe-80,'flieend');
OutTextXY(winx+180,winy+Hoehe-80,'gestuft');
OutTextXY(winx+280,winy+Hoehe-80,'wegblenden');
SetFillStyle(SolidFill,F_Text);
case Attraktormode[Nummer] of
  0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);
  1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);
  2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);
  end;
mx := winx+3*(Breite div 4);
my := winy+Hoehe-30;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
MouseHer;
repeat
  repeat
    Mouse_bewegen;
    if KeyPressed then begin
      ch := ReadKey;
      if ch = Chr(0) then
        ch := Readkey;
        if ch = Chr(59) then begin
          SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
          HelpMe(27);
          SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
          end;
      if KeyPressed then
      repeat ch := ReadKey; until not KeyPressed
      end;
  until ButtonPressed;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and
     (mx > winx+50)  and (mx < winx+Breite-50) then
    Ende := TRUE;
  for i := 1 to Anzahl_Bereiche do
    if (mx > winx+37+68*(Pred(i) mod 5)) and                 {Welcher Bereich}
       (mx < winx+87+68*(Pred(i) mod 5)) and
       (my > winy+55+50*(Pred(i) div 5)) and
       (my < winy+85+50*(Pred(i) div 5)) then begin
      j := Nummer;
      Nummer := i;
      MouseWeg;
      Schalter(winx+37+68*(Pred(j) mod 5),winy+55+50*(Pred(j) div 5),
               FALSE,Get_Bereichsnummer(j));
      Schalter(winx+37+68*(Pred(i) mod 5),winy+55+50*(Pred(i) div 5),
               TRUE,Get_Bereichsnummer(i));
      MouseHer;
      if Attraktormode[j] <> Attraktormode[i] then begin
        SetFillStyle(SolidFill,F_Fenster);
        SetColor(F_Fenster);
        case Attraktormode[j] of                             {Einstellung fr}
          0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);      {alten Bereich  }
          1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);      {wegblenden     }
          2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);
          end;
        SetFillStyle(SolidFill,F_Text);
        SetColor(F_Text);
        case Attraktormode[Nummer] of
          0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);      {Einstellung fr}
          1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);      {neuen Bereich  }
          2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);       {einblenden     }
          end;
        end;
      end;
  if (Sqr(mx-winx-50) + Sqr(my-winy-Hoehe+80)) < 64 then begin      {flieend}
    if Attraktormode[Nummer] <> 2 then begin
      SetFillStyle(SolidFill,F_Fenster);
      SetColor(F_Fenster);
      case Attraktormode[Nummer] of
        0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);
        1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);
        2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);
        end;
      Attraktormode[Nummer] := 2;
      SetFillStyle(SolidFill,F_Text);
      SetColor(F_Text);
      MouseWeg;
      case Attraktormode[Nummer] of
        0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);
        1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);
        2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);
        end;
      MouseHer;
      end;
    end;
  if (Sqr(mx-winx-165) + Sqr(my-winy-Hoehe+80)) < 64 then begin      {gestuft}
    if Attraktormode[Nummer] <> 1 then begin
      SetFillStyle(SolidFill,F_Fenster);
      SetColor(F_Fenster);
      case Attraktormode[Nummer] of
        0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);
        1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);
        2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);
        end;
      Attraktormode[Nummer] := 1;
      SetFillStyle(SolidFill,F_Text);
      SetColor(F_Text);
      MouseWeg;
      case Attraktormode[Nummer] of
        0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);
        1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);
        2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);
        end;
      MouseHer;
      end;
    end;
  if (Sqr(mx-winx-265) + Sqr(my-winy-Hoehe+80)) < 64 then begin   {wegblenden}
    if Attraktormode[Nummer] <> 0 then begin
      SetFillStyle(SolidFill,F_Fenster);
      SetColor(F_Fenster);
      case Attraktormode[Nummer] of
        0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);
        1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);
        2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);
        end;
      Attraktormode[Nummer] := 0;
      SetFillStyle(SolidFill,F_Text);
      SetColor(F_Text);
      MouseWeg;
      case Attraktormode[Nummer] of
        0 : PieSlice(winx+265,winy+Hoehe-80,0,360,5);
        1 : PieSlice(winx+165,winy+Hoehe-80,0,360,5);
        2 : PieSlice(winx+50,winy+Hoehe-80,0,360,5);
        end;
      WegFlag := TRUE;
      MouseHer;
      end;
    end;
until Ende;
MouseWeg;
SetMouseBereich(0,0,x,y);
EntPrellen;
Close_Text_Win(2,winx,winy);
mx := savemouse_x;
my := savemouse_y;
if WegFlag then
  if AttraktorFlag then begin
    Bildloeschen;
    Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
    end;
MouseHer;
end;

{***************************************************************************}
{*   MRFS Laden                                                            *}
{***************************************************************************}
procedure Laden;
var Breite,Hoehe,
    winx,winy,
    Zeile,Spalte : word;
    savemouse_x,
    savemouse_y,
    Code         : integer;
    Anz_Zeichen,
    i,j,Anzahl   : Byte;
    Ende,LinFlag : Boolean;
    Name         : String;
    envrec       : MRFS;
    ifsrec       : IFS_F;
    FileListe    : FLTyp;
    f            : File;
    ch           : char;
{***************************************************************************}
{*   liefert einen Filenamen aus einer Auswahlliste                        *}
{***************************************************************************}
  procedure GetFileName(var FName:String;var Nr: Byte; x1,y1,x2,y2:word);
  var Nrold : Byte;
  begin
  if FileListe[1] = 'NOFILES' then begin
    FName := 'NOFILES';
    Exit;
    end;
  if (mx > x1) and (mx < x2) and (my > y1) and (my < y2) then begin
    Nrold := Nr;
    Nr := 3*((my-y1-2) div 15) + (mx-x1) div 130 + 1;
    if (Nr > 0) and (Nr <= Anzahl) then
      FName := FileListe[Nr]
    else begin
      FName := FileListe[Nrold];
      Nr := Nrold;
      end;
    end;
  end;

begin
savemouse_x := mx;
savemouse_y := my;
Breite := 400;
Hoehe := 400;
winx := 150;
winy := 160;
Ende := FALSE;
MouseWeg;
Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Laden:');
OutTextXY(winx+1+Breite div 2,winy+20,'Laden:');
SetFillStyle(SolidFill,F_Text);
Bar(winx+20,winy+Hoehe-50,winx+Breite div 2 - 10,winy+Hoehe-20);
Bar(winx+Breite div 2 + 10,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
Bar(winx+22,winy+Hoehe-48,winx+Breite div 2 - 15,winy+Hoehe-25);
Bar(winx+Breite div 2 + 12,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
OutTextXY(winx+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+1+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+3*(Breite div 4),winy+Hoehe-37,'OK');
OutTextXY(winx+1+3*(Breite div 4),winy+Hoehe-37,'OK');
Rectangle(winx+45,winy+Hoehe-85,winx+65,winy+Hoehe-65);
Rectangle(winx+46,winy+Hoehe-84,winx+66,winy+Hoehe-66);
SetTextJustify(LeftText,CenterText);
OutTextXY(winx+80,winy+Hoehe-77,'Bild (falls vorhanden) mitladen');
OutTextXY(winx+81,winy+Hoehe-77,'Bild (falls vorhanden) mitladen');
SetTextJustify(CenterText,CenterText);
if loadrgb then begin
  OutTextXY(winx+55,winy+Hoehe-77,'X');
  OutTextXY(winx+56,winy+Hoehe-77,'X');
  end;
Entprellen;
Name := '';
GetFileList('*.mfs',winx+10,winy+60,15,3,FileListe,Anzahl);
SetColor(186);
if FileListe[1] <> 'NOFILES' then
  OutTextXY(winx+10,winy+60,FileListe[1]);
SetColor(F_Text);
mx := winx + 10;
my := winy + 60;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
MouseHer;
i := 1;
j := 1;
repeat
  repeat
    Mouse_Bewegen;
    if KeyPressed then begin
      ch := ReadKey;
      if ch = Chr(0) then
        ch := Readkey;
        if ch = Chr(59) then begin
          SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
          HelpMe(31);
          SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
          end;
      if KeyPressed then
      repeat ch := ReadKey; until not KeyPressed
      end;
  until ButtonPressed;
  GetFileName(Name,i,winx+10,winy+45,winx+Breite,winy+Hoehe-90);
  SetColor(F_Text);
  MouseWeg;
  if (i <> j) and (FileListe[1] <> 'NOFILES') then begin
    OutTextXY(winx+10+(Pred(j) mod 3)*130,winy+60+(Pred(j) div 3)*15,FileListe[j]);
    if i > Anzahl then i := j;
    j := i;
    SetColor(186);
    OutTextXY(winx+10+(Pred(i) mod 3)*130,winy+60+(Pred(i) div 3)*15,FileListe[i]);
    end;
  MouseHer;
  EntPrellen;
  if (my > winy+Hoehe-85) and (my < winy+Hoehe-65) and
     (mx > winx+45) and (mx < winx+65) then begin
    loadrgb := not loadrgb;
    if loadrgb then
      SetColor(F_Text)
    else
      SetColor(F_Fenster);
    MouseWeg;
    SetTextJustify(CenterText,CenterText);
    OutTextXY(winx+55,winy+Hoehe-77,'X');
    OutTextXY(winx+56,winy+Hoehe-77,'X');
    SetTextJustify(LeftText,BottomText);
    MouseHer;
    end;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { Abbrechen }
     (mx > winx+20) and (mx < winx+Breite div 2 - 10) then
    Ende := TRUE;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { OK }
     (mx > winx+Breite div 2 + 10) and (mx < winx+Breite - 20) then begin
    Ende := TRUE;
    MRFSName := Name;
    assign(MRFSFile,'IFS\'+MRFSName);
    Name := copy(MRFSName,1,pos('.',MRFSName))+'ifs';
    assign(BIFSFile,'IFS\'+Name);
    Name := copy(MRFSName,1,pos('.',MRFSName))+'fkt';
    assign(FIFSFile,'IFS\'+Name);
    Name := copy(MRFSName,1,pos('.',MRFSName))+'lfk';
    assign(LFFile,'IFS\'+Name);
    Name := copy(MRFSName,1,pos('.',MRFSName))+'nfk';
    assign(NFFile,'IFS\'+name);
    {$I-};
    reset(MRFSFile);
    reset(BIFSFile);
    reset(FIFSFile);
    reset(LFFile);
    reset(NFFile);
    {$I+};
    if IOResult = 0 then begin
      LadeFlag := TRUE;
      Bereich_auslagern(Aktiver_Bereich,Loeschen);       { derzeitiges MRFS }
      for i := 1 to Anzahl_Bereiche do begin             { verwerfen        }
        XmsFreeMem(XmsBereich[i]);
        end;
      Gib_mir_PSpeicher;                           { lscht alle Polygone }
      Skalierung := 1;
      LupAnz := 0;
      read(MRFSFile,envrec);
      with envrec do begin
        Anzahl_Bereiche := Anzahl;
        for i := 1 to 15 do begin
          Visible[i] := Sicht[i];
          Aktive_Fkt[i] := aktiv[i];
          Attraktormode[i] := ASicht[i];
          end;
        Aktiver_Bereich := aktiv[0];
        LinFlag := False;
        if (Skalierung <> scale) or (scroll_x <> scrollx) or
           (scroll_y <> scrolly) then
          LinFlag := True;
        Skalierung := scale;
        scroll_x := scrollx;
        scroll_y := scrolly;
        end;
      if Anzahl_Bereiche > 0 then begin
        for i := 1 to Anzahl_Bereiche do begin
          GetMem(ArbeitsBereich,B_size);
          read(BIFSFile,ArbeitsBereich^);
          insert_B_Poly(i);
          recalc_B_Poly(i,Arbeitsbereich^);
          with ArbeitsBereich^ do
            if Anzahl_Fkt > 0 then
              for j := 1 to Anzahl_Fkt do begin
                read(FIFSFile,ifsrec);
                GetMem(Funktion[j],F_size);
                Funktion[j]^  := ifsrec._Funk;
                GetMem(Funktion[j]^.Restriction,LR_size);
                Funktion[j]^.Restriction^  := ifsrec._Rest;
                if Funktion[j]^.Art then begin
                  with Funktion[j]^ do begin
                    GetMem(LFunk,LF_size);
                    read(LFFile,LFunk^);
                    insert_F_Poly(i,j);
                    recalc_F_Poly(i,j,Form,LFunk^);
                  end;
                  end
                else begin
                  GetMem(Funktion[j]^.NFunk,NF_size);
                  read(NFFile,Funktion[j]^.NFunk^);
                  insert_NF_Poly(i,j);
                  recalc_NF_Poly(i,j,Form,Funktion[j]^.NFunk^);
                  end;
                end;
          XmsBereich[i] := XmsGetMem(xmsBereichsize);
          Bereich_auslagern(i,XmsListe);
          end;
        Bereich_einlagern(Aktiver_Bereich,XmsListe);
        end;
      close(MRFSFile);
      close(BIFSFile);
      close(FIFSFile);
      close(LFFile);
      close(NFFile);
      end;
    end;
until Ende;
Entprellen;
MouseWeg;
SetMouseBereich(0,0,x,y);
Close_Text_Win(2,winx,winy);
if LadeFlag then begin
  Menue_already_closed := True;
  Close_Text_Win(1,anfang,Menue_y);
  BildLoeschen;
  Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],TRUE,TRUE);
  BereichsFeld;
  if Anzahl_Bereiche > 0 then begin
    with ArbeitsBereich^ do
      Bereich_anzeigen(Bereichsnummer,Name);
    Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
    end
  else begin
    Bereich_anzeigen('*','Kein IFS');
    Fkt_Fenster;
    if Fkt_scroll then
      Fkt_Header2(0,Numwin_y1)
    else
      Fkt_Header1(0,Numwin_y1);
    end;
  if LinFlag then begin
    Lineal_links;
    Lineal_unten;
    end;
  LadeFlag := FALSE;
  Calc_LBListe;
  if loadrgb then begin
    Name := copy(MRFSName,1,pos('.',MRFSName))+'rgb';
    assign(f,'RGB\'+Name);
    {$I-};
    reset(f);
    {$I+};
    if IOResult = 0 then begin
      {$I-};
      close(f);
      {$I+};
      Open_Text_Win(1,10,NumWin_y2-65,210,55,8,extended);
      SetColor(F_Linie);
      SetTextStyle(SmallFont,HorizDir,5);
      SetTextJustify(CenterText,CenterText);
      OutTextXY(NumWin_x div 2,NumWin_y2-55,'Bild laden ...');
      Rectangle(20,NumWin_y2-40,210,NumWin_y2-20);
      SetFillStyle(SolidFill,F_Fenster);
      Bar(21,NumWin_y2-39,209,NumWin_y2-21);
      Line(115,NumWin_y2-30,115,NumWin_y2-20);
      for i := 1 to 9 do
        Line(20+i*19,NumWin_y2-25,20+i*19,NumWin_y2-20);
      SetViewPort(GraphWin_x,Menue_y,x,y-Lineal_b,True);
      rgb_load('RGB\'+Name);
      SetViewPort(0,0,x,y,True);
      Close_Text_Win(1,10,NumWin_y2-65);
      AttraktorFlag := False;
      end;
    end;
  end;
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
if not Menue_already_closed then
  MouseHer;
end;

{***************************************************************************}
{*   MRFS Speichern                                                        *}
{***************************************************************************}
procedure Speichern(EditName: Boolean);
var Breite,Hoehe,
    winx,winy,
    Zeile,Spalte : word;
    savemouse_x,
    savemouse_y,
    Code         : integer;
    Anz_Zeichen,
    i,j          : Byte;
    Ende,save    : Boolean;
    Name         : String;
    envrec       : MRFS;
    ifsrec       : IFS_F;
    ch           : char;
begin
Name := MRFSName;
if EditName then begin
  savemouse_x := mx;
  savemouse_y := my;
  Breite := 280;
  Hoehe := 180;
  winx := 180;
  winy := 160;
  Ende := FALSE;
  save := FALSE;
  MouseWeg;
  Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
  SetTextStyle(SmallFont,HorizDir,6);
  SetTextJustify(CenterText,CenterText);
  SetColor(F_Text);
  OutTextXY(winx+Breite div 2,winy+20,'Speichern:');
  OutTextXY(winx+1+Breite div 2,winy+20,'Speichern:');
  SetFillStyle(SolidFill,F_Text);
  Bar(winx+20,winy+Hoehe-50,winx+Breite div 2 - 10,winy+Hoehe-20);
  Bar(winx+Breite div 2 + 10,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
  SetFillStyle(SolidFill,70);
  Bar(winx+22,winy+Hoehe-48,winx+Breite div 2 - 15,winy+Hoehe-25);
  Bar(winx+Breite div 2 + 12,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
  OutTextXY(winx+5+Breite div 4,winy+Hoehe-37,'Abbrechen');
  OutTextXY(winx+6+Breite div 4,winy+Hoehe-37,'Abbrechen');
  OutTextXY(winx-5+3*(Breite div 4),winy+Hoehe-37,'OK');
  OutTextXY(winx-4+3*(Breite div 4),winy+Hoehe-37,'OK');
  Rectangle(winx+45,winy+Hoehe-85,winx+65,winy+Hoehe-65);
  Rectangle(winx+46,winy+Hoehe-84,winx+66,winy+Hoehe-66);
  SetTextJustify(LeftText,CenterText);
  OutTextXY(winx+80,winy+Hoehe-77,'Bild mitspeichern');
  OutTextXY(winx+81,winy+Hoehe-77,'Bild mitspeichern');
  SetTextJustify(CenterText,CenterText);
  if savergb then begin
    OutTextXY(winx+55,winy+Hoehe-77,'X');
    OutTextXY(winx+56,winy+Hoehe-77,'X');
    end;
  Entprellen;
  mx := winx+4*(Breite div 5);
  my := winy+Hoehe-40;
  SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
  SetColor(F_Linie);
  Rectangle(winx+65,winy+55,winx+210,winy+75);
  WriteXY(winx+70,winy+70,Name);
  repeat
    SetFillStyle(SolidFill,F_Fenster);
    Bar(winx+70,winy+56,winx+205,winy+74);
    repeat
      Edit(Name,E_String,12,winx+70,winy+70,F_Text,F_Fenster,Code);
      if Code = 255 then begin
        SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
        HelpMe(32);
        MouseWeg;
        SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
        end;
    until ButtonPressed;
    EntPrellen;
    if (my > winy+Hoehe-85) and (my < winy+Hoehe-65) and
       (mx > winx+45) and (mx < winx+65) then begin
      savergb := not savergb;
      if savergb then
        SetColor(F_Text)
      else
        SetColor(F_Fenster);
      SetTextJustify(CenterText,CenterText);
      OutTextXY(winx+55,winy+Hoehe-77,'X');
      OutTextXY(winx+56,winy+Hoehe-77,'X');
      end;
    if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { Abbrechen }
       (mx > winx+20) and (mx < winx+Breite div 2 - 10) then
      Ende := TRUE;
    if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { OK }
       (mx > winx+Breite div 2 + 10) and (mx < winx+Breite - 20) then begin
      Ende := TRUE;
      save := TRUE;
      end;
  until Ende;
  end;
if save or not EditName then begin
  if (Pos('.',Name) > 0) and (Pos('.',Name) <= 9) then
    MRFSName := copy(Name,1,Pos('.',Name))+'mfs'
  else
    if (Pos(' ',Name) > 0) and (Pos(' ',Name) < 9) then
      MRFSName := copy(Name,1,Pred(Pos(' ',Name)))+'.mfs'
    else
      MRFSName := copy(Name,1,8)+'.mfs';
  assign(MRFSFile,'IFS\'+MRFSName);
  Name := copy(MRFSName,1,pos('.',MRFSName))+'ifs';
  assign(BIFSFile,'IFS\'+Name);
  Name := copy(MRFSName,1,pos('.',MRFSName))+'fkt';
  assign(FIFSFile,'IFS\'+Name);
  Name := copy(MRFSName,1,pos('.',MRFSName))+'lfk';
  assign(LFFile,'IFS\'+Name);
  Name := copy(MRFSName,1,pos('.',MRFSName))+'nfk';
  assign(NFFile,'IFS\'+name);
  {$I-};
  rewrite(MRFSFile);
  rewrite(BIFSFile);
  rewrite(FIFSFile);
  rewrite(LFFile);
  rewrite(NFFile);
  {$I+};
  if Anzahl_Bereiche > 0 then
    Bereich_auslagern(Aktiver_Bereich,XmsListe);
  if IOResult = 0 then begin
    with envrec do begin
      Anzahl := Anzahl_Bereiche;
      for i := 1 to 15 do begin
        Sicht[i] := Visible[i];
        aktiv[i] := Aktive_Fkt[i];
        ASicht[i] := Attraktormode[i];
        end;
      aktiv[0] := Aktiver_Bereich;
      scale := Skalierung;
      scrollx := scroll_x;
      scrolly := scroll_y;
      end;
    write(MRFSFile,envrec);
    if Anzahl_Bereiche > 0 then
      for i := 1 to Anzahl_Bereiche do begin
        Bereich_einlagern(i,XmsListe);
        write(BIFSFile,ArbeitsBereich^);
        with ArbeitsBereich^ do
          if Anzahl_Fkt > 0 then
            for j := 1 to Anzahl_Fkt do begin
              with ifsrec do begin
                _Funk  := Funktion[j]^;
                _Rest  := Funktion[j]^.Restriction^;
                end;
              write(FIFSFile,ifsrec);
              if Funktion[j]^.Art then
                write(LFFile,Funktion[j]^.LFunk^)
              else
                write(NFFile,Funktion[j]^.NFunk^);
              end;
        end;
    end;
  close(MRFSFile);
  close(BIFSFile);
  close(FIFSFile);
  close(LFFile);
  close(NFFile);
  if Anzahl_Bereiche > 0 then
    Bereich_einlagern(Aktiver_Bereich,XmsListe);
  end;
if EditName then begin
  MouseWeg;
  Entprellen;
  SetMouseBereich(0,0,x,y);
  Close_Text_Win(2,winx,winy);
  mx := savemouse_x;
  my := savemouse_y;
  SetMouseBereich(0,0,x,y);
  MouseHer;
  end;
if save and savergb and AttraktorFlag then begin
  MouseWeg;
  Close_Text_Win(1,anfang,Menue_y);
  Menue_already_closed := True;
  Name := copy(MRFSName,1,pos('.',MRFSName))+'rgb';
  Open_Text_Win(1,10,NumWin_y2-65,210,55,8,extended);
  SetColor(F_Linie);
  SetTextStyle(SmallFont,HorizDir,5);
  SetTextJustify(CenterText,CenterText);
  OutTextXY(NumWin_x div 2,NumWin_y2-55,'Bild speichern ...');
  Rectangle(20,NumWin_y2-40,210,NumWin_y2-20);
  SetFillStyle(SolidFill,F_Fenster);
  Bar(21,NumWin_y2-39,209,NumWin_y2-21);
  Line(115,NumWin_y2-30,115,NumWin_y2-20);
  for i := 1 to 9 do
    Line(20+i*19,NumWin_y2-25,20+i*19,NumWin_y2-20);
  rgb_save('RGB\'+Name);
  Close_Text_Win(1,10,NumWin_y2-65);
  end;
end;

{***************************************************************************}
{*   ndert den Namen des IFS (Bereich)                                    *}
{***************************************************************************}
procedure Name_aendern;
var Breite,Hoehe,
    winx,winy    : word;
    savemouse_x,
    savemouse_y,
    Code         : integer;
    Anz_Zeichen  : Byte;
    Zeile,Spalte : word;
    Ende : Boolean;
    Name : String;
begin
if Anzahl_Bereiche = 0 then Exit;
savemouse_x := mx;
savemouse_y := my;
Breite := 300;
Hoehe := 160;
winx := 150;
winy := 160;
Ende := FALSE;
MouseWeg;
Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Name des IFS-Bereiches:');
OutTextXY(winx+1+Breite div 2,winy+20,'Name des IFS-Bereiches:');
SetFillStyle(SolidFill,F_Text);
Bar(winx+20,winy+Hoehe-50,winx+Breite div 2 - 10,winy+Hoehe-20);
Bar(winx+Breite div 2 + 10,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
Bar(winx+22,winy+Hoehe-48,winx+Breite div 2 - 15,winy+Hoehe-25);
Bar(winx+Breite div 2 + 12,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
OutTextXY(winx+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+1+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+3*(Breite div 4),winy+Hoehe-37,'OK');
OutTextXY(winx+1+3*(Breite div 4),winy+Hoehe-37,'OK');
Entprellen;
mx := winx+4*(Breite div 5);
my := winy+Hoehe-40;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
Name := ArbeitsBereich^.Name;
SetColor(F_Linie);
Rectangle(winx+45,winy+55,winx+195,winy+75);
repeat
  repeat
    SetFillStyle(SolidFill,F_Fenster);
    Bar(winx+50,winy+56,winx+190,winy+74);
    Edit(Name,E_String,12,winx+50,winy+70,F_Text,F_Fenster,Code);
    if Code = 255 then begin
      SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
      HelpMe(33);
      MouseWeg;
      SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
      end;
  until ButtonPressed;
  EntPrellen;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { Abbrechen }
     (mx > winx+20) and (mx < winx+Breite div 2 - 10) then
    Ende := TRUE;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { OK }
     (mx > winx+Breite div 2 + 10) and (mx < winx+Breite - 20) then begin
    Ende := TRUE;
    if (Pos('.',Name) > 0) and (Pos('.',Name) <= 9) then
      Arbeitsbereich^.Name := copy(Name,1,Pos('.',Name))+'ifs'
    else
      if (Pos(' ',Name) > 0) and (Pos(' ',Name) < 9) then
        ArbeitsBereich^.Name := copy(Name,1,Pred(Pos(' ',Name)))+'.ifs'
      else
        ArbeitsBereich^.Name := copy(Name,1,8)+'.ifs';
    SetFillStyle(SolidFill,F_Bereich);
    Bar(1,Menue_y+1,x div 4 - 1,NumWin_y1 - 1);
    with ArbeitsBereich^ do
    Bereich_anzeigen(Bereichsnummer,name);
    end;
until Ende;
MouseWeg;
Entprellen;
SetMouseBereich(0,0,x,y);
Close_Text_Win(2,winx,winy);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
end;

{***************************************************************************}
{*   ndert den Bezugsbereich der Funktion                                 *}
{***************************************************************************}
procedure Bezugsbereich_aendern;
var Breite,Hoehe,
    winx,winy   : word;
    savemouse_x,
    savemouse_y : integer;
    Nummer,i    : Byte;
    Ende        : Boolean;
    Bereich,ch  : char;
begin
if Anzahl_Bereiche = 0 then Exit;
if Aktive_Fkt[Aktiver_Bereich] = 0 then Exit;
Bereich := Arbeitsbereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Bereich;
savemouse_x := mx;
savemouse_y := my;
Breite := 400;
Hoehe := 180+50*(Pred(Anzahl_Bereiche) div 5);
winx := 250;
winy := 160;
Ende := FALSE;
MouseWeg;
Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Funktion bezieht sich auf Bereich:');
OutTextXY(winx+1+Breite div 2,winy+20,'Funktion bezieht sich auf Bereich:');
SetFillStyle(SolidFill,F_Text);
Bar(winx+50,winy+Hoehe-50,winx+Breite-50,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
Bar(winx+52,winy+Hoehe-48,winx+Breite-55,winy+Hoehe-25);
OutTextXY(winx+Breite div 2,winy+Hoehe-37,'Beenden');
OutTextXY(winx+1+Breite div 2,winy+Hoehe-37,'Beenden');
for i := 1 to Anzahl_Bereiche do begin
  if Bereich = Get_Bereichsnummer(i) then
    Nummer := i;
  Schalter(winx+37+68*(Pred(i) mod 5),winy+60+50*(Pred(i) div 5),
           Bereich = Get_Bereichsnummer(i),Get_Bereichsnummer(i));
  end;
mx := winx + 3 * Breite div 4;
my := winy + Hoehe - 40;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
MouseHer;
repeat
  repeat
    Mouse_bewegen;
    if KeyPressed then begin
      ch := ReadKey;
      if ch = Chr(0) then
        ch := Readkey;
        if ch = Chr(59) then begin
          SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
          HelpMe(35);
          SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
          end;
      if KeyPressed then
      repeat ch := ReadKey; until not KeyPressed
      end;
  until ButtonPressed;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and
     (mx > winx+50) and (mx < winx+Breite-50) then Ende := TRUE;
  for i := 1 to Anzahl_Bereiche do
    if (mx > winx+37+68*(Pred(i) mod 5)) and
       (mx < winx+87+68*(Pred(i) mod 5)) and
       (my > winy+60+50*(Pred(i) div 5)) and
       (my < winy+90+50*(Pred(i) div 5)) then begin
      Arbeitsbereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Bereich := Get_Bereichsnummer(i);
      if not Funktionsanzeige then
        MRFS_update(Aktive_Fkt[Aktiver_Bereich],Get_Bereichsnummer(i));
      MouseWeg;
      Schalter(winx+37+68*(Pred(Nummer) mod 5),winy+60+50*(Pred(Nummer) div 5),
               FALSE,Get_Bereichsnummer(Nummer));
      Nummer := i;
      Schalter(winx+37+68*(Pred(i) mod 5),winy+60+50*(Pred(i) div 5),
              TRUE,Get_Bereichsnummer(i));
      MouseHer;
      Set_Lastop(3);
      Funk_sichern(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^);
      end;
until Ende;
with ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^ do
  Restriction^.LR[Max_LR_Laenge-1] := Bereich;
AenderungsFlag := TRUE;
EntPrellen;
MouseWeg;
Close_Text_Win(2,winx,winy);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
end;

{***************************************************************************}
{*   ndert die Wahrscheinlichkeit des Aufrufs der Funktion                *}
{***************************************************************************}
procedure Wahrscheinlichkeit_aendern;
var Breite,Hoehe,winx,winy : word;
    savemouse_x,savemouse_y,
    Code                   : integer;
    Anz_Zeichen,i          : Byte;
    Zeile,Spalte           : word;
    Ende                   : Boolean;
    poff                   : string;
    p_old, p_new, p_diff   : double;
    ch                     : char;
  procedure Sperren;
  var Breite,Hoehe,
      winx,winy : word;
      Ende      : Boolean;
      i         : Byte;
  begin
  savemouse_x := mx;
  savemouse_y := my;
  Breite := 400;
  Hoehe := 160;
  winx := x div 4 + 100;
  winy := 250;
  Ende := FALSE;
  MouseWeg;
  Open_Text_Win(3,winx,winy,Breite,Hoehe,F_Fenster,extended);
  SetTextStyle(SmallFont,HorizDir,6);
  SetTextJustify(CenterText,CenterText);
  SetColor(F_Text);
  OutTextXY(winx+Breite div 2,winy+20,'Funktion gegen Udate sperren:');
  OutTextXY(winx+1+Breite div 2,winy+20,'Funktion gegen Udate sperren:');
  SetFillStyle(SolidFill,F_Text);
  Bar(winx+20,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
  SetFillStyle(SolidFill,70);
  Bar(winx+22,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
  OutTextXY(winx+Breite div 2,winy+Hoehe-37,'OK');
  OutTextXY(winx+1+Breite div 2,winy+Hoehe-37,'OK');
  mx := winx+Breite div 2;
  my := winy+Hoehe-35;
  SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
  MouseHer;
  Entprellen;
  for i := 1 to 15 do
    DipSchalter(winx+12+Pred(i)*24,winy+50,i <= ArbeitsBereich^.Anzahl_Fkt,Sperre[i]);
  repeat
    repeat
      Mouse_bewegen;
      if KeyPressed then begin
        ch := ReadKey;
        if ch = Chr(0) then
          ch := Readkey;
          if ch = Chr(59) then begin
            SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
            HelpMe(37);
            SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
            end;
        if KeyPressed then
        repeat ch := ReadKey; until not KeyPressed
        end;
    until ButtonPressed;
    EntPrellen;
    if (my > winy+50) and (my < winy+90) then        { welche Fkt? }
      for i := 0 to Pred(ArbeitsBereich^.Anzahl_Fkt) do begin
        if (mx > (winx+12+i*24)) and (mx < (winx+32+i*24)) then begin
          if my < winy+70 then
            Sperre[Succ(i)] := TRUE
          else
            Sperre[Succ(i)] := FALSE;
          MouseWeg;
          DipSchalter(winx+12+i*24,winy+50,i <= ArbeitsBereich^.Anzahl_Fkt,Sperre[Succ(i)]);
          MouseHer;
          end;
        end;
    if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { OK }
       (mx > winx + 20) and (mx < winx+Breite - 20) then
      Ende := TRUE;
  until Ende;
  Entprellen;
  MouseWeg;
  Close_Text_Win(3,winx,winy);
  mx := savemouse_x;
  my := savemouse_y;
  SetMouseBereich(0,0,x,y);
  end;
begin
if Anzahl_Bereiche = 0 then Exit;
if ArbeitsBereich^.Anzahl_Fkt <= 1 then Exit;
savemouse_x := mx;
savemouse_y := my;
Breite := 300;
Hoehe := 160;
winx := x div 4 + 50;
winy := 160;
Ende := FALSE;
for i := 1 to 15 do
  Sperre[i] := FALSE;
MouseWeg;
Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Wahrscheinlichkeit ndern:');
OutTextXY(winx+1+Breite div 2,winy+20,'Wahrscheinlichkeit ndern:');
SetFillStyle(SolidFill,F_Text);
Bar(winx+20,winy+Hoehe-50,winx+Breite div 2 - 10,winy+Hoehe-20);
Bar(winx+Breite div 2 + 10,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
Bar(winx+Breite - 70,winy+Hoehe-115,winx+Breite-20,winy+Hoehe-65);
SetFillStyle(SolidFill,70);
Bar(winx+22,winy+Hoehe-48,winx+Breite div 2 - 15,winy+Hoehe-25);
Bar(winx+Breite div 2 + 12,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
SetFillStyle(SolidFill,25);
Bar(winx+Breite - 68,winy+Hoehe-113,winx+Breite-25,winy+Hoehe-70);
OutTextXY(winx+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+1+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+3*(Breite div 4),winy+Hoehe-37,'OK');
OutTextXY(winx+1+3*(Breite div 4),winy+Hoehe-37,'OK');
OutTextXY(winx+Breite - 45,winy+Hoehe-90,'S');
OutTextXY(winx+Breite - 44,winy+Hoehe-90,'S');
Entprellen;
mx := winx+4*(Breite div 5);
my := winy+Hoehe-40;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
with ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^ do
  Str(Wahrscheinlichkeit:12:10,poff);
SetColor(F_Linie);
Rectangle(winx+45,winy+55,winx+195,winy+75);
repeat
  SetFillStyle(SolidFill,F_Fenster);
  Bar(winx+50,winy+56,winx+190,winy+74);
  repeat
    Edit(poff,E_Real,12,winx+50,winy+70,F_Text,F_Fenster,Code);
    if Code = 255 then begin
      SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
      HelpMe(34);
      MouseWeg;
      SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
      end;
  until ButtonPressed;
  EntPrellen;
  if (mx > winx+Breite-70) and (mx < winx+Breite-20) and
     (my > winy+Hoehe-115) and (my < winy+Hoehe-65) then begin
    if ArbeitsBereich^.Anzahl_Fkt > 1 then begin
      Sperren;
      SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
      end;
    end;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { Abbrechen }
     (mx > winx+20) and (mx < winx+Breite div 2 - 10) then
    Ende := TRUE;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { OK }
     (mx > winx+Breite div 2 + 10) and (mx < winx+Breite - 20) then begin
    Ende := TRUE;
    with Arbeitsbereich^ do begin
      Set_Lastop(3);
      Funk_sichern(Funktion[Aktive_Fkt[Aktiver_Bereich]]^);
      Sperre[Aktive_Fkt[Aktiver_Bereich]] := TRUE;
      p_old := 1;
      for i := 1 to Anzahl_Fkt do
        if Sperre[i] then
          p_old := p_old - Funktion[i]^.Wahrscheinlichkeit;
      if p_old > 0 then begin
        p_diff := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Wahrscheinlichkeit;
        Val(poff,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Wahrscheinlichkeit,Code);
        p_new := 1;
        for i := 1 to Anzahl_Fkt do
          if Sperre[i] then
            p_new := p_new - Funktion[i]^.Wahrscheinlichkeit;
        if p_new > 0 then begin
          { Wahrscheinlichkeiten anpassen }
          p_diff := p_new / p_old;
          for i := 1 to Anzahl_Fkt do
            if not Sperre[i] then
              with Funktion[i]^ do
              Wahrscheinlichkeit := Wahrscheinlichkeit * p_diff;
          end
        else
          Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Wahrscheinlichkeit := p_diff;
        end;
      if Fkt_scroll then
        update_pF(Funktion[i]^,i = Aktive_Fkt[Aktiver_Bereich]);
      end;
    end;
until Ende;
Entprellen;
MouseWeg;
SetMouseBereich(0,0,x,y);
Close_Text_Win(2,winx,winy);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
end;

{***************************************************************************}
{*   ndert die Farbe der Funktion                                         *}
{***************************************************************************}
procedure Funktionsfarbe;
var Breite,Hoehe,
    winx,winy   : word;
    savemouse_x,
    savemouse_y : integer;
    Nummer,i,j  : Byte;
    Ende        : Boolean;
    ch          : char;
begin
if Anzahl_Bereiche = 0 then Exit;
if Aktive_Fkt[Aktiver_Bereich] = 0 then Exit;
savemouse_x := mx;
savemouse_y := my;
Breite := 440;
Hoehe := 400;
winx := 150;
winy := 160;
Ende := FALSE;
MouseWeg;
Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Farbe der Funktion:');
OutTextXY(winx+1+Breite div 2,winy+20,'Farbe der Funktion:');
SetFillStyle(SolidFill,F_Text);
Bar(winx+50,winy+Hoehe-50,winx+Breite-50,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
Bar(winx+52,winy+Hoehe-48,winx+Breite-55,winy+Hoehe-25);
OutTextXY(winx+Breite div 2,winy+Hoehe-37,'Beenden');
OutTextXY(winx+1+Breite div 2,winy+Hoehe-37,'Beenden');
for i := 0 to 191 do begin
  Nummer := i + 64;
  SetFillStyle(SolidFill,Nummer);
  Bar(winx+20+(i mod 16)*25,winy+40+(i div 16)*25,
      winx+40+(i mod 16)*25,winy+60+(i div 16)*25);
  end;
i := Arbeitsbereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Farbe - 64;
Nummer := i;
SetLineStyle(SolidLn,0,3);
Rectangle(winx+18+(i mod 16)*25,winy+38+(i div 16)*25,
          winx+42+(i mod 16)*25,winy+62+(i div 16)*25);
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
mx := winx+2*(Breite div 3);
my := winy+Hoehe-40;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
MouseHer;
repeat
  repeat
    Mouse_bewegen;
    if KeyPressed then begin
      ch := ReadKey;
      if ch = Chr(0) then
        ch := Readkey;
        if ch = Chr(59) then begin
          SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
          HelpMe(36);
          SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
          end;
      if KeyPressed then
      repeat ch := ReadKey; until not KeyPressed
      end;
  until ButtonPressed;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and
     (mx > winx+50) and (mx < winx+Breite-50) then Ende := TRUE;
  if (mx > winx + 20) and (mx < winx + 415) and
     (my > winy + 40) and (my < winy + 335) then begin
    Nummer := ((my-winy-40) div 25)*16 + ((mx-winx-20) div 25);
    SetColor(F_Fenster);
    MouseWeg;
    Rectangle(winx+18+(i mod 16)*25,winy+38+(i div 16)*25,
              winx+42+(i mod 16)*25,winy+62+(i div 16)*25);
    SetColor(F_Linie);
    i := Nummer;
    Rectangle(winx+18+(i mod 16)*25,winy+38+(i div 16)*25,
              winx+42+(i mod 16)*25,winy+62+(i div 16)*25);
    MouseHer;
    end;
until Ende;
Arbeitsbereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Farbe := Nummer+64;
SetLineStyle(SolidLn,0,Normwidth);
MouseWeg;
SetMouseBereich(0,0,x,y);
Close_Text_Win(2,winx,winy);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
end;

{***************************************************************************}
{*   ndert den Namen des MRFS                                             *}
{***************************************************************************}
procedure MRFS_Name_aendern;
var Breite,Hoehe,
    winx,winy,
    Zeile,Spalte : word;
    savemouse_x,
    savemouse_y,
    Code         : integer;
    Anz_Zeichen  : Byte;
    Ende         : Boolean;
    Name         : String;
begin
if Anzahl_Bereiche = 0 then Exit;
savemouse_x := mx;
savemouse_y := my;
Breite := 300;
Hoehe := 160;
winx := 360;
winy := 160;
Ende := FALSE;
MouseWeg;
Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Name des MRFS:');
OutTextXY(winx+1+Breite div 2,winy+20,'Name des MRFS:');
SetFillStyle(SolidFill,F_Text);
Bar(winx+20,winy+Hoehe-50,winx+Breite div 2 - 10,winy+Hoehe-20);
Bar(winx+Breite div 2 + 10,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
Bar(winx+22,winy+Hoehe-48,winx+Breite div 2 - 15,winy+Hoehe-25);
Bar(winx+Breite div 2 + 12,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
OutTextXY(winx+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+1+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+3*(Breite div 4),winy+Hoehe-37,'OK');
OutTextXY(winx+1+3*(Breite div 4),winy+Hoehe-37,'OK');
Entprellen;
Name := MRFSName;
SetColor(F_Linie);
Rectangle(winx+45,winy+55,winx+195,winy+75);
mx := winx+4*(Breite div 5);
my := winy+Hoehe-40;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
repeat
  SetFillStyle(SolidFill,F_Fenster);
  Bar(winx+50,winy+56,winx+190,winy+74);
  repeat
    Edit(Name,E_String,12,winx+50,winy+70,F_Text,F_Fenster,Code);
    if Code = 255 then begin
      SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
      HelpMe(41);
      MouseWeg;
      SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
      end;
  until ButtonPressed;
  EntPrellen;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { Abbrechen }
     (mx > winx+20) and (mx < winx+Breite div 2 - 10) then
    Ende := TRUE;
  if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { OK }
     (mx > winx+Breite div 2 + 10) and (mx < winx+Breite - 20) then begin
    Ende := TRUE;
    if (Pos('.',Name) > 0) and (Pos('.',Name) <= 9) then
      MRFSName := copy(Name,1,Pos('.',Name))+'mfs'
    else
      if (Pos(' ',Name) > 0) and (Pos(' ',Name) < 9) then
        MRFSName := copy(Name,1,Pred(Pos(' ',Name)))+'.mfs'
      else
        MRFSName := copy(Name,1,8)+'.mfs';
    end;
until Ende;
Entprellen;
MouseWeg;
SetMouseBereich(0,0,x,y);
Close_Text_Win(2,winx,winy);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
end;

{***************************************************************************}
{*   liefert eine textuelle Darstellung des MRFS                           *}
{*   in Funktionsschreibweise (MRFS --> f1(A) + f2(A) + f3(B) + ...        *}
{***************************************************************************}
procedure Show_MRFS(Bereich:Single_IFS);
begin;
EntPrellen;
if Anzahl_Bereiche = 0 then
  Exit;
if Funktionsanzeige then begin
  MRFS_anzeigen(Bereich,Aktive_Fkt[Aktiver_Bereich]);
  end
else begin
  if Fkt_Scroll then
    Fkt_Header2(0,Numwin_y1)
  else
    Fkt_Header1(0,Numwin_y1);
  Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
  end;
Funktionsanzeige := not Funktionsanzeige;
end;

{***************************************************************************}
{*   wandelt eine lineare Funktion in eine Nichtlineare um                 *}
{***************************************************************************}
procedure delinearisieren(var Funk: FunktionsTyp);
var dx, dy : double;
    i      : Byte;
begin
if Anzahl_Bereiche = 0 then
  Exit;
if not Visible[Aktiver_Bereich].Bereich or
   not Visible[Aktiver_Bereich].Funktion then
  Exit;                                         {unsichtbar,geht nicht}
if ArbeitsBereich^.Anzahl_Fkt = 0 then          {keine Fkt da}
  Exit;
if not Funk.Art then                            {Fkt schon nichtlinear}
  Exit;
if MaxAvail < NF_size then
  Exit;
GetMem(Funk.NFunk,NF_size);
Funk.Art := False;                              {nichtlineare Fkt}
with Funk.NFunk^ do begin
  Anzahl_x := 3;
  Anzahl_y := 3;
  with Funk.LFunk^ do begin
    Punkt[0].x := e;
    Punkt[0].y := f;
    Punkt[3].x := a + e;
    Punkt[3].y := c + f;
    Punkt[12].x := b + e;
    Punkt[12].y := d + f;
    Punkt[15].x := a + b + e;
    Punkt[15].y := c + d + f;
    dx := (Punkt[3].x - Punkt[0].x) / Anzahl_x;
    dy := (Punkt[3].y - Punkt[0].y) / Anzahl_y;
    for i := 1 to 2 do begin
      Punkt[i].x := Punkt[0].x + dx * (i mod Succ(Anzahl_x));
      Punkt[i].y := Punkt[0].y + dy * (i mod Succ(Anzahl_x));
      end;
    dx := (Punkt[15].x - Punkt[12].x) / Anzahl_x;
    dy := (Punkt[15].y - Punkt[12].y) / Anzahl_y;
    for i := 13 to 14 do begin
      Punkt[i].x := Punkt[12].x + dx * (i mod Succ(Anzahl_x));
      Punkt[i].y := Punkt[12].y + dy * (i mod Succ(Anzahl_x));
      end;
    dx := (Punkt[12].x - Punkt[0].x) / Anzahl_x;
    dy := (Punkt[12].y - Punkt[0].y) / Anzahl_y;
    Punkt[4].x := Punkt[0].x + dx;
    Punkt[4].y := Punkt[0].y + dy;
    Punkt[8].x := Punkt[0].x + 2 * dx;
    Punkt[8].y := Punkt[0].y + 2 * dy;
    dx := (Punkt[15].x - Punkt[3].x) / Anzahl_x;
    dy := (Punkt[15].y - Punkt[3].y) / Anzahl_y;
    Punkt[7].x := Punkt[3].x + dx;
    Punkt[7].y := Punkt[3].y + dy;
    Punkt[11].x := Punkt[3].x + 2 * dx;
    Punkt[11].y := Punkt[3].y + 2 * dy;
    dx := (Punkt[7].x - Punkt[4].x) / Anzahl_x;
    dy := (Punkt[7].y - Punkt[4].y) / Anzahl_y;
    for i := 5 to 6 do begin
      Punkt[i].x := Punkt[4].x + dx * (i mod Succ(Anzahl_x));
      Punkt[i].y := Punkt[4].y + dy * (i mod Succ(Anzahl_x));
      end;
    dx := (Punkt[11].x - Punkt[8].x) / Anzahl_x;
    dy := (Punkt[11].y - Punkt[8].y) / Anzahl_y;
    for i := 9 to 10 do begin
      Punkt[i].x := Punkt[8].x + dx * (i mod Succ(Anzahl_x));
      Punkt[i].y := Punkt[8].y + dy * (i mod Succ(Anzahl_x));
      end;
    end;
  end;
LFunk_loeschen_sichern(Funk.LFunk^);
FreeMem(Funk.LFunk,F_size);
Set_Lastop(4);
end;

{***************************************************************************}
{*   zeigt die Language Restriction Tabelle fr das aktive IFS an          *}
{***************************************************************************}
procedure Show_LRTable(EditMode : Boolean);
var Breite,Hoehe,
    winx,winy    : word;
    ch           : char;
    savemouse_x,
    savemouse_y,
    Code,i,j     : integer;
    Anz_Zeichen  : Byte;
    Zeile,Spalte : word;
    Ende, raus   : Boolean;
    Wertestring  : String;
    MyLRTable    : Array[1..15] of LRTable;
begin
if Anzahl_Bereiche = 0 then
  Exit;
if ArbeitsBereich^.Anzahl_Fkt = 0 then
  Exit;
savemouse_x := mx;
savemouse_y := my;
Breite := 490;
Hoehe := 110 + 20 * ArbeitsBereich^.Anzahl_Fkt;
winx := 280;
winy := 150;
Ende := FALSE;
for i := 1 to ArbeitsBereich^.Anzahl_Fkt do
  MyLRTable[i] := ArbeitsBereich^.Funktion[i]^.Restriction^;
MouseWeg;
Open_Text_Win(2,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
if EditMode then
  Wertestring := ' ndern'
else
  Wertestring := ' anzeigen';
OutTextXY(winx+Breite div 2,winy+20,'LR-Tabelle'+Wertestring);
OutTextXY(winx+1+Breite div 2,winy+20,'LR-Tabelle'+Wertestring);
SetFillStyle(SolidFill,F_Text);
if EditMode then begin
  Bar(winx+20,winy+Hoehe-50,winx+Breite div 2 - 10,winy+Hoehe-20);
  Bar(winx+Breite div 2 + 10,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
  end
else
  Bar(winx+100,winy+Hoehe-50,winx+Breite-100,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
if EditMode then begin
  Bar(winx+22,winy+Hoehe-48,winx+Breite div 2 - 15,winy+Hoehe-25);
  Bar(winx+Breite div 2 + 12,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
  OutTextXY(winx+Breite div 4,winy+Hoehe-37,'Abbrechen');
  OutTextXY(winx+1+Breite div 4,winy+Hoehe-37,'Abbrechen');
  OutTextXY(winx+3*(Breite div 4),winy+Hoehe-37,'OK');
  OutTextXY(winx+1+3*(Breite div 4),winy+Hoehe-37,'OK');
  end
else begin
  Bar(winx+102,winy+Hoehe-48,winx+Breite-105,winy+Hoehe-25);
  OutTextXY(winx+Breite div 2,winy+Hoehe-37,'Beenden');
  OutTextXY(winx+1+Breite div 2,winy+Hoehe-37,'Beenden');
  end;
Entprellen;
mx := winx+4*(Breite div 5);
my := winy+Hoehe-40;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
MouseHer;
repeat
  with ArbeitsBereich^ do begin
    MouseWeg;
    SetColor(F_Text);
    for i := 1 to Anzahl_Fkt do begin
      SetFillStyle(SolidFill,F_Menue);
      Bar(winx+20,winy+20+i*20,winx+Breite-20,winy+40+i*20);
      if i < 10 then
        WriteXY(Winx+15,Winy+35+i*20,chr(48+i)+' ->')
      else
        WriteXY(Winx+15,Winy+35+i*20,'1'+chr(48+i mod 10)+'->');
      Wertestring := MyLRTable[i].LR;
      WriteXY(winx+60,winy+35+i*20,Wertestring);
      end;
    MouseHer;
    end;
  repeat
    Mouse_bewegen;
    if KeyPressed then begin
      ch := ReadKey;
      if ch = Chr(0) then
        ch := Readkey;
        if ch = Chr(59) then begin
          SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
          HelpMe(44);
          SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
          end;
      if KeyPressed then
      repeat ch := ReadKey; until not KeyPressed
      end;
  until ButtonPressed;
  EntPrellen;
  if EditMode then begin
    if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) then begin
      if (mx > winx+20) and (mx < winx+Breite div 2 - 10) then  { Abbrechen }
        Ende := TRUE;
      if (mx > winx+Breite div 2 + 10) and (mx < winx+Breite - 20) then begin
        with ArbeitsBereich^ do
          for i := 1 to Anzahl_Fkt do
            Funktion[i]^.Restriction^ := MyLRTable[i];
        if AttraktorFlag then
          AenderungsFlag := True;
        Ende := TRUE;                                                  { OK }
        end;
      end
    else begin
      if (mx > winx + 20) and (mx < winx + Breite - 20) then begin   { ndern }
        i := (my - winy - 20) div 20;
        with ArbeitsBereich^ do begin
          if (i > 0) and (i <= Anzahl_Fkt) then begin
            Wertestring := Copy(MyLRTable[i].LR,1,Max_LR_laenge-3);
            MouseWeg;
            Edit(Wertestring,E_String,Max_LR_laenge-3,winx+60,winy+35+i*20,
                 F_Text,F_Menue,Code);
            if Code = 0 then
              for j := 1 to Max_LR_laenge-3 do
                MyLRTable[i].LR[j] := Wertestring[j];
            MouseHer;
            end;
          end;
        end;
      end;
    end
  else                                                      { nur anzeigen }
    if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) then
      if (mx > winx+100) and (mx < winx+Breite-100) then         { Beenden }
        Ende := TRUE;
until Ende;
Entprellen;
MouseWeg;
SetMouseBereich(0,0,x,y);
Close_Text_Win(2,winx,winy);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
end;

{***************************************************************************}
{*   ndert die Defaultwerte fr neue Bereiche und Funktionen              *}
{***************************************************************************}
procedure Change_Defaults;
var Breite1,Hoehe1,win1x,win1y,
    Breite2,Hoehe2,win2x,win2y : word;
    ch           : char;
    savemouse_x,
    savemouse_y,
    Code,i       : integer;
    Anz_Zeichen  : Byte;
    Zeile,Spalte : word;
    Ende, raus   : Boolean;
    Wertestring  : String;
    MyDef        : Defaultwerte;
begin
savemouse_x := mx;
savemouse_y := my;
Breite1 := 200;
Hoehe1 := 200;
win1x := 420;
win1y := 210;
Breite2 := 300;
Hoehe2 := 250;
win2x := 370;
win2y := 250;
Ende := FALSE;
MyDef := Defaults;
MouseWeg;
Open_Text_Win(2,win1x,win1y,Breite1,Hoehe1,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(win1x+Breite1 div 2,win1y+20,'Defaultwerte');
OutTextXY(win1x+1+Breite1 div 2,win1y+20,'Defaultwerte');
SetFillStyle(SolidFill,F_Text);
Bar(win1x+20,win1y+Hoehe1-50,win1x+Breite1-20,win1y+Hoehe1-20);
Bar(win1x+30,win1y+Hoehe1-150,win1x+Breite1-30,win1y+Hoehe1-120);
Bar(win1x+30,win1y+Hoehe1-100,win1x+Breite1-30,win1y+Hoehe1-70);
SetFillStyle(SolidFill,F_Text_rot);
Bar(win1x+22,win1y+Hoehe1-48,win1x+Breite1-25,win1y+Hoehe1-25);
SetFillStyle(SolidFill,F_Funktion);
Bar(win1x+32,win1y+Hoehe1-148,win1x+Breite1-35,win1y+Hoehe1-125);
SetFillStyle(SolidFill,F_Bereich);
Bar(win1x+32,win1y+Hoehe1-98,win1x+Breite1-35,win1y+Hoehe1-75);
OutTextXY(win1x+Breite1 div 2,win1y+Hoehe1-37,'Beenden');
OutTextXY(win1x+1+Breite1 div 2,win1y+Hoehe1-37,'Beenden');
OutTextXY(win1x+Breite1 div 2,win1y+Hoehe1-137,'Funktion');
OutTextXY(win1x+1+Breite1 div 2,win1y+Hoehe1-137,'Funktion');
OutTextXY(win1x+Breite1 div 2,win1y+Hoehe1-87,'Bereich');
OutTextXY(win1x+1+Breite1 div 2,win1y+Hoehe1-87,'Bereich');
Entprellen;
mx := win1x + 2 * Breite1 div 3;
my := win1y + Hoehe1 - 30;
SetMouseBereich(win1x,win1y,win1x+Breite1,win1y+Hoehe1);
MouseHer;
repeat
  repeat
    Mouse_bewegen;
    if KeyPressed then begin
      ch := ReadKey;
      if ch = Chr(0) then
        ch := Readkey;
        if ch = Chr(59) then begin
          SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
          HelpMe(46);
          SetMouseBereich(win1x,win1y,win1x+Breite1,win1y+Hoehe1);
          end;
      if KeyPressed then
      repeat ch := ReadKey; until not KeyPressed
      end;
  until ButtonPressed;
  if (my > win1y+Hoehe1-50) and (my < win1y+Hoehe1-20) and
     (mx > win1x+20) and (mx < win1x+Breite1-20) then
    Ende := True;
  if (my > win1y+Hoehe1-150) and (my < win1y+Hoehe1-120) and      {Fkt ndern}
     (mx > win1x+30) and (mx < win1x+Breite1-30) then begin
    MouseWeg;
    Open_Text_Win(3,win2x,win2y,Breite2,Hoehe2,F_Fenster,extended);
    SetTextStyle(SmallFont,HorizDir,6);
    SetTextJustify(CenterText,CenterText);
    SetColor(F_Text);
    OutTextXY(win2x+Breite2 div 2,win2y+20,'Werte fr Funktion ndern');
    OutTextXY(win2x+1+Breite2 div 2,win2y+20,'Werte fr Funktion ndern');
    SetFillStyle(SolidFill,F_Text);
    Bar(win2x+20,win2y+Hoehe2-50,win2x+Breite2 div 2 - 10,win2y+Hoehe2-20);
    Bar(win2x+Breite2 div 2 + 10,win2y+Hoehe2-50,win2x+Breite2-20,win2y+Hoehe2-20);
    SetFillStyle(SolidFill,70);
    Bar(win2x+22,win2y+Hoehe2-48,win2x+Breite2 div 2 - 15,win2y+Hoehe2-25);
    Bar(win2x+Breite2 div 2 + 12,win2y+Hoehe2-48,win2x+Breite2-25,win2y+Hoehe2-25);
    OutTextXY(win2x+Breite2 div 4,win2y+Hoehe2-37,'Abbrechen');
    OutTextXY(win2x+1+Breite2 div 4,win2y+Hoehe2-37,'Abbrechen');
    OutTextXY(win2x+3*(Breite2 div 4),win2y+Hoehe2-37,'OK');
    OutTextXY(win2x+1+3*(Breite2 div 4),win2y+Hoehe2-37,'OK');
    SetColor(F_Text);
    for i := 1 to 3 do begin
      Rectangle(win2x+50,win2y+i*50,win2x+Breite2 div 2 - 25,win2y+30+i*50);
      Rectangle(win2x+Breite2 div 2 + 35,win2y+i*50,win2x+Breite2-40,win2y+30+i*50);
      end;
    MyDef := Defaults;
    with MyDef._LFunk do begin
      Str(a:5:4,WerteString);
      WriteXY(win2x+25,win2y+70,'a');
      WriteXY(win2x+50,win2y+70,Wertestring);
      Str(b:5:4,WerteString);
      WriteXY(win2x+25,win2y+120,'b');
      WriteXY(win2x+50,win2y+120,Wertestring);
      Str(c:5:4,WerteString);
      Str(e:5:4,WerteString);
      WriteXY(win2x+25,win2y+170,'e');
      WriteXY(win2x+50,win2y+170,Wertestring);
      WriteXY(win2x+Breite2 div 2 + 10,win2y+70,'c');
      WriteXY(win2x+Breite2 div 2 + 35,win2y+70,Wertestring);
      Str(d:5:4,WerteString);
      WriteXY(win2x+Breite2 div 2 + 10,win2y+120,'d');
      WriteXY(win2x+Breite2 div 2 + 35,win2y+120,Wertestring);
      Str(f:5:4,WerteString);
      WriteXY(win2x+Breite2 div 2 + 10,win2y+170,'f');
      WriteXY(win2x+Breite2 div 2 + 35,win2y+170,Wertestring);
      end;
    Entprellen;
    SetMouseBereich(win2x,win2y,win2x+Breite2,win2y+Hoehe2);
    raus := FALSE;
    repeat
      MouseHer;
      repeat
        Mouse_bewegen;
        if KeyPressed then begin
          ch := ReadKey;
          if ch = Chr(0) then
            ch := Readkey;
            if ch = Chr(59) then begin
              SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
              HelpMe(47);
              SetMouseBereich(win2x,win2y,win2x+Breite2,win2y+Hoehe2);
              end;
          if KeyPressed then
          repeat ch := ReadKey; until not KeyPressed
          end;
      until ButtonPressed;
      if KeyPressed then
        repeat ch := ReadKey; until not KeyPressed;
      EntPrellen;
      MouseWeg;
      with MyDef._LFunk do begin
        if (mx > win2x+50) and (mx < win2x+Breite2 div 2 - 25) then begin
          if (my > win2y+50) and (my < win2y+80) then begin
            Str(a:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+50,win2y+70,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,a,Code);
            end;
          if (my > win2y+100) and (my < win2y+130) then begin
            Str(b:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+50,win2y+120,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,b,Code);
            end;
          if (my > win2y+150) and (my < win2y+180) then begin
            Str(e:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+50,win2y+170,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,e,Code);
            end;
          end;
        if (mx > win2x+Breite2 div 2 + 35) and (mx < win2x+Breite2-40) then begin
          if (my > win2y+50) and (my < win2y + 80) then begin
            Str(c:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+Breite2 div 2+35,win2y+70,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,c,Code);
            end;
          if (my > win2y+100) and (my < win2y+130) then begin
            Str(d:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+Breite2 div 2+35,win2y+120,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,d,Code);
            end;
          if (my > win2y+150) and (my < win2y+180) then begin
            Str(f:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+Breite2 div 2+35,win2y+170,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,f,Code);
            end;
          end;
        end;
      if (my > win2y+Hoehe2-50) and (my < win2y+Hoehe2-20) and     {Abbrechen}
         (mx > win2x+20) and (mx < win2x+Breite2 div 2 - 10) then
        raus := TRUE;
      if (my > win2y+Hoehe2-50) and (my < win2y+Hoehe2-20) and          { OK }
         (mx > win2x+Breite2 div 2+10) and (mx < win2x+Breite2-20) then begin
        Defaults := MyDef;
        {$I-};
        assign(DefFile,'Defaults.def');
        rewrite(DefFile);
        {$I+};
        if IOResult = 0 then
          Write(DefFile,Defaults);
        {$I-};
        close(DefFile);
        {$I+};
        raus := TRUE;
        end;
    until raus;
    MouseWeg;
    Close_Text_Win(3,win2x,win2y);
    mx := win1x + 2 * Breite1 div 3;
    my := win1y + Hoehe1 - 40;
    SetMouseBereich(win1x,win1y,win1x+Breite1,win1y+Hoehe1);
    MouseHer;
    end;
  if (my > win1y+Hoehe1-100) and (my < win1y+Hoehe1-70) and   {Bereich ndern}
     (mx > win1x+30) and (mx < win1x+Breite1-30) then begin
    MouseWeg;
    Open_Text_Win(3,win2x,win2y,Breite2,Hoehe2,F_Fenster,extended);
    SetTextStyle(SmallFont,HorizDir,6);
    SetTextJustify(CenterText,CenterText);
    SetColor(F_Text);
    OutTextXY(win2x+Breite2 div 2,win2y+20,'Werte fr Bereich ndern');
    OutTextXY(win2x+1+Breite2 div 2,win2y+20,'Werte fr Bereich ndern');
    SetFillStyle(SolidFill,F_Text);
    Bar(win2x+20,win2y+Hoehe2-50,win2x+Breite2 div 2 - 10,win2y+Hoehe2-20);
    Bar(win2x+Breite2 div 2 + 10,win2y+Hoehe2-50,win2x+Breite2-20,win2y+Hoehe2-20);
    SetFillStyle(SolidFill,70);
    Bar(win2x+22,win2y+Hoehe2-48,win2x+Breite2 div 2 - 15,win2y+Hoehe2-25);
    Bar(win2x+Breite2 div 2 + 12,win2y+Hoehe2-48,win2x+Breite2-25,win2y+Hoehe2-25);
    OutTextXY(win2x+Breite2 div 4,win2y+Hoehe2-37,'Abbrechen');
    OutTextXY(win2x+1+Breite2 div 4,win2y+Hoehe2-37,'Abbrechen');
    OutTextXY(win2x+3*(Breite2 div 4),win2y+Hoehe2-37,'OK');
    OutTextXY(win2x+1+3*(Breite2 div 4),win2y+Hoehe2-37,'OK');
    SetColor(F_Text);
    for i := 1 to 3 do begin
      Rectangle(win2x+50,win2y+i*50,win2x+Breite2 div 2 - 25,win2y+30+i*50);
      Rectangle(win2x+Breite2 div 2 + 35,win2y+i*50,win2x+Breite2-40,win2y+30+i*50);
      end;
    MyDef := Defaults;
    with MyDef._Form do begin
      Str(a:5:4,WerteString);
      WriteXY(win2x+25,win2y+70,'a');
      WriteXY(win2x+50,win2y+70,Wertestring);
      Str(b:5:4,WerteString);
      WriteXY(win2x+25,win2y+120,'b');
      WriteXY(win2x+50,win2y+120,Wertestring);
      Str(c:5:4,WerteString);
      Str(e:5:4,WerteString);
      WriteXY(win2x+25,win2y+170,'e');
      WriteXY(win2x+50,win2y+170,Wertestring);
      WriteXY(win2x+Breite2 div 2 + 10,win2y+70,'c');
      WriteXY(win2x+Breite2 div 2 + 35,win2y+70,Wertestring);
      Str(d:5:4,WerteString);
      WriteXY(win2x+Breite2 div 2 + 10,win2y+120,'d');
      WriteXY(win2x+Breite2 div 2 + 35,win2y+120,Wertestring);
      Str(f:5:4,WerteString);
      WriteXY(win2x+Breite2 div 2 + 10,win2y+170,'f');
      WriteXY(win2x+Breite2 div 2 + 35,win2y+170,Wertestring);
      end;
    Entprellen;
    SetMouseBereich(win2x,win2y,win2x+Breite2,win2y+Hoehe2);
    raus := FALSE;
    repeat
      MouseHer;
      repeat
        Mouse_bewegen;
        if KeyPressed then begin
          ch := ReadKey;
          if ch = Chr(0) then
            ch := Readkey;
            if ch = Chr(59) then begin
              SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
              HelpMe(47);
              SetMouseBereich(win2x,win2y,win2x+Breite2,win2y+Hoehe2);
              end;
          if KeyPressed then
          repeat ch := ReadKey; until not KeyPressed
          end;
      until ButtonPressed;
      if KeyPressed then
        repeat ch := ReadKey; until not KeyPressed;
      EntPrellen;
      MouseWeg;
      with MyDef._Form do begin
        if (mx > win2x+50) and (mx < win2x+Breite2 div 2 - 25) then begin
          if (my > win2y+50) and (my < win2y+80) then begin
            Str(a:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+50,win2y+70,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,a,Code);
            end;
          if (my > win2y+100) and (my < win2y+130) then begin
            Str(b:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+50,win2y+120,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,b,Code);
            end;
          if (my > win2y+150) and (my < win2y+180) then begin
            Str(e:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+50,win2y+170,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,e,Code);
            end;
          end;
        if (mx > win2x+Breite2 div 2 + 35) and (mx < win2x+Breite2-40) then begin
          if (my > win2y+50) and (my < win2y + 80) then begin
            Str(c:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+Breite2 div 2+35,win2y+70,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,c,Code);
            end;
          if (my > win2y+100) and (my < win2y+130) then begin
            Str(d:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+Breite2 div 2+35,win2y+120,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,d,Code);
            end;
          if (my > win2y+150) and (my < win2y+180) then begin
            Str(f:5:4,Wertestring);
            Edit(Wertestring,E_Real,6,win2x+Breite2 div 2+35,win2y+170,F_Text,F_Fenster,Code);
            if Code = 0 then
              Val(Wertestring,f,Code);
            end;
          end;
        end;
      if (my > win2y+Hoehe2-50) and (my < win2y+Hoehe2-20) and     {Abbrechen}
         (mx > win2x+20) and (mx < win2x+Breite2 div 2 - 10) then
        raus := TRUE;
      if (my > win2y+Hoehe2-50) and (my < win2y+Hoehe2-20) and          { OK }
         (mx > win2x+Breite2 div 2+10) and (mx < win2x+Breite2-20) then begin
        Defaults := MyDef;
        {$I-};
        assign(DefFile,'Defaults.def');
        rewrite(DefFile);
        {$I+};
        if IOResult = 0 then
          Write(DefFile,Defaults);
        {$I-};
        close(DefFile);
        {$I+};
        raus := TRUE;
        end;
    until raus;
    MouseWeg;
    Close_Text_Win(3,win2x,win2y);
    mx := win1x + 2 * Breite1 div 3;
    my := win1y + Hoehe1 - 40;
    SetMouseBereich(win1x,win1y,win1x+Breite1,win1y+Hoehe1);
    MouseHer;
    end;
until Ende;
Entprellen;
MouseWeg;
SetMouseBereich(0,0,x,y);
Close_Text_Win(2,win1x,win1y);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
end;

{***************************************************************************}
{*   liefert ausgewhlte Funktion im Men                                  *}
{***************************************************************************}
function Get_Wahl(menue,mzeilen:Byte):Byte;
var zeile : Byte;
begin
case menue of
  1 : begin
      if (mx < 1) or (mx > 1 + Breite) or
         (my > Menue_y + mzeilen*Thoch) then begin
        Get_Wahl := Out_of_menue;
        Exit;
        end;
      zeile := (my - Menue_y+Thoch div 2) div Thoch + 1;
      if Odd(zeile) then
        zeile := in_spacebar
      else
        zeile := zeile div 2;
      Get_Wahl := zeile + 10;
      end;
  2 : begin
      if (mx < x div 4) or (mx > x div 4 + Breite) or
         (my > Menue_y + mzeilen*Thoch) then begin
        Get_Wahl := Out_of_menue;
        Exit;
        end;
      zeile := (my - Menue_y+Thoch div 2) div Thoch + 1;
      if Odd(zeile) then
        zeile := in_spacebar
      else
        zeile := zeile div 2;
      Get_Wahl := zeile + 20;
      end;
  3 : begin
      if (mx < x div 2) or (mx > x div 2 + Breite) or
         (my > Menue_y + mzeilen*Thoch) then begin
        Get_Wahl := Out_of_menue;
        Exit;
        end;
      zeile := (my - Menue_y+Thoch div 2) div Thoch + 1;
      if Odd(zeile) then
        zeile := in_spacebar
      else
        zeile := zeile div 2;
      Get_Wahl := zeile + 30;
      end;
  end;
end;

{***************************************************************************}
{*   ruft die mit Get_Wahl ermittelte Funktion auf                         *}
{***************************************************************************}
procedure Do_Action(which:Byte);
var i : Byte;
    Breite : word;
    savemouse_x,
    savemouse_y,
    ypos,lastpos,
    temp1,temp2 : integer;
    abst : real;
    wert : string;
begin
SetTextStyle(Smallfont,HorizDir,6);
SetTextJustify(LeftText,CenterText);
case which of
  11 : Maszstab_aendern;
  12 : Lupe;
  13 : begin                                           {Lineale ja oder nein}
       LinealFlag := True;
       if Visible_Lineal then begin
         SetFillStyle(Solidfill,20);
         Bar(GraphWin_x+1,y-Lineal_b+1,x-Lineal_b-1,y-1);           {Lineale}
         Bar(Bereich_x+1,Menue_y+17*Thoch+1,GraphWin_x-1,y-Lineal_b-1);
         Bar(24*Textwidth('X'),Menue_y+17*Thoch+1,
             GraphWin_x-1,Menue_y+Lineal_b+1);
         Visible_Lineal := FALSE;
         SetColor(F_Menue);
         OutTextXY(abstand div 2,Menue_y+5*Thoch,chr(251));
         end
       else begin
         Lineal_unten;
         abst := 5.5*Skalierung;
         SetColor(F_Text_rot);
         lastpos := round(50{/Skalierung});
         for i := 1 to lastpos do begin
           ypos := y-Lineal_b-round(i*2*abst);
           temp1 := scroll_y div 11;
           temp2 := (temp1 + 5) mod 5;
           if i < round(28/Skalierung) then begin
             if (i+temp2) mod 5 = 0 then begin
               Line(Bereich_x+Lineal_b div 2,ypos,
                    Bereich_x+Lineal_b-Lineal_b div 10,ypos);
               Str(round((i+temp1)*2/Skalierung),wert);
               SetTextStyle(Smallfont,HorizDir,4);
               SetTextJustify(LeftText,BottomText);
               OutTextXY(Bereich_x + 2,ypos,wert);
               OutTextXY(Bereich_x + 3,ypos,wert);
               end
             else
               Line(Bereich_x+Lineal_b div 2,ypos,
                    Bereich_x+Lineal_b div 4 * 3,ypos);
             end
           else
             if ypos > Menue_y+Lineal_b+1 then
               Line(Bereich_x+Lineal_b div 2 + 1,ypos,
                    Bereich_x+Lineal_b div 4 * 3,ypos);
           end;
         Visible_Lineal := TRUE;
         SetColor(F_Text);
         SetTextStyle(Smallfont,HorizDir,6);
         SetTextJustify(LeftText,CenterText);
         OutTextXY(abstand div 2,Menue_y+5*Thoch,chr(251));
         end;
       end;
  14 : BereichSicht_aendern;
  15 : begin                                        {Sichtbarkeit Funktionen}
       if Aktiver_Bereich = 0 then
         Exit;
       if Visible[Aktiver_Bereich].Funktion then begin
         Funktion_ausblenden(Aktiver_Bereich);
         SetColor(5);
         end;
       Visible[Aktiver_Bereich].Funktion := not Visible[Aktiver_Bereich].Funktion;
       Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],TRUE,TRUE);
       SetColor(5);
       if Visible[Aktiver_Bereich].Funktion then begin
         SetColor(F_Text);
         end;
       OutTextXY(abstand div 2,Menue_y+9*Thoch,chr(251));
       if Visible[Aktiver_Bereich].Fixpunkt then
         OutTextXY(abstand div 2,Menue_y+11*Thoch,chr(251));
       end;
  16 : begin                                         {Sichtbarkeit Fixpunkte}
       if Aktiver_Bereich = 0 then
         Exit;
       if not Visible[Aktiver_Bereich].Funktion then
         Exit;
       if Visible[Aktiver_Bereich].Fixpunkt then begin
         Fixpunkt_ausblenden(Aktiver_Bereich);
         SetColor(5);
         end;
       Visible[Aktiver_Bereich].Fixpunkt := not Visible[Aktiver_Bereich].Fixpunkt;
       Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],TRUE,TRUE);
       SetColor(5);
       if Visible[Aktiver_Bereich].Fixpunkt then begin
         SetColor(F_Text);
         end;
       OutTextXY(abstand div 2,Menue_y+11*Thoch,chr(251));
       end;
  17 : BildMenue;
  18 : begin                                                { Bild rechnen }
       BildrechenFlag := not BildrechenFlag;
       if BildrechenFlag then
         SetColor(F_Text)
       else
         SetColor(F_Menue);
       OutTextXY(abstand div 2,Menue_y+15*Thoch,chr(251));
       end;
  21 : Laden;                                                      { Laden }
  22 : Speichern(True);                                        { Speichern }
  23 : Name_aendern;                                         { Name ndern }
  24 : Wahrscheinlichkeit_aendern;                    { Wahrscheinlichkeit }
  25 : Bezugsbereich_aendern;
  26 : Funktionsfarbe;
  31 : MRFS_Name_aendern;
  32 : Show_MRFS(Arbeitsbereich^);
  33 : begin
       MouseWeg;
       Close_Text_Win(1,anfang,Menue_y);
       Menue_already_closed := True;
       Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],False,True,True);
       with Arbeitsbereich^ do begin
         delinearisieren(Funktion[Aktive_Fkt[Aktiver_Bereich]]^);
         remove_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich]);
         insert_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich]);
         recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                        Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
         if Funktionsanzeige then
           Funktion_anzeigen(Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                             aktiv,NumWin_y1)
         else
           MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
         end;
       Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],True,True,True);
       end;
  34 : Show_LRTable(False);
  35 : Show_LRTable(True);
  36 : Change_Defaults;                                     { Defaultwerte }
  end;
end;

{***************************************************************************}
{*                     Menleiste                                          *}
{***************************************************************************}
procedure Menueleiste;
begin
SetColor(F_Text_rot);
SetTextStyle(Smallfont,HorizDir,Menueschrift);
SetTextJustify(CenterText,BottomText);
OutTextXY(x div 8,Menuetext_y,MenueName1);
OutTextXY(3 * x div 8,Menuetext_y,MenueName2);
OutTextXY(5 * x div 8,Menuetext_y,MenueName3);
OutTextXY(7 * x div 8,Menuetext_y,'Ende');
OutTextXY(x div 8 + 1,Menuetext_y,MenueName1);
OutTextXY(3 * x div 8 + 1,Menuetext_y,MenueName2);
OutTextXY(5 * x div 8 + 1,Menuetext_y,MenueName3);
OutTextXY(7 * x div 8 + 1,Menuetext_y,'Ende');
end;

{***************************************************************************}
{*                     Men 1   -   Ansicht                                *}
{***************************************************************************}
procedure Menue1;
const Zeilen = 17;
var Handle,Hoehe : integer;
    i            : Byte;
    ch           : char;
begin
Menue_already_closed := False;
SetTextStyle(Smallfont,HorizDir,6);
SetTextJustify(LeftText,CenterText);
Thoch := TextHeight('T');
Breite := 24 * TextWidth('x');                       {1,5 * max Schriftbreite}
abstand := Breite div 6;
Open_Text_Win(1,0,Menue_y,Breite,Zeilen*Thoch,F_Menue,pulldown);
SetColor(F_Text);
OutTextXY(abstand,Menue_y+Thoch,'Mastab');
OutTextXY(abstand,Menue_y+3*Thoch,'Lupe');
OutTextXY(abstand,Menue_y+5*Thoch,'Lineale anzeigen');
OutTextXY(abstand,Menue_y+7*Thoch,'Bereiche sichtbar');
OutTextXY(abstand,Menue_y+9*Thoch,'Funktionen sichtbar');
OutTextXY(abstand,Menue_y+11*Thoch,'Fixpunkte sichtbar');
OutTextXY(abstand,Menue_y+13*Thoch,'Bildeinstellungen');
OutTextXY(abstand,Menue_y+15*Thoch,'Bild rechnen');
OutTextXY(Succ(abstand),Menue_y+Thoch,'Mastab');
OutTextXY(Succ(abstand),Menue_y+3*Thoch,'Lupe');
OutTextXY(Succ(abstand),Menue_y+5*Thoch,'Lineale anzeigen');
if Anzahl_Bereiche > 0 then begin
  OutTextXY(Succ(abstand),Menue_y+7*Thoch,'Bereiche sichtbar');
  if Aktive_Fkt[Aktiver_Bereich] > 0 then begin
    OutTextXY(Succ(abstand),Menue_y+9*Thoch,'Funktionen sichtbar');
    OutTextXY(Succ(abstand),Menue_y+11*Thoch,'Fixpunkte sichtbar');
    end;
  OutTextXY(Succ(abstand),Menue_y+13*Thoch,'Bildeinstellungen');
  end;
OutTextXY(Succ(abstand),Menue_y+15*Thoch,'Bild rechnen');
if Visible_Lineal then
  OutTextXY(abstand div 2,Menue_y+5*Thoch,chr(251));
if Aktiver_Bereich > 0 then begin
  if Visible[Aktiver_Bereich].Funktion then begin
    OutTextXY(abstand div 2,Menue_y+9*Thoch,chr(251));
    if Visible[Aktiver_Bereich].Fixpunkt then
      OutTextXY(abstand div 2,Menue_y+11*Thoch,chr(251));
    end;
  end;
if BildrechenFlag then
  OutTextXY(abstand div 2,Menue_y+15*Thoch,chr(251));
MouseHer;
repeat
repeat Mouse_bewegen until KeyPressed or ButtonPressed;
if KeyPressed then begin
  ch := ReadKey;
  if ch = Chr(0) then
    ch := Readkey;
    if ch = Chr(59) then 
      HelpMe(20);
  if KeyPressed then
  repeat ch := ReadKey; until not KeyPressed
  end
else begin
  i := Get_Wahl(1,Zeilen);
  Do_Action(i);
  EntPrellen;
  end;
until (i = Out_of_menue) or Menue_already_closed;
MouseWeg;
if not Menue_already_closed then
  Close_Text_Win(1,0,Menue_y)
else
  Menue_already_closed := False;
if LinealFlag then begin
  LinealFlag := FALSE;
  if Visible_Lineal then begin
    Lineal_links;
    Lineal_unten;
    end
  else begin
    SetFillStyle(SolidFill,20);
    Bar(NumWin_x+1,Menue_y+Lineal_b+1,NumWin_x+Lineal_b-1,y-Lineal_b-1);
    end;
  end;
end;

{***************************************************************************}
{*                     Men 2   -   Einstellungen/Funktionen               *}
{***************************************************************************}
procedure Menue2;
const Zeilen = 13;
      linear : Boolean = TRUE;
var Handle, Hoehe : integer;
     i            : Byte;
     ch           : char;
begin
Menue_already_closed := FALSE;
SetTextStyle(Smallfont,HorizDir,6);
SetTextJustify(LeftText,CenterText);
anfang := x div 4;
Thoch := TextHeight('T');
Breite := 24 * TextWidth('x');                       {1,5 * max Schriftbreite}
abstand := Breite div 6;
LadeFlag := FALSE;
AenderungsFlag := FALSE;
Open_Text_Win(1,anfang,Menue_y,Breite,Zeilen*Thoch,F_Menue,pulldown);
SetColor(F_Text);
OutTextXY(anfang+abstand,Menue_y+Thoch,'IFS/MRFS Laden');
OutTextXY(anfang+abstand,Menue_y+3*Thoch,'IFS/MRFS Speichern');
OutTextXY(anfang+abstand,Menue_y+5*Thoch,'Name ndern');
OutTextXY(anfang+abstand,Menue_y+7*Thoch,'Wahrscheinlichkeit');
OutTextXY(anfang+abstand,Menue_y+9*Thoch,'Bezugsbereich');
OutTextXY(anfang+abstand,Menue_y+11*Thoch,'Farbe');
OutTextXY(anfang+Succ(abstand),Menue_y+Thoch,'IFS/MRFS Laden');
OutTextXY(anfang+Succ(abstand),Menue_y+3*Thoch,'IFS/MRFS Speichern');
if Anzahl_Bereiche > 0 then begin
  OutTextXY(anfang+Succ(abstand),Menue_y+5*Thoch,'Name ndern');
  if ArbeitsBereich^.Anzahl_Fkt > 1 then
    OutTextXY(anfang+Succ(abstand),Menue_y+7*Thoch,'Wahrscheinlichkeit');
  if Aktive_Fkt[Aktiver_Bereich] > 0 then begin
    OutTextXY(anfang+Succ(abstand),Menue_y+9*Thoch,'Bezugsbereich');
    OutTextXY(anfang+Succ(abstand),Menue_y+11*Thoch,'Farbe');
    end;
  end;
MouseHer;
repeat
repeat Mouse_bewegen until KeyPressed or ButtonPressed;
if KeyPressed then begin
  ch := ReadKey;
  if ch = Chr(0) then
    ch := Readkey;
    if ch = Chr(59) then 
      HelpMe(30);
  if KeyPressed then
  repeat ch := ReadKey; until not KeyPressed
  end
else begin
  i := Get_Wahl(2,Zeilen);
  Do_Action(i);
  EntPrellen;
  end;
until (i = Out_of_menue) or Menue_already_closed;
if not Menue_already_closed then begin
  MouseWeg;
  Close_Text_Win(1,anfang,Menue_y);
  end
else
  Menue_already_closed := False;
if AenderungsFlag then begin
  Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                    aktiv,NumWin_y1);
  if AttraktorFlag then begin
    BildLoeschen;
    Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
    end;
  end;
end;

{***************************************************************************}
{*                     Men 3   -   Specials                               *}
{***************************************************************************}
procedure Menue3;
const Zeilen = 13;
var Handle, Hoehe : integer;
    i             : Byte;
    ch            : char;
begin
Menue_already_closed := FALSE;
SetTextStyle(Smallfont,HorizDir,6);
SetTextJustify(LeftText,CenterText);
anfang := x div 2;
Thoch := TextHeight('T');
Breite := 24 * TextWidth('x');                       {1,5 * max Schriftbreite}
abstand := Breite div 6;
Open_Text_Win(1,anfang,Menue_y,Breite,Zeilen*Thoch,F_Menue,pulldown);
SetColor(F_Text);
OutTextXY(anfang+abstand,Menue_y+Thoch,'MRFS - Name ndern');
OutTextXY(anfang+abstand,Menue_y+3*Thoch,'MRFS / IFS anzeigen');
OutTextXY(anfang+abstand,Menue_y+5*Thoch,'Fkt delinearisieren');
OutTextXY(anfang+abstand,Menue_y+7*Thoch,'LR-Tabelle anzeigen');
OutTextXY(anfang+abstand,Menue_y+9*Thoch,'LR-Tabelle ndern');
OutTextXY(anfang+abstand,Menue_y+11*Thoch,'Defaultwerte');
if Anzahl_Bereiche > 0 then begin
  OutTextXY(anfang+Succ(abstand),Menue_y+Thoch,'MRFS - Name ndern');
  OutTextXY(anfang+Succ(abstand),Menue_y+3*Thoch,'MRFS / IFS anzeigen');
  if Aktive_Fkt[Aktiver_Bereich] > 0 then begin
    OutTextXY(anfang+Succ(abstand),Menue_y+5*Thoch,'Fkt delinearisieren');
    OutTextXY(anfang+Succ(abstand),Menue_y+7*Thoch,'LR-Tabelle anzeigen');
    OutTextXY(anfang+Succ(abstand),Menue_y+9*Thoch,'LR-Tabelle ndern');
    end;
  end;
OutTextXY(anfang+Succ(abstand),Menue_y+11*Thoch,'Defaultwerte');
MouseHer;
repeat
repeat Mouse_bewegen until KeyPressed or ButtonPressed;
if KeyPressed then begin
  ch := ReadKey;
  if ch = Chr(0) then
    ch := Readkey;
    if ch = Chr(59) then 
      HelpMe(40);
  if KeyPressed then
  repeat ch := ReadKey; until not KeyPressed
  end
else begin
  i := Get_Wahl(3,Zeilen);
  Do_Action(i);
  EntPrellen;
  end;
until (i = Out_of_menue) or Menue_already_closed;
if not menue_already_closed then begin
  MouseWeg;
  Close_Text_Win(1,anfang,Menue_y);
  end
else
  Menue_already_closed := False;
if AenderungsFlag then begin
  AenderungsFlag := False;
  Bildloeschen;
  Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
  end;
end;

procedure AusstiegsMenue(var raus: Boolean);
var Breite,Hoehe,winx,winy : word;
    savemouse_x,
    savemouse_y,
    Zeile,Spalte : word;
    Ende         : Boolean;
    ch           : char;
begin
savemouse_x := mx;
savemouse_y := my;
Breite := 300;
Hoehe := 140;
winx := 400;
winy := 200;
Ende := FALSE;
MouseWeg;
Open_Text_Win(1,winx,winy,Breite,Hoehe,F_Fenster,extended);
SetTextStyle(SmallFont,HorizDir,6);
SetTextJustify(CenterText,CenterText);
SetColor(F_Text);
OutTextXY(winx+Breite div 2,winy+20,'Editor verlassen ?');
OutTextXY(winx+1+Breite div 2,winy+20,'Editor verlassen ?');
SetFillStyle(SolidFill,F_Text);
Bar(winx+20,winy+Hoehe-50,winx+Breite div 2 - 10,winy+Hoehe-20);
Bar(winx+Breite div 2 + 10,winy+Hoehe-50,winx+Breite-20,winy+Hoehe-20);
SetFillStyle(SolidFill,70);
Bar(winx+22,winy+Hoehe-48,winx+Breite div 2 - 15,winy+Hoehe-25);
Bar(winx+Breite div 2 + 12,winy+Hoehe-48,winx+Breite-25,winy+Hoehe-25);
OutTextXY(winx+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+1+Breite div 4,winy+Hoehe-37,'Abbrechen');
OutTextXY(winx+3*(Breite div 4),winy+Hoehe-37,'Beenden');
OutTextXY(winx+1+3*(Breite div 4),winy+Hoehe-37,'Beenden');
Rectangle(winx+70,winy+Hoehe-85,winx+90,winy+Hoehe-65);
Rectangle(winx+71,winy+Hoehe-84,winx+89,winy+Hoehe-66);
OutTextXY(winx+Breite div 2,winy+Hoehe-77,'IFS sichern');
OutTextXY(winx+1+Breite div 2,winy+Hoehe-77,'IFS sichern');
if saveit then begin
  OutTextXY(winx+80,winy+Hoehe-77,'X');
  OutTextXY(winx+81,winy+Hoehe-77,'X');
  end;
Entprellen;
mx := winx+2*(Breite div 5);
my := winy+Hoehe-40;
SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
MouseHer;
repeat
  repeat
    Mouse_bewegen;
  until ButtonPressed or KeyPressed;
  EntPrellen;
  if KeyPressed then begin
    ch := ReadKey;
    if ch = Chr(0) then
      ch := Readkey;
      if ch = Chr(59) then begin
        SetMouseBereich(GraphWin_x,Menue_y,x,y-Lineal_b);
        HelpMe(50);
        SetMouseBereich(winx,winy,winx+Breite,winy+Hoehe);
        end;
    if KeyPressed then
    repeat ch := ReadKey; until not KeyPressed
    end
  else begin
    if (my > winy+Hoehe-85) and (my < winy+Hoehe-65) and
       (mx > winx+70) and (mx < winx+90) then begin
      saveit := not saveit;
      if saveit then
        SetColor(F_Text)
      else
        SetColor(F_Fenster);
      MouseWeg;
      OutTextXY(winx+80,winy+Hoehe-77,'X');
      OutTextXY(winx+81,winy+Hoehe-77,'X');
      MouseHer;
      end;
    if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { Abbrechen }
       (mx > winx+20) and (mx < winx+Breite div 2 - 10) then
      Ende := TRUE;
    if (my > winy+Hoehe-50) and (my < winy+Hoehe-20) and        { OK }
       (mx > winx+Breite div 2 + 10) and (mx < winx+Breite - 20) then begin
      Ende := TRUE;
      raus := TRUE;
      end;
    end;
until Ende;
Entprellen;
MouseWeg;
SetMouseBereich(0,0,x,y);
Close_Text_Win(1,winx,winy);
mx := savemouse_x;
my := savemouse_y;
SetMouseBereich(0,0,x,y);
MouseHer;
if saveit and raus then
  if MRFSName = 'Noname.mfs' then
    Speichern(True)
  else
    Speichern(False);
end;

begin
Menue_already_closed := False;
LupAnz := 0;
end.