unit ifs_item;
INTERFACE
uses graph,ifs_def,ifs_win,mymouse,xms,ifs_Twin;

const XmsListe = 0;
      Loeschen = 1;
      Suchen   = 2;

var Aktiver_Bereich,
    Anzahl_Bereiche : Byte;
    Aktive_Fkt      : Array [1..15] of Byte;
    ArbeitsBereich,
    SuchBereich     : IFSptr;
    xmsBereich      : Array[1..15] of integer;
    xmsBereichsize  : word;
    Memsize,Maxsize : longint;
    LoeschRest : LRTable;

function Get_Bereichsnummer(nummer:Byte):char;
function Get_Bereichspointernummer(Kennung:char):Byte;

procedure Bereich_auslagern(Nummer: Byte; wohin: Byte);
procedure Bereich_einlagern(nummer:Byte; vonwo: Byte);
procedure Calc_LBListe;
procedure DoIt(what: Byte);
procedure Snap_B;
procedure Snap_F;
procedure Set_Lastop(Nummer:Byte);
procedure LFunk_loeschen_sichern(Fkt:lineare_Funktion);
procedure Funk_sichern(Fkt: Funktionstyp);
procedure Gib_mir_FSpeicher;

IMPLEMENTATION

const linear : Boolean = True;

var LoeschFktBnr, LoeschFktNr,
    Lastop, i : Byte;
    LoeschBereichListe : Array[1..15] of char;
    LoeschXmsBereich   : integer;
    Loeschbereich      : Single_IFS;
    LoeschFkt  : Funktionstyp;
    LoeschLFkt : Lineare_Funktion;
    LoeschNFkt : NonLin_Funktion;

procedure SuchBereich_einlagern(nummer:Byte); forward;

function B_Loescherlaubnis(IntNummer: Byte; Bnummer : char) : Boolean;
var i,j : Byte;
begin
if Anzahl_Bereiche < 1 then begin
  B_Loescherlaubnis := False;
  Exit;
  end;
if Anzahl_Bereiche = 1 then begin
  B_Loescherlaubnis := True;                 { Bereich kann nicht in einem }
  Exit;                                      { MRFS bentigt werden        }
  end;
for i := 1 to Anzahl_Bereiche do
  if i <> IntNummer then begin
    SuchBereich_einlagern(i);
    if SuchBereich^.Anzahl_Fkt > 0 then
      for j := 1 to SuchBereich^.Anzahl_Fkt do begin
        if (SuchBereich^.Funktion[j]^.Bereich = Bnummer) then begin
          B_Loescherlaubnis := False;
          if SuchBereich^.Funktion[j]^.Art then
            FreeMem(SuchBereich^.Funktion[j]^.LFunk,LF_size)
          else
            FreeMem(SuchBereich^.Funktion[j]^.NFunk,NF_size);
          FreeMem(SuchBereich^.Funktion[j]^.Restriction,LR_size);
          FreeMem(SuchBereich^.Funktion[j],F_size);
          Exit;
          end;
        if SuchBereich^.Funktion[j]^.Art then
          FreeMem(SuchBereich^.Funktion[j]^.LFunk,LF_size)
        else
          FreeMem(SuchBereich^.Funktion[j]^.NFunk,NF_size);
        FreeMem(SuchBereich^.Funktion[j]^.Restriction,LR_size);
        FreeMem(SuchBereich^.Funktion[j],F_size);
      end;
    FreeMem(SuchBereich,B_size);
    end;
B_Loescherlaubnis := True;
end;

function GetWinkel(px,py,qx,qy : double): double;
var dx,dy : double;
begin
if px = qx then
  if py < qy then
    GetWinkel := Pi / 2
  else
    GetWinkel := 3 * Pi / 2
else begin
  dx := qx - px;
  dy := qy - py;
  if dx > 0 then
    GetWinkel := ArcTan(dy / dx)
  else
    GetWinkel := ArcTan(dy / dx) + Pi;
  end;
end;

function Flaeche(Funk: nonlin_Funktion): double;
var i,j : Byte;
    a,b,alpha,
    aread,areas : double;
begin
areas := 0;
with Funk do begin
  for j := 0 to 2 do
    for i := 0 to 2 do begin
      a := Sqrt(Sqr(Punkt[j*4+i+1].x-Punkt[j*4+i].x)+
           Sqr(Punkt[j*4+i+1].y-Punkt[j*4+i].y));
      b := Sqrt(Sqr(Punkt[j*4+i+4].x-Punkt[j*4+i].x)+
           Sqr(Punkt[j*4+i+4].y-Punkt[j*4+i].y));
      alpha := GetWinkel(Punkt[j*4+i].x,Punkt[j*4+i].y,
                             Punkt[j*4+i+4].x,Punkt[j*4+i+4].y) -
               GetWinkel(Punkt[j*4+i].x,Punkt[j*4+i].y,
                             Punkt[j*4+i+1].x,Punkt[j*4+i+1].y);
      aread := a*b/2 * Abs(sin(alpha));
      areas := areas + aread;
      a := Sqrt(Sqr(Punkt[j*4+i+5].x-Punkt[j*4+i+4].x)+
           Sqr(Punkt[j*4+i+5].y-Punkt[j*4+i+4].y));
      b := Sqrt(Sqr(Punkt[j*4+i+5].x-Punkt[j*4+i+1].x)+
           Sqr(Punkt[j*4+i+5].y-Punkt[j*4+i+1].y));
      alpha := GetWinkel(Punkt[j*4+i+5].x,Punkt[j*4+i+5].y,
                             Punkt[j*4+i+1].x,Punkt[j*4+i+1].y) -
               GetWinkel(Punkt[j*4+i+5].x,Punkt[j*4+i+5].y,
                             Punkt[j*4+i+4].x,Punkt[j*4+i+4].y);
      aread := a*b/2 * Abs(sin(alpha));
      areas := areas + aread;
      end;
    end;
Flaeche := areas;
end;

function det(Funk: Lineare_Funktion) : double;
begin
with Funk do
  det := Abs(a*d - b*c);
end;

function Berechne_detsum : double;
var i : integer;
    detsum : double;
begin
detsum := 0;
with ArbeitsBereich^ do
  for i := 1 to Anzahl_Fkt do
    if Funktion[i]^.Art then
      detsum := detsum + det(Funktion[i]^.LFunk^)
    else
      detsum := detsum + Flaeche(Funktion[i]^.NFunk^);
Berechne_detsum := detsum;
end;

function GetWahrscheinlichkeit(Funk : FunktionsTyp) : real;
var i : integer;
    detsum : double;
begin
detsum := Berechne_detsum;
if Funk.Art then
  GetWahrscheinlichkeit := det(Funk.LFunk^) / detsum
else
  GetWahrscheinlichkeit := Flaeche(Funk.NFunk^) / detsum;
end;

function sign(x: double): integer;
begin
if x = 0 then sign := 0
else if x < 0 then sign := -1
  else sign := 1;
end;

function Abstand(p1,p2,px: RPunkttyp): real;
var dx,dy,nx,ny : double;
begin
if (sign(p1.x - px.x) <> sign(p2.x - px.x)) or
   (sign(p1.y - px.y) <> sign(p2.y - px.y)) then begin
  dx := px.x - p1.x;
  dy := px.y - p1.y;
  nx := p2.y - p1.y;
  ny := -p2.x + p1.x;
  Abstand := Abs((dx*nx + dy*ny)/sqrt(sqr(nx)+sqr(ny)));
  end
else
  Abstand := -1;
end;

function Get_Bereichsnummer(nummer:Byte):char;
var i,j : Byte;
begin
if LoeschBereichListe[1] = ' ' then begin
  Get_Bereichsnummer := chr(Ord('A')+Pred(nummer));
  Exit;
  end
else begin
  j := 0;
  for i := 1 to nummer do begin
    if (LoeschBereichListe[i] = ' ') or
       (LoeschBereichListe[i] > Chr(Ord('A')+Pred(nummer))) then begin
      Get_Bereichsnummer := chr(Ord('A')+Pred(nummer)+j);
      Exit;
      end
    else
      Inc(j);
    end;
  Get_Bereichsnummer := chr(Ord('A')+Pred(nummer)+j);
  end;
end;

function Get_Bereichspointernummer(Kennung:char):Byte;
var i,j : Byte;
begin
if LoeschBereichListe[1] = ' ' then begin
  Get_Bereichspointernummer := Ord(Kennung) - Ord('A') + 1;
  Exit;
  end
else begin
  j := 0;
  for i := 1 to 15 do begin
    if (LoeschBereichListe[i] = ' ') or
       (LoeschBereichListe[i] > Kennung) then begin
      Get_Bereichspointernummer := Ord(Kennung)-Ord('A')-j+1;
      Exit;
      end
    else
      Inc(j);
    end;
  Get_Bereichspointernummer := Ord(Kennung)-Ord('A')-j+1;
  end;
end;

procedure Bereich_auslagern(Nummer: Byte; wohin: Byte);
var Anz_Byte : word;
    Handle : integer;
    i : Byte;
begin
Anz_Byte := 0;
case wohin of
  XmsListe : Handle := XmsBereich[Nummer];
  Loeschen : Handle := LoeschXmsBereich;
  end;
if Nummer > 0 then begin
  XmsCopy(0,longint(ArbeitsBereich),Handle,0,B_size div 2);
  Inc(Anz_Byte,B_size);
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do begin
        XmsCopy(0,longint(Funktion[i]),Handle,Anz_Byte,F_size div 2);
        Inc(Anz_Byte,F_size);
        if Funktion[i]^.Art then begin
          XmsCopy(0,longint(Funktion[i]^.LFunk),Handle,Anz_Byte,LF_size div 2);
          FreeMem(Funktion[i]^.LFunk,sizeof(Lineare_Funktion));
          Inc(Anz_Byte,LF_size);
          end
        else begin
          XmsCopy(0,longint(Funktion[i]^.NFunk),Handle,Anz_Byte,NF_size div 2);
          FreeMem(Funktion[i]^.NFunk,sizeof(nonlin_Funktion));
          Inc(Anz_Byte,NF_size);
          end;
        XmsCopy(0,longint(Funktion[i]^.Restriction),Handle,Anz_Byte,LR_size div 2);
        Inc(Anz_Byte,LR_size);
        FreeMem(Funktion[i]^.Restriction,sizeof(LRTable));
        FreeMem(Funktion[i],sizeof(Funktionstyp));
        end;
  FreeMem(ArbeitsBereich,sizeof(Single_IFS));
  ArbeitsBereich := nil;
  end;
end;

procedure Bereich_einlagern(nummer:Byte; vonwo: Byte);
var Anz_Byte,
    Handle : word;
    i : Byte;
begin
Anz_Byte := 0;
case vonwo of
  XmsListe : Handle := XmsBereich[nummer];
  Loeschen : Handle := LoeschXmsBereich;
  end;
GetMem(ArbeitsBereich,B_size);
XmsCopy(Handle,0,0,longint(ArbeitsBereich),B_size div 2);
Inc(Anz_Byte,B_size);
with ArbeitsBereich^ do
  if Anzahl_Fkt > 0 then
    for i := 1 to Anzahl_Fkt do begin
      GetMem(Funktion[i],F_size);
      XmsCopy(Handle,Anz_Byte,0,longint(Funktion[i]),F_size div 2);
      Inc(Anz_Byte,F_size);
      if Funktion[i]^.Art then begin
        GetMem(Funktion[i]^.LFunk,LF_size);
        XmsCopy(Handle,Anz_Byte,0,longint(Funktion[i]^.LFunk),LF_size div 2);
        Inc(Anz_Byte,LF_size);
        Funktion[i]^.NFunk := nil;
        end
      else begin
        GetMem(Funktion[i]^.NFunk,NF_size);
        XmsCopy(Handle,Anz_Byte,0,longint(Funktion[i]^.NFunk),NF_size div 2);
        Inc(Anz_Byte,NF_size);
        Funktion[i]^.LFunk := nil;
        end;
      GetMem(Funktion[i]^.Restriction,LR_size);
      XmsCopy(Handle,Anz_Byte,0,longint(Funktion[i]^.Restriction),LR_size div 2);
      Inc(Anz_Byte,LR_size);
    end;
end;

procedure SuchBereich_einlagern(nummer:Byte);
var Anz_Byte,
    Handle : word;
    i : Byte;
begin
Anz_Byte := 0;
Handle := XmsBereich[nummer];
GetMem(SuchBereich,B_size);
XmsCopy(Handle,0,0,longint(SuchBereich),B_size div 2);
Inc(Anz_Byte,B_size);
with SuchBereich^ do
  if Anzahl_Fkt > 0 then
    for i := 1 to Anzahl_Fkt do begin
      GetMem(Funktion[i],F_size);
      XmsCopy(Handle,Anz_Byte,0,longint(Funktion[i]),F_size div 2);
      Inc(Anz_Byte,F_size);
      if Funktion[i]^.Art then begin
        GetMem(Funktion[i]^.LFunk,LF_size);
        XmsCopy(Handle,Anz_Byte,0,longint(Funktion[i]^.LFunk),LF_size div 2);
        Inc(Anz_Byte,LF_size);
        Funktion[i]^.NFunk := nil;
        end
      else begin
        GetMem(Funktion[i]^.NFunk,NF_size);
        XmsCopy(Handle,Anz_Byte,0,longint(Funktion[i]^.NFunk),NF_size div 2);
        Inc(Anz_Byte,NF_size);
        Funktion[i]^.LFunk := nil;
        end;
      GetMem(Funktion[i]^.Restriction,LR_size);
      XmsCopy(Handle,Anz_Byte,0,longint(Funktion[i]^.Restriction),LR_size div 2);
      Inc(Anz_Byte,LR_size);
    end;
end;

procedure snap_B;
const Maxdist = 5.0;
var i,j : Byte;
    p1,p2,mp : RPunkttyp;
    Dist : real;
begin
if Anzahl_Bereiche = 0 then
  Exit;
mp.x := mx-GraphWin_x+scroll_x;
mp.y := y-my-Lineal_b+scroll_y;
for i := 1 to Anzahl_Bereiche do begin
  for j := 0 to 3 do begin
    p1.x := Get_B_Koord_x(i,j);
    p1.y := Get_B_Koord_y(i,j);
    p2.x := Get_B_Koord_x(i,Succ(j));
    p2.y := Get_B_Koord_y(i,Succ(j));
    Dist := Abstand(p1,p2,mp);
    if (Dist >= 0) and (Dist < Maxdist) then begin
      Bereich_auslagern(Aktiver_Bereich,XmsListe);
      Aktiver_Bereich := i;
      Bereich_einlagern(Aktiver_Bereich,XmsListe);
      MouseWeg;
      Refresh(i,Aktive_Fkt[Aktiver_Bereich],fix,fix);
      MouseHer;
      Bereichsfeld;
      with ArbeitsBereich^ do
        Bereich_anzeigen(Bereichsnummer,name);
      if Funktionsanzeige then
        Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
      else
        MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
      end;
    end;
  end;
end;

procedure snap_F;
const Maxdist = 5.0;
var i,j,k    : Byte;
    p1,p2,mp : RPunkttyp;
    Dist     : real;
    snapped  : Boolean;
begin
if Anzahl_Bereiche = 0 then
  Exit;
if ArbeitsBereich^.Anzahl_Fkt = 0 then
  Exit;
mp.x := mx-GraphWin_x+scroll_x;
mp.y := y-my-Lineal_b+scroll_y;
i := Aktiver_Bereich;
for j := 1 to ArbeitsBereich^.Anzahl_Fkt do begin
  snapped := False;
  if ArbeitsBereich^.Funktion[j]^.Art then begin
    for k := 0 to 3 do begin
      p1.x := Get_F_Koord_x(i,j,k);
      p1.y := Get_F_Koord_y(i,j,k);
      p2.x := Get_F_Koord_x(i,j,Succ(k));
      p2.y := Get_F_Koord_y(i,j,Succ(k));
      Dist := Abstand(p1,p2,mp);
      if (Dist >= 0) and (Dist < Maxdist) then
        snapped := True;
      end;
    end
  else begin
    for k := 0 to 2 do begin
      p1.x := Get_NF_Koord_x(i,j,k);
      p1.y := Get_NF_Koord_y(i,j,k);
      p2.x := Get_NF_Koord_x(i,j,Succ(k));
      p2.y := Get_NF_Koord_y(i,j,Succ(k));
      Dist := Abstand(p1,p2,mp);
      if (Dist >= 0) and (Dist < Maxdist) then
        snapped := True;
      end;
    for k := 12 to 14 do begin
      p1.x := Get_NF_Koord_x(i,j,k);
      p1.y := Get_NF_Koord_y(i,j,k);
      p2.x := Get_NF_Koord_x(i,j,Succ(k));
      p2.y := Get_NF_Koord_y(i,j,Succ(k));
      Dist := Abstand(p1,p2,mp);
      if (Dist >= 0) and (Dist < Maxdist) then
        snapped := True;
      end;
    for k := 0 to 2 do begin
      p1.x := Get_NF_Koord_x(i,j,k*4);
      p1.y := Get_NF_Koord_y(i,j,k*4);
      p2.x := Get_NF_Koord_x(i,j,Succ(k)*4);
      p2.y := Get_NF_Koord_y(i,j,Succ(k)*4);
      Dist := Abstand(p1,p2,mp);
      if (Dist >= 0) and (Dist < Maxdist) then
        snapped := True;
      end;
    for k := 0 to 2 do begin
      p1.x := Get_NF_Koord_x(i,j,k*4+3);
      p1.y := Get_NF_Koord_y(i,j,k*4+3);
      p2.x := Get_NF_Koord_x(i,j,Succ(k)*4+3);
      p2.y := Get_NF_Koord_y(i,j,Succ(k)*4+3);
      Dist := Abstand(p1,p2,mp);
      if (Dist >= 0) and (Dist < Maxdist) then
        snapped := True;
      end;
    end;
  if snapped then begin
    if Funktionsanzeige then
      Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                        inaktiv,NumWin_y1);
    Aktive_Fkt[Aktiver_Bereich] := j;
    if Funktionsanzeige then
      Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                        aktiv,NumWin_y1)
    else
      MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
    MouseWeg;
    Refresh(i,Aktive_Fkt[Aktiver_Bereich],fix,fix);
    MouseHer;
    Exit;
    end;
  end;
end;

procedure Set_Lastop(Nummer:Byte);
begin
Lastop := nummer;
end;

procedure LFunk_loeschen_sichern(Fkt:lineare_Funktion);
begin
LoeschLFkt := Fkt;
LoeschFktBnr := Aktiver_Bereich;
LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
end;

procedure Funk_sichern(Fkt: Funktionstyp);
begin
LoeschFkt := Fkt;
if LoeschFkt.Art then
  LoeschLFkt := Fkt.LFunk^
else
  LoeschNFkt := Fkt.NFunk^;
LoeschFktBnr := Aktiver_Bereich;
LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
end;

procedure Calc_LBListe;
var i,j : Byte;
begin
for i := 1 to 15 do
  LoeschBereichListe[i] := ' ';
Bereich_auslagern(Aktiver_Bereich,XmsListe);
j := 0;
for i := 1 to Anzahl_Bereiche do begin
  Bereich_einlagern(i,XmsListe);
  while ArbeitsBereich^.Bereichsnummer <> Chr(Pred(i)+j+Ord('A')) do begin
    LoeschBereichListe[i+j] := Chr(Pred(i)+j+Ord('A'));
    inc(j);
    end;
  Bereich_auslagern(i,XmsListe);
  end;
Bereich_einlagern(Aktiver_Bereich,XmsListe);
end;

procedure Neuer_Bereich;
var j : Byte;
    Anz_Byte : word;
begin
if Anzahl_Bereiche >= Max_Bereiche then
  Exit;
if Aktiver_Bereich > 0 then begin
  Draw_Bereich(Aktiver_Bereich,sichtbar,inaktiv,fix);
  if Aktive_Fkt[Aktiver_Bereich] > 0 then
    Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                  sichtbar,inaktiv,fix);
  end;

if LoeschBereichListe[1] <> ' ' then begin                { Bereichsnummer }
  j := Succ(Ord(LoeschBereichListe[1]) - Ord('A'));       { ermitteln      }
  for i := 1 to Pred(Max_Bereiche) do                     { und ggf aus    }
    LoeschBereichListe[i] := LoeschBereichListe[Succ(i)]; { Lschliste     }
  LoeschBereichListe[Max_Bereiche] := ' ';                { streichen      }
  end
else
  j := Succ(Anzahl_Bereiche);

if Aktiver_Bereich > 0 then
  Bereich_auslagern(Aktiver_Bereich,XmsListe);
Inc(Anzahl_Bereiche);
for i := Pred(Anzahl_Bereiche) downto j do begin
  XmsBereich[Succ(i)] := XmsBereich[i];                   {Platz freimachen}
  Aktive_Fkt[Succ(i)] := Aktive_Fkt[i];
  end;
XmsBereich[j] := XMSGetMem(xmsBereichsize);
if (XmsBereich[j] = 0) or (MaxAvail < B_size) then begin
  for i := j to Pred(Anzahl_Bereiche) do begin            { Verschiebungen }
    XmsBereich[i] := XmsBereich[Succ(i)];              { rckgngig machen }
    Aktive_Fkt[i] := Aktive_Fkt[Succ(i)];
    end;
  Bereich_einlagern(Aktiver_Bereich,XmsListe);
  Dec(Anzahl_Bereiche);
  Exit;
  end;
GetMem(ArbeitsBereich,B_size);
with ArbeitsBereich^ do begin
  Bereichsnummer := chr(Ord('A')+Pred(j));
  Name := 'noname.ifs';
  Linearitaet := True;
  Anzahl_Fkt := 0;
  for i := 1 to 15 do
    Funktion[i] := nil;
  Form := Defaults._Form;
  end;
Aktiver_Bereich := j;
Aktive_Fkt[j] := 0;
insert_B_Poly(j);
recalc_B_Poly(j,ArbeitsBereich^);
Visible[j].Bereich := TRUE;
Visible[j].Funktion := TRUE;
Visible[j].Fixpunkt := TRUE;
Draw_Bereich(j,sichtbar,aktiv,fix);
Bereichsfeld;
with ArbeitsBereich^ do
  Bereich_anzeigen(Bereichsnummer,name);
Fkt_Fenster;
if Funktionsanzeige then
  if Fkt_scroll then
    Fkt_Header2(0,Numwin_y1)
  else
    Fkt_Header1(0,Numwin_y1);
LoeschFktBnr := Aktiver_Bereich;
Lastop := 11;
end;  {Neuer_Bereich}

procedure Bereich_Loeschen;
var i,j : Byte;
    Handle : integer;
    Bnummer: char;
begin
if Anzahl_Bereiche = 0 then
  Exit;
if not B_Loescherlaubnis(Aktiver_Bereich,ArbeitsBereich^.Bereichsnummer) then begin
  Bnummer := ArbeitsBereich^.Bereichsnummer;
  Bereich_auslagern(Aktiver_Bereich,XmsListe);
  for i := 1 to Anzahl_Bereiche do begin
    Bereich_einlagern(i,XmsListe);              {Bei allen Funktionen, die}
    with ArbeitsBereich^ do                     {sich auf den zu lschenden}
      if Anzahl_Fkt > 0 then                    {Bereich beziehen, diesen}
        for j := 1 to Anzahl_Fkt do             {in einen Selbstbezug ndern}
          if Funktion[j]^.Bereich = Bnummer then
            Funktion[j]^.Bereich := ArbeitsBereich^.Bereichsnummer;
    Bereich_auslagern(i,XmsListe);
    end;
  Bereich_einlagern(Aktiver_Bereich,XmsListe);
  end;
Handle := XmsBereich[Aktiver_Bereich];
Loeschbereich := ArbeitsBereich^;
Bereich_auslagern(Aktiver_Bereich,Loeschen);
LoeschFktBnr := Aktiver_Bereich;
LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
XmsFreeMem(Handle);
if Aktiver_Bereich < Anzahl_Bereiche then begin
  for i := Aktiver_Bereich to Pred(Anzahl_Bereiche) do begin
    XmsBereich[i] := XmsBereich[Succ(i)];
    Aktive_Fkt[i] := Aktive_Fkt[Succ(i)];
    end;
  end;
XmsBereich[Anzahl_Bereiche] := 0;
Aktive_Fkt[Anzahl_Bereiche] := 0;
for i := 1 to LoeschBereich.Anzahl_Fkt do
  Draw_Funktion(LoeschFktBnr,i,unsichtbar,aktiv,fix);
Draw_Bereich(LoeschFktBnr,unsichtbar,aktiv,fix);
remove_B_Poly(Aktiver_Bereich);
if Aktiver_Bereich = Anzahl_Bereiche then
  Dec(Aktiver_Bereich);
Dec(Anzahl_Bereiche);
if Aktiver_Bereich > 0 then
  Bereich_einlagern(Aktiver_Bereich,XmsListe);

i := 0;                                         { Bereich in Lschliste }
repeat                                          { eintragen             }
  Inc(i);
until (LoeschBereichListe[i] > LoeschBereich.Bereichsnummer) or
      (LoeschBereichListe[i] = ' ');
for j := Max_Bereiche downto Succ(i) do
  LoeschBereichListe[j] := LoeschBereichListe[Pred(j)];
LoeschBereichListe[i] := Loeschbereich.Bereichsnummer;

Bereichsfeld;
if Anzahl_Bereiche > 0 then begin
  Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
  with ArbeitsBereich^ do
    Bereich_anzeigen(Bereichsnummer,name);
  if Funktionsanzeige then
    Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
  else
    MRFS_anzeigen(Arbeitsbereich^,Aktive_Fkt[Aktiver_Bereich]);
  end
else begin
  Bereich_anzeigen('*','Kein IFS    ');
  Fkt_Fenster;
  end;
Umrahmung;
Lastop := 12;
end;   {Bereich_loeschen}

procedure Neue_Funktion;
var i,j : Byte;
begin
if Aktiver_Bereich = 0 then
  Exit;
if MaxAvail < F_size + LF_size + LR_size then
  Exit;
if Aktive_Fkt[Aktiver_Bereich] > 0 then
  if Funktionsanzeige then
    Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                      FALSE,NumWin_y1);
  Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,inaktiv,fix);
with ArbeitsBereich^ do begin
  if Anzahl_Fkt >= Max_Funktionen then begin
    if Funktionsanzeige then
      Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                        TRUE,NumWin_y1);
    Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
    Exit;
    end;
  Inc(Anzahl_Fkt);
  Aktive_Fkt[Aktiver_Bereich] := Anzahl_Fkt;
  GetMem(Funktion[Anzahl_Fkt],F_size);
  with Funktion[Anzahl_Fkt]^ do begin
    Nummer := Anzahl_Fkt;
    Art := linear;
    Bereich := ArbeitsBereich^.Bereichsnummer;
    GetMem(LFunk,LF_size);
    NFunk := nil;
    with Defaults do begin
      LFunk^ := _LFunk;
      Winkel := _Winkel;
      end;
    Farbe := 128;
    GetMem(Restriction,LR_size);
    with Restriction^ do begin
      for i := 1 to Max_LR_laenge-3 do
        LR[i] := ' ';
      LR[Max_LR_laenge-2] := '(';
      LR[Max_LR_laenge-1] := ArbeitsBereich^.Bereichsnummer;
      LR[Max_LR_laenge]   := ')';
      for i := 1 to Anzahl_Fkt do begin
        if i < 10 then begin
          LR[i*2-1] := chr(48+i);
          if i < Anzahl_Fkt then
            LR[i*2] := ',';
          end
        else begin
          LR[i*3-11] := '1';
          LR[i*3-10] := chr(48+ i mod 10);
          if i < Anzahl_Fkt then
            LR[i*3-9]  := ',';
          end;
        end;
      end;
    insert_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich]);
    recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,LFunk^);
    end;
  for i := 1 to Anzahl_Fkt do 
    Funktion[i]^.Wahrscheinlichkeit := GetWahrscheinlichkeit(Funktion[i]^);
  for i := 1 to Pred(Anzahl_Fkt) do begin
{    if Funktion[i]^.Bereich = ArbeitsBereich^.Bereichsnummer then}
      with Funktion[i]^.Restriction^ do begin
        j := 0;
        repeat Inc(j); until LR[j] = ' ';
        LR[j] := ',';
        Inc(j);
        if Anzahl_Fkt >= 10 then begin
          LR[j] := '1';
          Inc(j);
          end;
        LR[j] := chr(48+ Anzahl_Fkt mod 10);
        Inc(j);
        end;
    end;
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
if Funktionsanzeige then
  if Fkt_Scroll then
    Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
  else
    Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                      TRUE,NumWin_y1)
else
  MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
LoeschFktBnr := Aktiver_Bereich;
LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
Lastop := 1;
end;   {Neue_Funktion}

procedure Funktion_Loeschen;
var i,j,k: Byte;
    s,s1 : string;
begin
if Aktive_Fkt[Aktiver_Bereich] < 1 then
  Exit;
LoeschFktBnr := Aktiver_Bereich;
LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
with ArbeitsBereich^ do begin
  LoeschFkt := Funktion[LoeschFktNr]^;
  if Funktion[LoeschFktNr]^.Art then begin
    LoeschLFkt := Funktion[LoeschFktNr]^.LFunk^;
    FreeMem(Funktion[LoeschFktNr]^.LFunk,LF_size);
    end
  else begin
    LoeschNFkt := Funktion[LoeschFktNr]^.NFunk^;
    FreeMem(Funktion[LoeschFktNr]^.NFunk,NF_size);
    end;
  LoeschRest := Funktion[LoeschFktNr]^.Restriction^;
  FreeMem(Funktion[LoeschFktNr]^.Restriction,LR_size);
  FreeMem(Funktion[LoeschFktNr],F_size);
  end;
with ArbeitsBereich^ do begin
  if Anzahl_Fkt > 0 then
    for i := 1 to Anzahl_Fkt do begin
      with Funktion[i]^.Restriction^ do begin
        if LoeschFktNr < 10 then begin
          s := LR;
          j := pos(Chr(48+LoeschFktNr),s);
          if j = 1 then
            Delete(s,j,2)
          else
            Delete(s,Pred(j),2);
          Insert('  ',s,Max_LR_laenge-5);
          for j := 1 to Max_LR_Laenge do
            LR[j] := s[j];
          end
        else begin
          s := LR;
          j := pos('1'+Chr(48+LoeschFktNr mod 10),s);
          if j = 1 then
            Delete(s,j,3)
          else
            Delete(s,Pred(j),3);
          Insert('   ',s,Max_LR_laenge-6);
          for j := 1 to Max_LR_Laenge do
            LR[j] := s[j];
          end;
        end;
      end;
  if LoeschFktNr < Anzahl_Fkt then
    for i := LoeschFktNr to Pred(Anzahl_Fkt) do begin
      Funktion[i] := Funktion[Succ(i)];
      Funktion[i]^.Nummer := Pred(Funktion[i]^.Nummer)
      end;
  Funktion[Anzahl_Fkt] := nil;
  if Anzahl_Fkt = Aktive_Fkt[Aktiver_Bereich] then
    Dec(Aktive_Fkt[Aktiver_Bereich]);
  Dec(Anzahl_Fkt);
  Draw_Funktion(LoeschFktBnr,LoeschFktNr,unsichtbar,aktiv,fix);
  if LoeschFkt.Art then
    remove_F_Poly(LoeschFktBnr,LoeschFktNr)
  else
    remove_NF_Poly(LoeschFktBnr,LoeschFktNr);
  Refresh(LoeschFktBnr,Aktive_Fkt[Aktiver_Bereich],fix,fix);
  if Anzahl_Fkt > 0 then
    for i := 1 to Anzahl_Fkt do begin
      Funktion[i]^.Wahrscheinlichkeit := GetWahrscheinlichkeit(Funktion[i]^);
      with Funktion[i]^.Restriction^ do begin
        for k := Succ(LoeschFktNr) to Succ(Anzahl_Fkt) do
          if k < 10 then begin
            s := LR;
            j := pos(Chr(48+k),s);
            if j > 0 then begin
              Delete(s,j,1);
              Insert(Chr(48+Pred(k)),s,j);
              for j := 1 to Max_LR_Laenge do
                LR[j] := s[j];
              end;
            end
          else begin
            s := LR;
            j := pos('1'+Chr(48+k mod 10),s);
            if j > 0 then begin
              Delete(s,j,2);
              if Pred(k) < 10 then begin
                Insert(Chr(48+Pred(k)),s,j);
                Insert(' ',s,Max_LR_laenge-6);
                end
              else
                Insert('1'+Chr(48+Pred(k - 10)),s,j);
              for j := 1 to Max_LR_Laenge do
                LR[j] := s[j];
              end;
            end;
          end;
        end;
  end;
Umrahmung;
if Funktionsanzeige then
  Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
else
  MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
Lastop := 2;
end;   {Funktion_loeschen}

procedure Bereich_verschieben;
var save_mouse : Punkttyp;
    dx, dy, i : integer;
    dx1 ,dy1 : double;
    Old_B : B_Koordinaten;
    Old_Visi_F : Boolean;
begin
if Aktiver_Bereich < 1 then
  Exit;
Old_B := ArbeitsBereich^.Form;
Old_Visi_F := Visible[Aktiver_Bereich].Funktion;
save_mouse.x := mx;
save_mouse.y := my;
if Visible[Aktiver_Bereich].Funktion then begin
  Funktion_ausblenden(Aktiver_Bereich);
  Visible[Aktiver_Bereich].Funktion := False;
  end
else
  Old_Visi_F := False;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,fix);
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
mx := GraphWin_X + round(Get_B_Koord_x(Aktiver_Bereich,2))-scroll_x;
my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2))+scroll_y;
MouseHer;
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    dx1 := dx / Skalierung;
    dy1 := dy / Skalierung;
    MouseWeg;
    Inc(mx,dx); Inc(my,dy);
    Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^.Form do begin
      e := e + dx1 / (x-GraphWin_x);
      f := f - dy1 / (y-Menue_y-Lineal_b);
      end;
    recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
    Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
    Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],bewegt,fix);
    MouseHer;
    Umrahmung;
    end;
until ButtonPressed;
MouseWeg;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
if RightButton then begin
  ArbeitsBereich^.Form := Old_B;
  recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  end
else begin
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  Loeschbereich := ArbeitsBereich^;
  LoeschBereich.Form := Old_B;
  LoeschFktBnr := Aktiver_Bereich;
  Lastop := 13;
  end;
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,fix);
if Old_Visi_F then
  Visible[Aktiver_Bereich].Funktion := True;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;  {Bereich_verschieben}

procedure Funktion_verschieben;
var save_mouse : Punkttyp;
    i : Byte;
    dx, dy : integer;
    dx1 ,dy1 : double;
    Old_F : Funktionstyp;
    Old_LF : Lineare_Funktion;
    Old_NF : nonlin_Funktion;
begin
if (Aktiver_Bereich < 1) or (Aktive_Fkt[Aktiver_Bereich] < 1 ) then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
Old_F := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^;
if Arbeitsbereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
  Old_LF := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^;
  mx := GraphWin_x - scroll_x +
        round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
  my := y-Lineal_b + scroll_y -
        round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
  end
else begin
  Old_NF := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^;
  mx := GraphWin_x - scroll_x +
        round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
  my := y-Lineal_b + scroll_y -
        round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,bewegt);
MouseHer;
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    with ArbeitsBereich^.Form do begin
      dx1 := (dx/Skalierung)*cos(Winkel) - (dy/Skalierung)*sin(Winkel);
      dy1 := (dx/Skalierung)*sin(Winkel) + (dy/Skalierung)*cos(Winkel);
      end;
    MouseWeg;
    Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^ do begin
      if Art then begin
        with LFunk^ do begin
          e := e + dx1/(x-GraphWin_x);
          f := f - dy1/(y-Menue_y-Lineal_b);
          end;
        with ArbeitsBereich^ do
          recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                        Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        my := y-Lineal_b + scroll_y -
              round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        end
      else begin
        with NFunk^ do begin
          for i := 0 to 15 do begin
            Punkt[i].x := Punkt[i].x + dx1/(x-GraphWin_x);
            Punkt[i].y := Punkt[i].y - dy1/(y-Menue_y-Lineal_b);
            end;
          end;
        with ArbeitsBereich^ do
          recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                         Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
        my := y-Lineal_b + scroll_y -
              round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
        end;
      end;
    Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,bewegt);
    MouseHer;
    with ArbeitsBereich^do
      if Funktionsanzeige then
        Funktion_anzeigen(Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                          aktiv,NumWin_y1)
      else begin
        i := Pred(Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer)*NumText_abstand;
        Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
        end;
    Umrahmung;
    end;
until ButtonPressed;
MouseWeg;
if RightButton then begin
  Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
  with ArbeitsBereich^ do begin
    Funktion[Aktive_Fkt[Aktiver_Bereich]]^ := Old_F;
    if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ := Old_LF;
      recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                    Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
      end
    else begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ := Old_NF;
      recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                     Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
      end;
    end;
  end
else begin
  Lastop := 3;
  LoeschFktBnr := Aktiver_Bereich;
  LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
  LoeschFkt := Old_F;
  if ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then
    LoeschLFkt := Old_LF
  else
    LoeschNFkt := Old_NF;
  LoeschRest := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.
                Restriction^
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;   {Funktion_verschieben}

procedure Bereich_verzerren;
var save_mouse : Punkttyp;
    dx, dy : integer;
    dx1 ,dy1 : double;
    nullx,nully,
    d1x, d1y, d2x, d2y, d3x, d3y,
    skal, skal1,
    mx0, my0, mx1, my1,
    mx2, my2, mx3, my3,
    mx4, my4, mx5, my5,
    a11, a12, a21, a22 : double;
    Old_B : B_Koordinaten;
    Old_Visi_F : Boolean;
begin
if Aktiver_Bereich < 1 then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
Old_B := ArbeitsBereich^.Form;
if Visible[Aktiver_Bereich].Funktion then begin
  Funktion_ausblenden(Aktiver_Bereich);
  Old_Visi_F := Visible[Aktiver_Bereich].Funktion;
  Visible[Aktiver_Bereich].Funktion := False;
  end
else
  Old_Visi_F := False;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,fix);
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
nullx := Get_B_Koord_x(Aktiver_Bereich,0);
nully := Get_B_Koord_y(Aktiver_Bereich,0);
mx := GraphWin_x+round(Get_B_Koord_x(Aktiver_Bereich,2))-scroll_x;
my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2))+scroll_y;
MouseHer;
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    dx1 := dx / Skalierung;
    dy1 := dy / Skalierung;
    MouseWeg;
    Inc(mx,dx); Inc(my,dy);
    Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^.Form do begin
      mx0 := Get_B_Koord_x(Aktiver_Bereich,2) - nullx + dx1;
      my0 := Get_B_Koord_y(Aktiver_Bereich,2) - nully - dy1;
      mx1 := mx0 * cos(Winkel) + my0 * sin(Winkel);
      my1 := mx0 * (-sin(Winkel)) + my0 * cos(Winkel);
      mx2 := Get_B_Koord_x(Aktiver_Bereich,3) - nullx;
      my2 := Get_B_Koord_y(Aktiver_Bereich,3) - nully;
      mx3 := mx2 * cos(Winkel) + my2 * sin(Winkel);
      my3 := mx2 * (-sin(Winkel)) + my2 * cos(Winkel);
      mx4 := Get_B_Koord_x(Aktiver_Bereich,1) - nullx;
      my4 := Get_B_Koord_y(Aktiver_Bereich,1) - nully;
      mx5 := mx4 * cos(Winkel) + my4 * sin(Winkel);
      my5 := mx4 * (-sin(Winkel)) + my4 * cos(Winkel);
      a11 := (a * cos(Winkel) + c * sin(Winkel));
      a21 := (b * cos(Winkel) + d * sin(Winkel));
      a12 := (a * (-sin(Winkel)) + c * cos(Winkel));
      a22 := (b * (-sin(Winkel)) + d * cos(Winkel));
      a21 := (mx1 - mx5) / (x - GraphWin_x) / Skalierung;
      a12 := (my1 - my3) / (y-Menue_y-Lineal_b) / Skalierung;
      a := a11 * cos(Winkel) + a12 * (-sin(Winkel));
      b := a21 * cos(Winkel) + a22 * (-sin(Winkel));
      c := a11 * sin(Winkel) + a12 * cos(Winkel);
      d := a21 * sin(Winkel) + a22 * cos(Winkel);
      end;
    recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
    Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],bewegt,fix);
    mx := GraphWin_x+round(Get_B_Koord_x(Aktiver_Bereich,2)) - scroll_x;
    my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2)) + scroll_y;
    MouseHer;
    Umrahmung;
    end;
until ButtonPressed;
MouseWeg;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
if RightButton then begin
  ArbeitsBereich^.Form := Old_B;
  recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  end
else begin
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  Loeschbereich := ArbeitsBereich^;
  Loeschbereich.Form := Old_B;
  LoeschFktBnr := Aktiver_Bereich;
  Lastop := 13;
  end;
if Old_Visi_F then
  Visible[Aktiver_Bereich].Funktion := True;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;  {Bereich verzerren}

procedure Funktion_verzerren;
var save_mouse : Punkttyp;
    i          : Byte;
    dx, dy     : integer;
    dx1 ,dy1   : double;
    nullx,nully, Ba, Bd,
    B_Winkel, F_Winkel,
    mx0, my0, mx1, my1,
    mx2, my2, mx3, my3,
    mx4, my4, mx5, my5,
    mx6, my6, mx7, my7,
    a11, a12, a21, a22 : double;
    NFEnde,
    snapped    : Boolean;
    Dist       : real;
    Old_F      : Funktionstyp;
    Old_LF     : Lineare_Funktion;
    Old_NF,ONF : nonlin_Funktion;
begin
if (Aktiver_Bereich < 1) or (Aktive_Fkt[Aktiver_Bereich] < 1) then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
with ArbeitsBereich^ do begin
  Old_F := Funktion[Aktive_Fkt[Aktiver_Bereich]]^;
  if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
    Old_LF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^;
    nullx := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    mx := GraphWin_x - scroll_x +
          round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
    my := y-Lineal_b + scroll_y -
          round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
    end
  else begin
    Old_NF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^;
    nullx := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    mx := GraphWin_x - scroll_x +
          round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
    my := y-Lineal_b + scroll_y -
          round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
    end;
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,bewegt);
MouseHer;
NFEnde := True;
EntPrellen;
repeat
if not ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
  snapped := False;
  NFEnde := False;
  Entprellen;
  repeat                             { bestimmen, welchen Punkt verziehen}
    MouseWeg;
    Open_Text_Win(4,GraphWin_x+10,y-Lineal_b-40,80,30,F_Text_rot,extended);
    SetTextStyle(SmallFont,HorizDir,5);
    SetTextJustify(CenterText,CenterText);
    SetColor(F_Text);
    OutTextXY(GraphWin_x+50,y-Lineal_b-27,'Beenden');
    OutTextXY(GraphWin_x+51,y-Lineal_b-27,'Beenden');
    MouseHer;
    repeat
      Mouse_bewegen;
    until ButtonPressed;
{    Entprellen;}
    if (my > y-Lineal_b-40) and (my < y-Lineal_b-10) and
       (mx > GraphWin_x+10) and (mx < GraphWin_x+90) then begin
      MouseWeg;
      Close_Text_Win(4,GraphWin_x+10,y-Lineal_b-40);
      Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
      mx := save_mouse.x;
      my := save_mouse.y;
      MouseHer;
      NFEnde := True;
      end;
    if not NFEnde then begin
      i := 0;
      repeat
        Dist := (Sqr(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                 i) - (mx-GraphWin_x+scroll_x)) +
                 Sqr(Get_NF_Koord_y(Aktiver_Bereich,Aktive_fkt[Aktiver_Bereich],
                 i) - (y-my-Lineal_b+scroll_y)));
        Inc(i);
      until (i = 16) or (Dist < 25);
      if Dist < 25 then
        snapped := True;
      EntPrellen;
      end;
    if not NFEnde then begin
      MouseWeg;
      Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,bewegt);
      Close_Text_Win(4,GraphWin_x+10,y-Lineal_b-40);
      MouseHer;
      end;
  until snapped or NFEnde;
  Dec(i);
  end;
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
{EntPrellen;}
if ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art or not NFEnde then begin
  if not ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then
    ONF := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^;
  repeat
    ReadMouseMotion(dx,dy);
    if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
      dx1 := dx / Skalierung;
      dy1 := dy / Skalierung;
      MouseWeg;
      Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
      with ArbeitsBereich^.Form do
        B_Winkel := Winkel;
      with ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^ do
        F_Winkel := Winkel;
      if ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
        with ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ do begin
          mx0 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2) - nullx;
          my0 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2) - nully;
          mx2 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nullx;
          my2 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nully;
          mx4 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],1) - nullx;
          my4 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],1) - nully;
          mx1 := mx0 * cos(F_Winkel) + my0 * sin(F_Winkel);
          my1 := mx0 * (-sin(F_Winkel)) + my0 * cos(F_Winkel);
          mx3 := mx2 * cos(F_Winkel) + my2 * sin(F_Winkel);
          my3 := mx2 * (-sin(F_Winkel)) + my2 * cos(F_Winkel);
          mx5 := mx4 * cos(F_Winkel) + my4 * sin(F_Winkel);
          my5 := mx4 * (-sin(F_Winkel)) + my4 * cos(F_Winkel);
          mx6 := mx0 + dx1;
          my6 := my0 - dy1;
          mx7 := (mx6) * cos(F_Winkel) + my6 * sin(F_Winkel);
          my7 := (mx6) * (-sin(F_Winkel)) + my6 * cos(F_Winkel);
          mx0 := mx1 * cos(B_Winkel) + my1 * sin(B_Winkel);
          my0 := mx1 * (-sin(B_Winkel)) + my1 * cos(B_Winkel);
          mx2 := mx3 * cos(B_Winkel) + my3 * sin(B_Winkel);
          my2 := mx3 * (-sin(B_Winkel)) + my3 * cos(B_Winkel);
          mx4 := mx5 * cos(B_Winkel) + my5 * sin(B_Winkel);
          my4 := mx5 * (-sin(B_Winkel)) + my5 * cos(B_Winkel);
          mx6 := mx7 * cos(B_Winkel) + my7 * sin(B_Winkel);
          my6 := mx7 * (-sin(B_Winkel)) + my7 * cos(B_Winkel);
          a11 := a * cos(F_Winkel) + c * sin(F_Winkel);
          a21 := b * cos(F_Winkel) + d * sin(F_Winkel);
          a12 := a * (-sin(F_Winkel)) + c * cos(F_Winkel);
          a22 := b * (-sin(F_Winkel)) + d * cos(F_Winkel);
          with ArbeitsBereich^.Form do begin
            Ba := a * cos(B_Winkel) + c * sin(B_Winkel);
            Bd := b * (-sin(B_Winkel)) + d * cos(B_Winkel);
            end;
          a21 := a21 + (mx6 - mx0) / (x - GraphWin_x) / Ba / Skalierung;
          a12 := a12 + (my6 - my0) / (y-Menue_y-Lineal_b) / Bd / Skalierung;
          a := a11 * cos(F_Winkel) + a12 * (-sin(F_Winkel));
          b := a21 * cos(F_Winkel) + a22 * (-sin(F_Winkel));
          c := a11 * sin(F_Winkel) + a12 * cos(F_Winkel);
          d := a21 * sin(F_Winkel) + a22 * cos(F_Winkel);
          end;
        with ArbeitsBereich^ do
          recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        my := y-Lineal_b + scroll_y -
              round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        end
      else begin                                    {nichtlineare Fkt verzerren}
        with ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ do begin
          Punkt[i].x := Punkt[i].x + dx1/(x-GraphWin_x);
          Punkt[i].y := Punkt[i].y - dy1/(y-Menue_y-Lineal_b);
          end;
        with ArbeitsBereich^ do
          recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],i));
        my := y-Lineal_b + scroll_y -
              round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],i));
        end;
      Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,bewegt);
      MouseHer;
      if Funktionsanzeige then
        Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                          aktiv,NumWin_y1)
      else begin
        i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
        Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
        end;
      Umrahmung;
      end;
  until ButtonPressed;
  if not ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then
    if RightButton then begin
      MouseWeg;
      Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                    unsichtbar,aktiv,bewegt);
      with ArbeitsBereich^ do begin
        Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ := ONF;
        recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                       Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
        end;
      Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                    sichtbar,aktiv,bewegt);
      MouseHer;
      end;
  end;
until NFEnde;
MouseWeg;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
if RightButton then begin
  with ArbeitsBereich^do begin
    Funktion[Aktive_Fkt[Aktiver_Bereich]]^ := Old_F;
    if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ := Old_LF;
      recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                    Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
      end
    else begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ := Old_NF;
      recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                     Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
      end;
    end;
  end
else begin
  with ArbeitsBereich^ do
    for i := 1 to Anzahl_Fkt do
      Funktion[i]^.Wahrscheinlichkeit := GetWahrscheinlichkeit(Funktion[i]^);
  LoeschFktBnr := Aktiver_Bereich;
  LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
  LoeschFkt := Old_F;
  if ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then
    LoeschLFkt := Old_LF
  else
    LoeschNFkt := Old_NF;
  LoeschRest := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.
                Restriction^;
  Lastop := 3;
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
if Funktionsanzeige then
  Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
else begin
  i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
  Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
  end;
mx := save_mouse.x;
my := save_mouse.y;
end;   {Funktion verzerren}

procedure Bereich_skalieren;
var save_mouse : Punkttyp;
    dx, dy : integer;
    dx1 ,dy1 : double;
    nullx,nully,
    d1x, d1y, d2x, d2y, d3x, d3y,
    skal, skal1,
    mx0, my0, mx1, my1,
    mx2, my2, mx3, my3,
    mx4, my4, mx5, my5,
    a11, a12, a21, a22 : double;
    Old_B : B_Koordinaten;
    Old_Visi_F : Boolean;
begin
if Aktiver_Bereich < 1 then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
Old_B := ArbeitsBereich^.Form;
if Visible[Aktiver_Bereich].Funktion then begin
  Funktion_ausblenden(Aktiver_Bereich);
  Visible[Aktiver_Bereich].Funktion := False;
  Old_Visi_F := True;
  end
else
  Old_Visi_F := False;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,fix);
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
nullx := Get_B_Koord_x(Aktiver_Bereich,0);
nully := Get_B_Koord_y(Aktiver_Bereich,0);
mx := GraphWin_x+round(Get_B_Koord_x(Aktiver_Bereich,2)) - scroll_x;
my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2)) + scroll_y;
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
MouseHer;
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    dx1 := dx / Skalierung;
    dy1 := dy / Skalierung;
    MouseWeg;
    Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^.Form do begin
      mx0 := Get_B_Koord_x(Aktiver_Bereich,2) - nullx;
      my0 := Get_B_Koord_y(Aktiver_Bereich,2) - nully;
      mx1 := mx0 * cos(Winkel) + my0 * sin(Winkel);
      my1 := mx0 * (-sin(Winkel)) + my0 * cos(Winkel);
      mx2 := Get_B_Koord_x(Aktiver_Bereich,3) - nullx;
      my2 := Get_B_Koord_y(Aktiver_Bereich,3) - nully;
      mx3 := mx2 * cos(Winkel) + my2 * sin(Winkel);
      my3 := mx2 * (-sin(Winkel)) + my2 * cos(Winkel);
      mx4 := Get_B_Koord_x(Aktiver_Bereich,1) - nullx;
      my4 := Get_B_Koord_y(Aktiver_Bereich,1) - nully;
      mx5 := mx4 * cos(Winkel) + my4 * sin(Winkel);
      my5 := mx4 * (-sin(Winkel)) + my4 * cos(Winkel);
      d1x := mx1 - mx3;
      d1y := my1 - my5;
      d2x := (mx0+dx1) * cos(Winkel) + (my0-dy1) * sin(Winkel) - mx3;
      d2y := (my0-dy1) * cos(Winkel) - (mx0+dx1) * sin(Winkel) - my5;
      if d1x = 0 then skal := 1 else
        skal := d2x / d1x;
      if d1y = 0 then skal1 := 1 else
        skal1 := d2y / d1y;
      if Abs(dy) > Abs(dx) then
        skal := skal1;
      a11 := (a * cos(Winkel) + c * sin(Winkel)) * skal;
      a21 := (b * cos(Winkel) + d * sin(Winkel)) * skal;
      a12 := (a * (-sin(Winkel)) + c * cos(Winkel)) * skal;
      a22 := (b * (-sin(Winkel)) + d * cos(Winkel)) * skal;
      a := a11 * cos(Winkel) + a12 * (-sin(Winkel));
      b := a21 * cos(Winkel) + a22 * (-sin(Winkel));
      c := a11 * sin(Winkel) + a12 * cos(Winkel);
      d := a21 * sin(Winkel) + a22 * cos(Winkel);
      end;
    recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
    Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],bewegt,fix);
    mx := GraphWin_x+round(Get_B_Koord_x(Aktiver_Bereich,2)) - scroll_x;
    my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2)) + scroll_y;
    MouseHer;
    Umrahmung;
    end;
until ButtonPressed;
MouseWeg;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
if RightButton then begin
  ArbeitsBereich^.Form := Old_B;
  recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  end
else begin
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  Loeschbereich := ArbeitsBereich^;
  Loeschbereich.Form := Old_B;
  LoeschFktBnr := Aktiver_Bereich;
  Lastop := 13;
  end;
if Old_Visi_F then
  Visible[Aktiver_Bereich].Funktion := True;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;   {Bereich skalieren}

procedure Funktion_Skalieren;
var save_mouse : Punkttyp;
    i          : Byte;
    dx, dy     : integer;
    dx1 ,dy1   : double;
    nullx,nully, d1x, d1y,
    d2x, d2y, d3x, d3y,
    B_Winkel, F_Winkel,
    skal, skal1,
    mx0, my0, mx1, my1,
    mx2, my2, mx3, my3,
    mx4, my4, mx5, my5,
    mx6, my6, mx7, my7,
    a11, a12, a21, a22 : double;
    Old_F  : Funktionstyp;
    Old_LF : Lineare_Funktion;
    Old_NF : nonlin_Funktion;
begin
if (Aktiver_Bereich < 1) or (Aktive_Fkt[Aktiver_Bereich] < 1) then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
with ArbeitsBereich^ do begin
  Old_F := Funktion[Aktive_Fkt[Aktiver_Bereich]]^;
  if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
    Old_LF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^;
    nullx := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    mx := GraphWin_x - scroll_x +
          round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
    my := y-Lineal_b + scroll_y -
          round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
    end
  else begin
    Old_NF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^;
    nullx := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    mx := GraphWin_x - scroll_x +
          round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
    my := y-Lineal_b + scroll_y -
          round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
    end;
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,bewegt);
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
MouseHer;
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    dx1 := dx / Skalierung;
    dy1 := dy / Skalierung;
    MouseWeg;
    Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^ do begin
      B_Winkel := Form.Winkel;
      with Funktion[Aktive_Fkt[Aktiver_Bereich]]^ do
        F_Winkel := Winkel;
      if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
        with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ do begin
          mx0 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2) - nullx;
          my0 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2) - nully;
          mx2 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nullx;
          my2 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nully;
          mx4 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],1) - nullx;
          my4 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],1) - nully;
          end;
        end
      else begin
        mx0 := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15) - nullx;
        my0 := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15) - nully;
        mx2 := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],12) - nullx;
        my2 := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],12) - nully;
        mx4 := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nullx;
        my4 := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nully;
        end;
      mx1 := mx0 * cos(F_Winkel) + my0 * sin(F_Winkel);
      my1 := mx0 * (-sin(F_Winkel)) + my0 * cos(F_Winkel);
      mx3 := mx2 * cos(F_Winkel) + my2 * sin(F_Winkel);
      my3 := mx2 * (-sin(F_Winkel)) + my2 * cos(F_Winkel);
      mx5 := mx4 * cos(F_Winkel) + my4 * sin(F_Winkel);
      my5 := mx4 * (-sin(F_Winkel)) + my4 * cos(F_Winkel);
      mx6 := mx0 + dx1;
      my6 := my0 - dy1;
      mx7 := (mx6) * cos(F_Winkel) + my6 * sin(F_Winkel);
      my7 := (mx6) * (-sin(F_Winkel)) + my6 * cos(F_Winkel);
      mx0 := mx1 * cos(B_Winkel) + my1 * sin(B_Winkel);
      my0 := mx1 * (-sin(B_Winkel)) + my1 * cos(B_Winkel);
      mx2 := mx3 * cos(B_Winkel) + my3 * sin(B_Winkel);
      my2 := mx3 * (-sin(B_Winkel)) + my3 * cos(B_Winkel);
      mx4 := mx5 * cos(B_Winkel) + my5 * sin(B_Winkel);
      my4 := mx5 * (-sin(B_Winkel)) + my5 * cos(B_Winkel);
      mx6 := mx7 * cos(B_Winkel) + my7 * sin(B_Winkel);
      my6 := mx7 * (-sin(B_Winkel)) + my7 * cos(B_Winkel);
      d1x := mx0 - mx2;
      d1y := my0 - my4;
      d2x := mx6 - mx2;
      d2y := my6 - my4;
      if d1x = 0 then skal := 1 else
        skal := d2x / d1x;
      if d1y = 0 then skal1 := 1 else
        skal1 := d2y / d1y;
      if Abs(dy) > Abs(dx) then
        skal := skal1;
      if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
        with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ do begin
          a11 := (a * cos(F_Winkel) + c * sin(F_Winkel))*skal;
          a21 := (b * cos(F_Winkel) + d * sin(F_Winkel))*skal;
          a12 := (a * (-sin(F_Winkel)) + c * cos(F_Winkel))*skal;
          a22 := (b * (-sin(F_Winkel)) + d * cos(F_Winkel))*skal;
          a := a11 * cos(F_Winkel) + a12 * (-sin(F_Winkel));
          b := a21 * cos(F_Winkel) + a22 * (-sin(F_Winkel));
          c := a11 * sin(F_Winkel) + a12 * cos(F_Winkel);
          d := a21 * sin(F_Winkel) + a22 * cos(F_Winkel);
          end;
        recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                      Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        my := y-Lineal_b + scroll_y -
              round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        end
      else begin
        with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ do begin
          a21 := (Punkt[0].x*cos(F_Winkel) + Punkt[0].y*sin(F_Winkel));
          a22 := (Punkt[0].x*(-sin(F_Winkel)) + Punkt[0].y*cos(F_Winkel));
          for i := 0 to 15 do begin
            a11 := Punkt[i].x*cos(F_Winkel) + Punkt[i].y*sin(F_Winkel);
            a12 := Punkt[i].x*(-sin(F_Winkel)) + Punkt[i].y*cos(F_Winkel);
            a11 := (a11 - a21) * skal + a21;
            a12 := (a12 - a22) * skal + a22;
            Punkt[i].x := a11*cos(F_Winkel) + a12*(-sin(F_Winkel));
            Punkt[i].y := a11*sin(F_Winkel) + a12*cos(F_Winkel);
            end;
          end;
        recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                       Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
        my := y-Lineal_b + scroll_y -
              round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
        end;
      Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,bewegt);
      MouseHer;
      if Funktionsanzeige then
        Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                          aktiv,NumWin_y1)
    else begin
      i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
      Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
      end;
      Umrahmung;
      end;
    end;
until ButtonPressed;
MouseWeg;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
if RightButton then begin
  with ArbeitsBereich^do begin
    Funktion[Aktive_Fkt[Aktiver_Bereich]]^ := Old_F;
    if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ := Old_LF;
      recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                    Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
      end
    else begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ := Old_NF;
      recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                     Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
      end;
    end;
  end
else begin
  with ArbeitsBereich^ do
    for i := 1 to Anzahl_Fkt do
      Funktion[i]^.Wahrscheinlichkeit := GetWahrscheinlichkeit(Funktion[i]^);
  LoeschFktBnr := Aktiver_Bereich;
  LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
  LoeschFkt := Old_F;
  if ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then
    LoeschLFkt := Old_LF
  else
    LoeschNFkt := Old_NF;
  LoeschRest := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.
                Restriction^;
  Lastop := 3;
  end;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
if Funktionsanzeige then
  Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
else begin
  i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
  Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
  end;
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;   {Funktion skalieren}

procedure Bereich_Dehnen;
var save_mouse : Punkttyp;
    dx, dy : integer;
    dx1 ,dy1 : double;
    nullx,nully,
    d1x, d1y, d2x, d2y, d3x, d3y,
    skal, skal1,
    mx0, my0, mx1, my1,
    mx2, my2, mx3, my3,
    mx4, my4, mx5, my5,
    a11, a12, a21, a22 : double;
    Old_B : B_Koordinaten;
    Old_Visi_F : Boolean;
begin
if Aktiver_Bereich < 1 then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
Old_B := ArbeitsBereich^.Form;
Old_B := ArbeitsBereich^.Form;
if Visible[Aktiver_Bereich].Funktion then begin
  Funktion_ausblenden(Aktiver_Bereich);
  Visible[Aktiver_Bereich].Funktion := False;
  Old_Visi_F := True;
  end
else
  Old_Visi_F := False;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,fix);
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
nullx := Get_B_Koord_x(Aktiver_Bereich,0);
nully := Get_B_Koord_y(Aktiver_Bereich,0);
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
mx := GraphWin_x+round(Get_B_Koord_x(Aktiver_Bereich,2)) - scroll_x;
my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2)) + scroll_y;
MouseHer;
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    dx1 := dx / Skalierung;
    dy1 := dy / Skalierung;
    MouseWeg;
    Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^.Form do begin
      mx0 := Get_B_Koord_x(Aktiver_Bereich,2) - nullx;
      my0 := Get_B_Koord_y(Aktiver_Bereich,2) - nully;
      mx1 := mx0 * cos(Winkel) + my0 * sin(Winkel);
      my1 := mx0 * (-sin(Winkel)) + my0 * cos(Winkel);
      mx2 := Get_B_Koord_x(Aktiver_Bereich,3) - nullx;
      my2 := Get_B_Koord_y(Aktiver_Bereich,3) - nully;
      mx3 := mx2 * cos(Winkel) + my2 * sin(Winkel);
      my3 := mx2 * (-sin(Winkel)) + my2 * cos(Winkel);
      mx4 := Get_B_Koord_x(Aktiver_Bereich,1) - nullx;
      my4 := Get_B_Koord_y(Aktiver_Bereich,1) - nully;
      mx5 := mx4 * cos(Winkel) + my4 * sin(Winkel);
      my5 := mx4 * (-sin(Winkel)) + my4 * cos(Winkel);
      d1x := mx1 - mx3;
      d1y := my1 - my5;
      d2x := (mx0+dx1) * cos(Winkel) + (my0-dy1) * sin(Winkel) - mx3;
      d2y := (my0-dy1) * cos(Winkel) - (mx0+dx1) * sin(Winkel) - my5;
      if d1x = 0 then skal := 1 else
        skal := d2x / d1x;
      if d1y = 0 then skal1 := 1 else
        skal1 := d2y / d1y;
      a11 := (a * cos(Winkel) + c * sin(Winkel)) * skal;
      a21 := (b * cos(Winkel) + d * sin(Winkel)) * skal1;
      a12 := (a * (-sin(Winkel)) + c * cos(Winkel)) * skal;
      a22 := (b * (-sin(Winkel)) + d * cos(Winkel)) * skal1;
      a := a11 * cos(Winkel) + a12 * (-sin(Winkel));
      b := a21 * cos(Winkel) + a22 * (-sin(Winkel));
      c := a11 * sin(Winkel) + a12 * cos(Winkel);
      d := a21 * sin(Winkel) + a22 * cos(Winkel);
      end;
    recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
    Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],bewegt,fix);
    mx := GraphWin_x+round(Get_B_Koord_x(Aktiver_Bereich,2)) - scroll_x;
    my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2)) + scroll_y;
    MouseHer;
    Umrahmung;
    end;
until ButtonPressed;
Entprellen;
MouseWeg;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
if RightButton then begin
  ArbeitsBereich^.Form := Old_B;
  Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
  recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  end
else begin
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  Loeschbereich := ArbeitsBereich^;
  Loeschbereich.Form := Old_B;
  LoeschFktBnr := Aktiver_Bereich;
  Lastop := 13;
  end;
if Old_Visi_F then
  Visible[Aktiver_Bereich].Funktion := True;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;   {Bereich dehnen}

procedure Funktion_Dehnen;
var save_mouse : Punkttyp;
    i          : Byte;
    dx, dy     : integer;
    dx1 ,dy1   : double;
    nullx,nully, d1x, d1y,
    d2x, d2y, d3x, d3y,
    B_Winkel, F_Winkel,
    skal, skal1,
    mx0, my0, mx1, my1,
    mx2, my2, mx3, my3,
    mx4, my4, mx5, my5,
    mx6, my6, mx7, my7,
    a11, a12, a21, a22 : double;
    Old_F  : Funktionstyp;
    Old_LF : Lineare_Funktion;
    Old_NF : nonlin_Funktion;
begin
if (Aktiver_Bereich < 1) or (Aktive_Fkt[Aktiver_Bereich] < 1) then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
with ArbeitsBereich^ do begin
  Old_F := Funktion[Aktive_Fkt[Aktiver_Bereich]]^;
  if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin 
    Old_LF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^;
    nullx := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    mx := GraphWin_x - scroll_x +
          round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
    my := y-Lineal_b + scroll_y -
          round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
    end
  else begin
    Old_NF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^;
    nullx := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    mx := GraphWin_x - scroll_x +
          round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
    my := y-Lineal_b + scroll_y -
          round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
    end;
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,bewegt);
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
MouseHer;
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    dx1 := dx / Skalierung;
    dy1 := dy / Skalierung;
    MouseWeg;
    Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^ do begin
      B_Winkel := Form.Winkel;
      with Funktion[Aktive_Fkt[Aktiver_Bereich]]^ do
        F_Winkel := Winkel;
      if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
        with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ do begin
          mx0 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2) - nullx;
          my0 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2) - nully;
          mx2 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nullx;
          my2 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nully;
          mx4 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],1) - nullx;
          my4 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],1) - nully;
          end;
        end
      else begin
        mx0 := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15) - nullx;
        my0 := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15) - nully;
        mx2 := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],12) - nullx;
        my2 := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],12) - nully;
        mx4 := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nullx;
        my4 := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3) - nully;
        end;
      mx1 := mx0 * cos(F_Winkel) + my0 * sin(F_Winkel);
      my1 := mx0 * (-sin(F_Winkel)) + my0 * cos(F_Winkel);
      mx3 := mx2 * cos(F_Winkel) + my2 * sin(F_Winkel);
      my3 := mx2 * (-sin(F_Winkel)) + my2 * cos(F_Winkel);
      mx5 := mx4 * cos(F_Winkel) + my4 * sin(F_Winkel);
      my5 := mx4 * (-sin(F_Winkel)) + my4 * cos(F_Winkel);
      mx6 := mx0 + dx1;
      my6 := my0 - dy1;
      mx7 := (mx6) * cos(F_Winkel) + my6 * sin(F_Winkel);
      my7 := (mx6) * (-sin(F_Winkel)) + my6 * cos(F_Winkel);
      mx0 := mx1 * cos(B_Winkel) + my1 * sin(B_Winkel);
      my0 := mx1 * (-sin(B_Winkel)) + my1 * cos(B_Winkel);
      mx2 := mx3 * cos(B_Winkel) + my3 * sin(B_Winkel);
      my2 := mx3 * (-sin(B_Winkel)) + my3 * cos(B_Winkel);
      mx4 := mx5 * cos(B_Winkel) + my5 * sin(B_Winkel);
      my4 := mx5 * (-sin(B_Winkel)) + my5 * cos(B_Winkel);
      mx6 := mx7 * cos(B_Winkel) + my7 * sin(B_Winkel);
      my6 := mx7 * (-sin(B_Winkel)) + my7 * cos(B_Winkel);
      d1x := mx0 - mx2;
      d1y := my0 - my4;
      d2x := mx6 - mx2;
      d2y := my6 - my4;
      if d1x = 0 then skal := 1 else
        skal := d2x / d1x;
      if d1y = 0 then skal1 := 1 else
        skal1 := d2y / d1y;
      if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
        with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ do begin
          a11 := (a * cos(F_Winkel) + c * sin(F_Winkel))*skal;
          a21 := (b * cos(F_Winkel) + d * sin(F_Winkel))*skal1;
          a12 := (a * (-sin(F_Winkel)) + c * cos(F_Winkel))*skal;
          a22 := (b * (-sin(F_Winkel)) + d * cos(F_Winkel))*skal1;
          a := a11 * cos(F_Winkel) + a12 * (-sin(F_Winkel));
          b := a21 * cos(F_Winkel) + a22 * (-sin(F_Winkel));
          c := a11 * sin(F_Winkel) + a12 * cos(F_Winkel);
          d := a21 * sin(F_Winkel) + a22 * cos(F_Winkel);
          end;
        recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        my := y-Lineal_b + scroll_y -
              round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        end
      else begin
        with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ do begin
          a21 := (Punkt[0].x*cos(F_Winkel) + Punkt[0].y*sin(F_Winkel));
          a22 := (Punkt[0].x*(-sin(F_Winkel)) + Punkt[0].y*cos(F_Winkel));
          for i := 0 to 15 do begin
            a11 := Punkt[i].x*cos(F_Winkel) + Punkt[i].y*sin(F_Winkel);
            a12 := Punkt[i].x*(-sin(F_Winkel)) + Punkt[i].y*cos(F_Winkel);
            a11 := (a11 - a21) * skal + a21;
            a12 := (a12 - a22) * skal1 + a22;
            Punkt[i].x := a11*cos(F_Winkel) + a12*(-sin(F_Winkel));
            Punkt[i].y := a11*sin(F_Winkel) + a12*cos(F_Winkel);
            end;
          end;
        recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                       Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
        my := y-Lineal_b + scroll_y -
              round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
        end;
      MouseHer;
      Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,bewegt);
      if Funktionsanzeige then
        Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                          aktiv,NumWin_y1)
      else begin
        i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
        Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
        end;
      Umrahmung;
      end;
    end;
until ButtonPressed;
MouseWeg;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
if RightButton then begin
  with ArbeitsBereich^do begin
    Funktion[Aktive_Fkt[Aktiver_Bereich]]^ := Old_F;
    if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ := Old_LF;
      recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                    Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
      end
    else begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ := Old_NF;
      recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                     Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
      end;
    end;
  end
else begin
  with ArbeitsBereich^ do
    for i := 1 to Anzahl_Fkt do
      Funktion[i]^.Wahrscheinlichkeit := GetWahrscheinlichkeit(Funktion[i]^);
  LoeschFktBnr := Aktiver_Bereich;
  LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
  LoeschFkt := Old_F;
  if ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then
    LoeschLFkt := Old_LF
  else
    LoeschNFkt := Old_NF;
  LoeschRest := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.
                Restriction^;
  Lastop := 3;
  end;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
if Funktionsanzeige then
  Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
else begin
  i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
  Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
  end;
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;   {Funktion dehnen}

procedure Bereich_Drehen;
var save_mouse : Punkttyp;
    dx, dy : integer;
    dx1 ,dy1 : double;
    nullx,nully, mx0, my0,
    a11, a12, a21, a22,
    Alpha, Alpha1, AlphaDreh : double;
    p0,p1,pm : RPunkttyp;
    Old_B : B_Koordinaten;
    Old_Visi_F : Boolean;
begin
if Aktiver_Bereich < 1 then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
Old_B := ArbeitsBereich^.Form;
if Visible[Aktiver_Bereich].Funktion then begin
  Funktion_ausblenden(Aktiver_Bereich);
  Visible[Aktiver_Bereich].Funktion := False;
  Old_Visi_F := True;
  end
else
  Old_Visi_F := False;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,fix);
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
nullx := Get_B_Koord_x(Aktiver_Bereich,0);
nully := Get_B_Koord_y(Aktiver_Bereich,0);
mx := GraphWin_x+round(Get_B_Koord_x(Aktiver_Bereich,2)) - scroll_x;
my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2)) + scroll_y;
ReadMouseMotion(dx,dy);                 {vorangegangene Bewegung verwerfen}
MouseHer;
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    dx1 := dx / Skalierung;
    dy1 := dy / Skalierung;
    MouseWeg;
    Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^.Form do begin
      mx0 := Get_B_Koord_x(Aktiver_Bereich,1);
      my0 := Get_B_Koord_y(Aktiver_Bereich,1);
      p0.x := Get_B_Koord_x(Aktiver_Bereich,0);
      p0.y := Get_B_Koord_y(Aktiver_Bereich,0);
      p1.x := mx0;
      p1.y := my0;
      pm.x := mx0 + dx1;
      pm.y := my0 - dy1;
      Alpha := GetWinkel(p0.x,p0.y,p1.x,p1.y);
      Alpha1 := GetWinkel(p0.x,p0.y,pm.x,pm.y);
      AlphaDreh := Alpha1 - Alpha;
      a11 := a * cos(Winkel) + c * sin(Winkel);
      a21 := b * cos(Winkel) + d * sin(Winkel);
      a12 := a * (-sin(Winkel)) + c * cos(Winkel);
      a22 := b * (-sin(Winkel)) + d * cos(Winkel);
      Winkel :=  Winkel + AlphaDreh;
      a := a11 * cos(Winkel) + a12 * (-sin(Winkel));
      b := a21 * cos(Winkel) + a22 * (-sin(Winkel));
      c := a11 * sin(Winkel) + a12 * cos(Winkel);
      d := a21 * sin(Winkel) + a22 * cos(Winkel);
      end;
    recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
    Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],bewegt,fix);
    mx := GraphWin_x+round(Get_B_Koord_x(Aktiver_Bereich,2)) - scroll_x;
    my := y-Lineal_b-round(Get_B_Koord_y(Aktiver_Bereich,2)) + scroll_y;
    MouseHer;
    Umrahmung;
    end;
until ButtonPressed;
MouseWeg;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,bewegt);
if RightButton then begin
  ArbeitsBereich^.Form := Old_B;
  recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  end
else begin
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  Loeschbereich := ArbeitsBereich^;
  Loeschbereich.Form := Old_B;
  LoeschFktBnr := Aktiver_Bereich;
  Lastop := 13;
  end;
if Old_Visi_F then
  Visible[Aktiver_Bereich].Funktion := True;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;  {Bereich drehen}

procedure Funktion_Drehen;
var save_mouse : Punkttyp;
    dx, dy     : integer;
    dx1 ,dy1   : double;
    nullx,nully, mx0, my0,
    a11, a12, a21, a22,
    Alpha, Alpha1,
    AlphaDreh, F_Winkel : double;
    p0,p1,pm : RPunkttyp;
    Old_F    : Funktionstyp;
    Old_LF   : Lineare_Funktion;
    Old_NF   : nonlin_Funktion;
begin
if Aktiver_Bereich < 1 then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
with ArbeitsBereich^ do begin
  Old_F := Funktion[Aktive_Fkt[Aktiver_Bereich]]^;
  if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
    Old_LF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^;
    nullx := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    mx := GraphWin_x - scroll_x +
          round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
    my := y-Lineal_b + scroll_y -
          round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
    end
  else begin
    Old_NF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^;
    nullx := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    mx := GraphWin_x - scroll_x +
          round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
    my := y-Lineal_b + scroll_y -
          round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
    end;
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,bewegt);
ReadMouseMotion(dx,dy);                 {vorangegangene Bewegung verwerfen}
MouseHer;
EntPrellen;
repeat
  ReadMouseMotion(dx,dy);
  if (Abs(dx) > 0) or (Abs(dy) > 0) then begin
    dx1 := dx / Skalierung;
    dy1 := dy / Skalierung;
    MouseWeg;
    Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
    with ArbeitsBereich^ do begin
      F_Winkel := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Winkel;
      if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
        mx0 := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],1);
        my0 := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],1);
        p0.x := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
        p0.y := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
        end
      else begin
        mx0 := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3);
        my0 := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],3);
        p0.x := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
        p0.y := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
        end;
      p1.x := mx0;
      p1.y := my0;
      with Form do begin
        pm.x := mx0 + dx1*sign(a*d);
        pm.y := my0 - dy1*sign(a*d);
        end;
      Alpha := GetWinkel(p0.x,p0.y,p1.x,p1.y);
      Alpha1 := GetWinkel(p0.x,p0.y,pm.x,pm.y);
      AlphaDreh := Alpha1 - Alpha;
      if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
        with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ do begin
          a11 := a * cos(F_Winkel) + c * sin(F_Winkel);
          a21 := b * cos(F_Winkel) + d * sin(F_Winkel);
          a12 := a * (-sin(F_Winkel)) + c * cos(F_Winkel);
          a22 := b * (-sin(F_Winkel)) + d * cos(F_Winkel);
          F_Winkel :=  F_Winkel + AlphaDreh;
          a := a11 * cos(F_Winkel) + a12 * (-sin(F_Winkel));
          b := a21 * cos(F_Winkel) + a22 * (-sin(F_Winkel));
          c := a11 * sin(F_Winkel) + a12 * cos(F_Winkel);
          d := a21 * sin(F_Winkel) + a22 * cos(F_Winkel);
          end;
        recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                      Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        my := y-Lineal_b + scroll_y -
              round(Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],2));
        end
      else begin
        with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ do
          for i := 0 to 15 do begin
            a11 := (Punkt[i].x - Punkt[0].x) * cos(F_Winkel) +
                   (Punkt[i].y - Punkt[0].y) * sin(F_Winkel);
            a12 := (Punkt[i].x - Punkt[0].x) * (-sin(F_Winkel)) +
                   (Punkt[i].y - Punkt[0].y) * cos(F_Winkel);
            F_Winkel :=  F_Winkel + AlphaDreh;
            Punkt[i].x := a11*cos(F_Winkel) + a12*(-sin(F_Winkel)) + Punkt[0].x;
            Punkt[i].y := a11*sin(F_Winkel) + a12*cos(F_Winkel) + Punkt[0].y;
            end;
        recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                       Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
        mx := GraphWin_x - scroll_x +
              round(Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
        my := y-Lineal_b + scroll_y -
              round(Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],15));
        end;
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Winkel := F_Winkel;
      Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,bewegt);
      MouseHer;
      if Funktionsanzeige then
        Funktion_anzeigen(Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                          aktiv,NumWin_y1)
      else begin
        i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
        Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
        end;
      Umrahmung;
      end;
    end;
until ButtonPressed;
MouseWeg;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,bewegt);
if RightButton then begin
  with ArbeitsBereich^do begin
    Funktion[Aktive_Fkt[Aktiver_Bereich]]^ := Old_F;
    if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ := Old_LF;
      recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                    Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
      end
    else begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ := Old_NF;
      recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                     Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
      end;
    end;
  end
else begin
  with ArbeitsBereich^ do
    for i := 1 to Anzahl_Fkt do
      Funktion[i]^.Wahrscheinlichkeit := GetWahrscheinlichkeit(Funktion[i]^);
  LoeschFktBnr := Aktiver_Bereich;
  LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
  LoeschFkt := Old_F;
  if ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then
    LoeschLFkt := Old_LF
  else
    LoeschNFkt := Old_NF;
  LoeschRest := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.
                Restriction^;
  Lastop := 3;
  end;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
if Funktionsanzeige then
  Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                    aktiv,NumWin_y1)
else begin
  i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
  Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
  end;
EntPrellen;
mx := save_mouse.x;
my := save_mouse.y;
end;   {Funktion drehen}

procedure Bereich_Spiegeln;
var save_mouse,sp0,sp1,spold : Punkttyp;
    dx, dy : integer;
    i : Byte;
    nullx,nully, mx0, my0,
    a11, a12, a21, a22, a31, a32,
    b11, b12, b21, b22, b31, b32,
    Alpha, AlphaDreh : double;
    p0,p1,pm : RPunkttyp;
    Old_B : B_Koordinaten;
    Old_Poly : Polytyp;
begin
if Aktiver_Bereich < 1 then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
Old_B := ArbeitsBereich^.Form;
for i := 0 to 4 do begin
  Old_Poly[i].x := Get_B_Koord_x(Aktiver_Bereich,i);
  Old_Poly[i].y := Get_B_Koord_y(Aktiver_Bereich,i);
  end;
Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,fix);
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
nullx := Get_B_Koord_x(Aktiver_Bereich,0);
nully := Get_B_Koord_y(Aktiver_Bereich,0);
EntPrellen;
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
mx := GraphWin_x + round(nullx) - scroll_x;
my := Menue_y + round(ry(nully)) + scroll_y;
MouseHer;
SetMouseBereich(GraphWin_x,Menue_y,x-16,y-Lineal_b);
repeat
  Mouse_bewegen;
until ButtonPressed;
if RightButton then begin
  Entprellen;
  SetMouseBereich(0,0,x,y);
  MouseWeg;
  Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,fix);
  mx := save_mouse.x;
  my := save_mouse.y;
  Exit;
  end;
EntPrellen;
p0.x := wx(mx + scroll_x);
p0.y := wy(my - scroll_y);
sp0.x := mx;
sp0.y := my;
sp1 := sp0;
repeat
  spold := sp1;
  Mouse_bewegen;
  sp1.x := mx;
  sp1.y := my;
  if (sp1.x <> spold.x) or (sp1.y <> spold.y) then begin
    MouseWeg;
    SetWriteMode(1);
    Line(sp0.x,sp0.y,spold.x,spold.y);
    Line(sp0.x,sp0.y,sp1.x,sp1.y);
    MouseHer;
    SetWriteMode(0);
    end;
until ButtonPressed;
if RightButton then begin
  Entprellen;
  SetMouseBereich(0,0,x,y);
  MouseWeg;
  SetWriteMode(0);
  SetColor(0);
  Line(sp0.x,sp0.y,sp1.x,sp1.y);
  SetColor(F_Text);
  SetWriteMode(0);
  Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,fix);
  mx := save_mouse.x;
  my := save_mouse.y;
  Exit;
  end;
EntPrellen;
p1.x := wx(mx + scroll_x);
p1.y := wy(my - scroll_y);
MouseWeg;
if ArbeitsBereich^.Anzahl_Fkt > 0 then
  for i := 1 to ArbeitsBereich^.Anzahl_Fkt do
    Draw_Funktion(Aktiver_Bereich,i,unsichtbar,inaktiv,fix);
with ArbeitsBereich^.Form do begin
  Alpha := GetWinkel(p0.x,p0.y,p1.x,p1.y);
  if Alpha < 0 then Alpha := Alpha + 2 * Pi;
  b11 := cos(2*Alpha);
  b12 := sin(2*Alpha);
  b21 := sin(2*Alpha);
  b22 := -cos(2*Alpha);
  b31 := p0.x*(sqr(sin(Alpha))-sqr(cos(Alpha)))-2*p0.y*sin(Alpha)*cos(Alpha)+p0.x;
  b32 := p0.y*(sqr(cos(Alpha))-sqr(sin(Alpha)))-2*p0.x*sin(Alpha)*cos(Alpha)+p0.y;
  a11 := a;
  a12 := c;
  a21 := b;
  a22 := d;
  a31 := e;
  a32 := f;
  a := a11*b11 + a12*b21;
  b := a21*b11 + a22*b21;
  c := a11*b12 + a12*b22;
  d := a21*b12 + a22*b22;
  e := a31*b11 + a32*b21 + b31;
  f := a31*b12 + a32*b22 + b32;
  Winkel := 2 * Alpha - Winkel;
end;
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
  with ArbeitsBereich^ do
    if Anzahl_Fkt > 0 then
      for i := 1 to Anzahl_Fkt do
        if Funktion[i]^.Art then
          recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
        else
          recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,fix);
repeat until ButtonPressed;
if RightButton then begin
  Draw_Bereich(Aktiver_Bereich,unsichtbar,aktiv,fix);
  ArbeitsBereich^.Form := Old_B;
  recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
    with ArbeitsBereich^ do
      if Anzahl_Fkt > 0 then
        for i := 1 to Anzahl_Fkt do
          if Funktion[i]^.Art then
            recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
          else
            recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
  Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,bewegt);
  end
else begin
  Draw_Polygon(Old_Poly,unsichtbar,aktiv,bewegt);
  Loeschbereich := ArbeitsBereich^;
  Loeschbereich.Form := Old_B;
  LoeschFktBnr := Aktiver_Bereich;
  Lastop := 13;
  end;
SetColor(0);
Line(sp0.x,sp0.y,sp1.x,sp1.y);
Umrahmung;
Draw_Bereich(Aktiver_Bereich,sichtbar,aktiv,fix);
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
SetMouseBereich(0,0,x,y);
SetViewPort(0,0,x,y,True);
mx := save_mouse.x;
my := save_mouse.y;
end;   {Bereich spiegeln}

procedure Funktion_Spiegeln;
var save_mouse,sp0,sp1,spold : Punkttyp;
    dx, dy : integer;
    nullx,nully, mx0, my0, Ba, Bd,
    a11, a12, a21, a22, a31, a32,
    b11, b12, b21, b22, b31, b32,
    Alpha, B_Alpha, Alpha2, B_Alpha2 : double;
    p0,p1,pm,bp : RPunkttyp;
    Old_F       : Funktionstyp;
    Old_LF      : Lineare_Funktion;
    Old_NF      : nonlin_Funktion;
    Old_Poly    : Polytyp;
    Old_NPoly   : NPolytyp;
begin
if Aktiver_Bereich < 1 then
  Exit;
if Aktive_Fkt[Aktiver_Bereich] < 1 then
  Exit;
save_mouse.x := mx;
save_mouse.y := my;
SetMouseBereich(GraphWin_x,Menue_y,x-16,y-Lineal_b);
with ArbeitsBereich^ do begin
  Old_F := Funktion[Aktive_Fkt[Aktiver_Bereich]]^;
  if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
    Old_LF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^;
    nullx := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    for i := 0 to 4 do begin
      Old_Poly[i].x := Get_F_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],i);
      Old_Poly[i].y := Get_F_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],i);
      end;
    end
  else begin
    Old_NF := Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^;
    nullx := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    nully := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],0);
    for i := 0 to 15 do begin
      Old_NPoly[i].x := Get_NF_Koord_x(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],i);
      Old_NPoly[i].y := Get_NF_Koord_y(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],i);
      end;
    end;
  with Form do begin
    B_Alpha := Winkel;
    Ba := a * cos(Winkel) + c * sin(Winkel);
    Bd := b * (-sin(Winkel)) + d * cos(Winkel);
    end;
  end;
bp.x := Get_B_Koord_x(Aktiver_Bereich,0) / (x-GraphWin_x);
bp.y := Get_B_Koord_y(Aktiver_Bereich,0) / (y-Menue_y-Lineal_b);
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,bewegt);
EntPrellen;
ReadMouseMotion(dx,dy);         {vorangegangene Bewegung verwerfen}
mx := GraphWin_x + round(nullx) - scroll_x;
my := Menue_y + round(ry(nully)) + scroll_y;
MouseHer;
repeat
  Mouse_bewegen;
until ButtonPressed;
if RightButton then begin
  Entprellen;
  SetMouseBereich(0,0,x,y);
  MouseWeg;
  Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
  mx := save_mouse.x;
  my := save_mouse.y;
  Exit;
  end;
EntPrellen;
p0.x := (wx(mx + scroll_x)-bp.x)/Ba;
p0.y := (wy(my - scroll_y)-bp.y)/Bd;
sp0.x := mx;
sp0.y := my;
sp1 := sp0;
repeat
  spold := sp1;
  Mouse_bewegen;
  sp1.x := mx;
  sp1.y := my;
  if (sp1.x <> spold.x) or (sp1.y <> spold.y) then begin
    MouseWeg;
    SetWriteMode(1);
    SetColor(F_Text);
    Line(sp0.x,sp0.y,spold.x,spold.y);
    Line(sp0.x,sp0.y,sp1.x,sp1.y);
    SetWriteMode(0);
    MouseHer;
    end;
until ButtonPressed;
if RightButton then begin
  Entprellen;
  SetMouseBereich(0,0,x,y);
  MouseWeg;
  SetColor(0);
  Line(sp0.x,sp0.y,sp1.x,sp1.y);
  Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
  mx := save_mouse.x;
  my := save_mouse.y;
  Exit;
  end;
EntPrellen;
p1.x := (wx(mx + scroll_x)-bp.x)/Ba;
p1.y := (wy(my - scroll_y)-bp.y)/Bd;
MouseWeg;
Alpha := GetWinkel(p0.x,p0.y,p1.x,p1.y);      { Winkel der Spiegelachse }
if Alpha < 0 then Alpha := Alpha + 2 * Pi;
Alpha := Alpha - B_Alpha;
Alpha2 := 2 * Alpha;
B_Alpha2 := 2 * B_Alpha;
b11 := cos(2*Alpha);
b12 := sin(2*Alpha);
b21 := sin(2*Alpha);
b22 := -cos(2*Alpha);
b31 := p0.x*(sqr(sin(Alpha))-sqr(cos(Alpha)))-2*p0.y*sin(Alpha)*cos(Alpha)+p0.x;
b32 := p0.y*(sqr(cos(Alpha))-sqr(sin(Alpha)))-2*p0.x*sin(Alpha)*cos(Alpha)+p0.y;
with ArbeitsBereich^ do begin
  if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
    with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ do begin
      a11 := a;
      a12 := c;
      a21 := b;
      a22 := d;
      a31 := e;
      a32 := f;
      a := a11*b11 + a12*b21;
      b := a21*b11 + a22*b21;
      c := a11*b12 + a12*b22;
      d := a21*b12 + a22*b22;
      e := a31*b11 + a32*b21 + b31;
      f := a31*b12 + a32*b22 + b32;
      recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                    Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
      end;
    end
  else begin
    with Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ do begin
      for i := 0 to 15 do begin
        a11 := (Punkt[i].x - p0.x) * cos(Alpha) +
               (Punkt[i].y - p0.y) * sin(Alpha);
        a12 := - (Punkt[i].x - p0.x) * (-sin(Alpha)) -
               (Punkt[i].y - p0.y) * cos(Alpha);
        Punkt[i].x := a11*cos(Alpha) + a12*(-sin(Alpha)) + p0.x;
        Punkt[i].y := a11*sin(Alpha) + a12*cos(Alpha) + p0.y;
        end;
      recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],
                     Form,Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
      end;
    end;
  end;
Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
repeat until ButtonPressed;
if RightButton then begin
  Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
  with ArbeitsBereich^ do begin
    Funktion[Aktive_Fkt[Aktiver_Bereich]]^ := Old_F;
    if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^ := Old_LF;
      recalc_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                    Funktion[Aktive_Fkt[Aktiver_Bereich]]^.LFunk^);
      end
    else begin
      Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^ := Old_NF;
      recalc_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],Form,
                     Funktion[Aktive_Fkt[Aktiver_Bereich]]^.NFunk^);
      end;
    end;
  Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],sichtbar,aktiv,fix);
  end
else begin
  with ArbeitsBereich^ do begin
    with Funktion[Aktive_Fkt[Aktiver_Bereich]]^ do
      Winkel := 2 * Alpha - Winkel;
    LoeschFktBnr := Aktiver_Bereich;
    LoeschFktNr := Aktive_Fkt[Aktiver_Bereich];
    LoeschFkt := Old_F;
    if Funktion[Aktive_Fkt[Aktiver_Bereich]]^.Art then begin
      LoeschLFkt := Old_LF;
      Draw_Polygon(Old_Poly,unsichtbar,aktiv,bewegt);
      end
    else begin
      LoeschNFkt := Old_NF;
      Draw_NPolygon(Old_NPoly,unsichtbar,aktiv,bewegt);
      end;
    end;
  LoeschRest := ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.
                Restriction^;
  Lastop := 3;
  end;
SetColor(0);
Line(sp0.x,sp0.y,sp1.x,sp1.y);
Umrahmung;
if Funktionsanzeige then
  Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,
                    aktiv,NumWin_y1)
  else begin
    i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
    Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
    end;
Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
EntPrellen;
SetMouseBereich(0,0,x,y);
SetViewPort(0,0,x,y,True);
mx := save_mouse.x;
my := save_mouse.y;
end;   {Funktion spiegeln}

procedure Undo;
var Fkt,Ber,i,j : Byte;
    Fkt_old : Funktionstyp;
    LFkt_old : Lineare_Funktion;
    NFkt_old : NonLin_Funktion;
    Rest_old : LRTable;
    Ber_old : Single_IFS;
begin
case Lastop of
  0 : Exit;
  1 : begin                               { angefgte Fkt wieder entfernen }
      Ber := Aktiver_Bereich;
      Fkt := Aktive_Fkt[Ber];
      if Ber <> LoeschFktBnr then begin       { Bereich wieder zurckholen } 
        Bereich_auslagern(Aktiver_Bereich,XmsListe);
        Aktiver_Bereich := LoeschFktBnr;
        Bereich_einlagern(Aktiver_Bereich,XmsListe);
        BereichsFeld;
        with ArbeitsBereich^ do
          Bereich_anzeigen(Bereichsnummer,name);
        end;
      Draw_Funktion(LoeschFktBnr,LoeschFktNr,unsichtbar,aktiv,fix);
      Draw_Bereich(LoeschFktBnr,sichtbar,aktiv,fix);
      with ArbeitsBereich^ do begin
        LoeschFkt := Funktion[LoeschFktNr]^;
        LoeschLFkt := Funktion[LoeschFktNr]^.LFunk^;
        if not LoeschFkt.Art then
          LoeschNFkt := Funktion[LoeschFktNr]^.NFunk^;
        LoeschRest := Funktion[LoeschFktNr]^.Restriction^;
        FreeMem(Funktion[LoeschFktNr]^.LFunk,LF_size);
        if Funktion[LoeschFktNr]^.NFunk <> nil then
          FreeMem(Funktion[LoeschFktNr]^.NFunk,NF_size);
        FreeMem(Funktion[LoeschFktNr]^.Restriction,LR_size);
        FreeMem(Funktion[LoeschFktNr],F_size);
        end;
      ArbeitsBereich^.Funktion[LoeschFktNr] := nil;   { mu die letzte sein}
      remove_F_Poly(LoeschFktBnr,LoeschFktNr);
      Aktive_Fkt[Aktiver_Bereich] := Pred(LoeschFktNr);
      Dec(ArbeitsBereich^.Anzahl_Fkt);
      Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
      if Funktionsanzeige then
        Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
      else
        MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
      Lastop := 101;
      end;
  2 : begin                               { gelschte Fkt wiederherstellen }
      Ber := Aktiver_Bereich;
      Fkt := Aktive_Fkt[Ber];
      if Ber <> LoeschFktBnr then begin         { Bereich wieder reinholen }
        Bereich_auslagern(Aktiver_Bereich,XmsListe);
        Aktiver_Bereich := LoeschFktBnr;
        Bereich_einlagern(Aktiver_Bereich,XmsListe);
        BereichsFeld;
        with ArbeitsBereich^ do
          Bereich_anzeigen(Bereichsnummer,name);
        end;
      Aktive_Fkt[Aktiver_Bereich] := LoeschFktNr;
      with ArbeitsBereich^ do begin
        Inc(Anzahl_Fkt);
        for i := Anzahl_Fkt downto Succ(LoeschFktNr) do begin
          Funktion[i] := Funktion[Pred(i)];
          Funktion[i]^.nummer := Succ(Funktion[i]^.nummer);
          end;
        GetMem(Funktion[LoeschFktNr],F_size);
        Funktion[LoeschFktNr]^ := LoeschFkt;
        if LoeschFkt.Art then begin
          GetMem(Funktion[LoeschFktNr]^.LFunk,LF_size);
          Funktion[LoeschFktNr]^.LFunk^ := LoeschLFkt;
          insert_F_Poly(LoeschFktBnr,LoeschFktNr);
          recalc_F_Poly(LoeschFktBnr,LoeschFktNr,Form,
                        Funktion[LoeschFktNr]^.LFunk^);
          end
        else begin
          GetMem(Funktion[LoeschFktNr]^.NFunk,NF_size);
          Funktion[LoeschFktNr]^.NFunk^ := LoeschNFkt;
          insert_NF_Poly(LoeschFktBnr,LoeschFktNr);
          recalc_NF_Poly(LoeschFktBnr,LoeschFktNr,Form,
                         Funktion[LoeschFktNr]^.NFunk^);
          end;
        GetMem(Funktion[LoeschFktNr]^.Restriction,LR_size);
        Funktion[LoeschFktNr]^.Restriction^ := LoeschRest;
        for i := 1 to Anzahl_Fkt do
          Funktion[i]^.Wahrscheinlichkeit := GetWahrscheinlichkeit(Funktion[i]^);
        end;
      if Funktionsanzeige then
        Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
      else
        MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
      Refresh(LoeschFktBnr,LoeschFktNr,fix,fix);
      LoeschFktBnr := Ber;
      LoeschFktNr := Fkt;
      Lastop := 102;
      end;
  3 : begin                            { nderung an Fkt rckgngig machen }
      Ber := Aktiver_Bereich;
      Fkt := Aktive_Fkt[Aktiver_Bereich];
      if Aktiver_Bereich <> LoeschFktBnr then begin
        Bereich_auslagern(Aktiver_Bereich,XmsListe);
        Aktiver_Bereich := LoeschFktBnr;
        Bereich_einlagern(Aktiver_Bereich,XmsListe);
        BereichsFeld;
        with ArbeitsBereich^ do
          Bereich_anzeigen(Bereichsnummer,name);
        end;
      Aktive_Fkt[Aktiver_Bereich] := LoeschFktNr;
      with ArbeitsBereich^ do begin
        if Funktion[LoeschFktNr]^.Art then
          LFkt_old := Funktion[LoeschFktNr]^.LFunk^
        else
          NFkt_old := ArbeitsBereich^.Funktion[LoeschFktNr]^.NFunk^;
        Rest_old := Funktion[LoeschFktNr]^.Restriction^;
        Fkt_old := Funktion[LoeschFktNr]^;
        Funktion[LoeschFktNr]^ := LoeschFkt;
        Draw_Funktion(LoeschFktBnr,LoeschFktNr,unsichtbar,aktiv,fix);
        if LoeschFkt.Art then begin
          Funktion[LoeschFktNr]^.LFunk^ := LoeschLFkt;
          recalc_F_Poly(LoeschFktBnr,LoeschFktNr,ArbeitsBereich^.Form,
                        ArbeitsBereich^.Funktion[LoeschFktNr]^.LFunk^);
          end
        else begin
          Funktion[LoeschFktNr]^.NFunk^ := LoeschNFkt;
          recalc_NF_Poly(LoeschFktBnr,LoeschFktNr,ArbeitsBereich^.Form,
                         ArbeitsBereich^.Funktion[LoeschFktNr]^.NFunk^);
          end;
        Funktion[LoeschFktNr]^.Restriction^ := LoeschRest;
        end;
      Draw_Funktion(LoeschFktBnr,LoeschFktNr,sichtbar,aktiv,fix);
      Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
      LoeschFkt := Fkt_old;
      LoeschLFkt := LFkt_old;
      LoeschNFkt := NFkt_old;
      LoeschRest := Rest_old;
      with ArbeitsBereich^ do
        for i := 1 to Anzahl_Fkt do
          Funktion[i]^.Wahrscheinlichkeit := GetWahrscheinlichkeit(Funktion[i]^);
      if Funktionsanzeige then
        Alle_Fkt_anzeigen(ArbeitsBereich^,LoeschFktNr)
      else begin
        i := Pred(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^.nummer) * NumText_abstand;
        Funktion_anzeigen(ArbeitsBereich^.Funktion[Aktive_Fkt[Aktiver_Bereich]]^,True,NumWin_y2-70-i);
        end;
      Lastop := 103;
      end;
  4 : begin
      Ber := Aktiver_Bereich;
      Fkt := Aktive_Fkt[Aktiver_Bereich];
      if Aktiver_Bereich <> LoeschFktBnr then begin
        Bereich_auslagern(Aktiver_Bereich,XmsListe);
        Aktiver_Bereich := LoeschFktBnr;
        Bereich_einlagern(Aktiver_Bereich,XmsListe);
        BereichsFeld;
        with ArbeitsBereich^ do
          Bereich_anzeigen(Bereichsnummer,name);
        end;
      Aktive_Fkt[Aktiver_Bereich] := LoeschFktNr;
      Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
      remove_NF_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich]);
      insert_F_Poly(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich]);
      with ArbeitsBereich^.Funktion[LoeschFktNr]^ do begin
        Art := TRUE;
        FreeMem(NFunk,NF_size);
        GetMem(LFunk,LF_size);
        LFunk^ := LoeschLFkt;
        end;
      with ArbeitsBereich^ do begin
        recalc_F_Poly(LoeschFktBnr,LoeschFktNr,
                      Form,Funktion[LoeschFktNr]^.LFunk^);
        if Funktionsanzeige then
          Funktion_anzeigen(Funktion[LoeschFktNr]^,aktiv,NumWin_y1)
        else begin
          i := Pred(Funktion[LoeschFktNr]^.nummer) * NumText_abstand;
          Funktion_anzeigen(Funktion[LoeschFktNr]^,True,NumWin_y2-70-i);
          end;
        end;
      Draw_Funktion(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],unsichtbar,aktiv,fix);
      Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
      Lastop := 104;
      end;
  11 : begin                    { ein-/angefgten Bereich wieder entfernen}
       i := 0;                                     { Bereich in Lschliste }
       repeat                                      { eintragen             }
         Inc(i);
       until (LoeschBereichListe[i] = ' ') or
       (LoeschBereichListe[i] > ArbeitsBereich^.Bereichsnummer);
       for j := Max_Bereiche downto Succ(i) do
         LoeschBereichListe[j] := LoeschBereichListe[Pred(j)];
       LoeschBereichListe[i] := ArbeitsBereich^.Bereichsnummer;

       Bereich_auslagern(LoeschFktBnr,Loeschen);
       XmsFreeMem(XmsBereich[LoeschFktBnr]);
       if LoeschFktBnr < Anzahl_Bereiche then begin
         for i := LoeschFktBnr to Pred(Anzahl_Bereiche) do begin
           XmsBereich[i] := XmsBereich[Succ(i)];
           Aktive_Fkt[i] := Aktive_Fkt[Succ(i)];
           end;
         end;
       if LoeschFktBnr = Anzahl_Bereiche then
         Aktiver_Bereich := Pred(LoeschFktBnr);
       if Aktiver_Bereich > 0 then
         Bereich_einlagern(Aktiver_Bereich,XmsListe);
       XmsBereich[Anzahl_Bereiche] := 0;
       Draw_Bereich(LoeschFktBnr,unsichtbar,inaktiv,fix);
       remove_B_Poly(LoeschFktBnr);
       Dec(Anzahl_Bereiche);
       if Aktiver_Bereich > 0 then begin
         Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
         Bereichsfeld;
         with ArbeitsBereich^ do
           Bereich_anzeigen(Bereichsnummer,name);
         if Funktionsanzeige then
           Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
         else
           MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
         end
       else begin
         Bereichsfeld;
         Bereich_anzeigen('*','Kein IFS');
         end;
       Lastop := 111;
       end;
  12 : begin                        { gelschten Bereich wiederherstellen }
       Inc(Anzahl_Bereiche);
       if Aktiver_Bereich > 0 then
         Bereich_auslagern(Aktiver_Bereich,XmsListe);
       for i := Pred(Anzahl_Bereiche) downto LoeschFktBnr do begin
         XmsBereich[Succ(i)] := XmsBereich[i];          {Platz frei machen}
         Aktive_Fkt[Succ(i)] := Aktive_Fkt[i];
         end;
       XmsBereich[LoeschFktBnr] := XmsGetMem(XmsBereichsize);
       XmsCopy(LoeschXmsBereich,0,XmsBereich[LoeschFktBnr],0,XmsBereichsize div 2);
       Bereich_einlagern(LoeschFktBnr,Loeschen);
       Aktiver_Bereich := LoeschFktBnr;
       Aktive_Fkt[Aktiver_Bereich] := LoeschFktNr;

       i := 0;
       repeat
         Inc(i);
       until LoeschBereichListe[i] = Loeschbereich.Bereichsnummer;
       for j := i to Pred(Max_Bereiche) do
         LoeschBereichListe[j] := LoeschBereichListe[Succ(j)];
       LoeschBereichListe[Max_Bereiche] := ' ';

       insert_B_Poly(LoeschFktBnr);
       restore_Visi(LoeschFktBnr);
       recalc_B_Poly(LoeschFktBnr,ArbeitsBereich^);
       with ArbeitsBereich^ do
         for i := 1 to Anzahl_Fkt do begin
           if Funktion[i]^.Art then begin
             insert_F_Poly(LoeschFktBnr,i);
             recalc_F_Poly(LoeschFktBnr,i,Form,Funktion[i]^.LFunk^);
             end
           else begin
             insert_NF_Poly(LoeschFktBnr,i);
             recalc_NF_Poly(LoeschFktBnr,i,Form,Funktion[i]^.NFunk^);
             end;
           end;
       Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
       Bereichsfeld;
       with ArbeitsBereich^ do
         Bereich_anzeigen(Bereichsnummer,name);
       Fkt_Fenster;
       if Funktionsanzeige then
         Alle_Fkt_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich])
       else
         MRFS_anzeigen(ArbeitsBereich^,Aktive_Fkt[Aktiver_Bereich]);
       end;
  13 : begin
       Ber := Aktiver_Bereich;
       Aktiver_Bereich := LoeschFktBnr;
       Ber_old := ArbeitsBereich^;
       ArbeitsBereich^ := Loeschbereich;
       Draw_Bereich(LoeschFktBnr,unsichtbar,aktiv,fix);
       recalc_B_Poly(Aktiver_Bereich,ArbeitsBereich^);
       if Loeschbereich.Anzahl_Fkt > 0 then
         with ArbeitsBereich^ do
           for i := 1 to Anzahl_Fkt do begin
             Draw_Funktion(Aktiver_Bereich,i,unsichtbar,i = Aktive_Fkt[Aktiver_Bereich],fix);
             if Funktion[i]^.Art then
               recalc_F_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.LFunk^)
             else
               recalc_NF_Poly(Aktiver_Bereich,i,Form,Funktion[i]^.NFunk^);
             Draw_Funktion(Aktiver_Bereich,i,sichtbar,i = Aktive_Fkt[Aktiver_Bereich],fix);
             end;
       Refresh(Aktiver_Bereich,Aktive_Fkt[Aktiver_Bereich],fix,fix);
       Loeschbereich := Ber_old;
       end;
  end;
end;

procedure DoIt(what: Byte);
begin
if (what > 11) and (what < 18) and not Visible[Aktiver_Bereich].Bereich then
  Exit;
if (what > 1) and (what < 8) then
  if not Visible[Aktiver_Bereich].Bereich or
     not Visible[Aktiver_Bereich].Funktion then
    Exit;
case what of
  0  : Neue_Funktion;
  1  : Funktion_Loeschen;
  2  : Funktion_Verschieben;
  3  : Funktion_Verzerren;
  4  : Funktion_Skalieren;
  5  : Funktion_Dehnen;
  6  : Funktion_Drehen;
  7  : Funktion_Spiegeln;
  8  : Undo;
  10 : Neuer_Bereich;
  11 : Bereich_Loeschen;
  12 : Bereich_Verschieben;
  13 : Bereich_Verzerren;
  14 : Bereich_Skalieren;
  15 : Bereich_Dehnen;
  16 : Bereich_Drehen;
  17 : Bereich_Spiegeln;
  18 : Undo;
  end;
end;

procedure Gib_mir_FSpeicher;
var i,j : Byte;
begin
{with Loeschbereich do
  if Anzahl_Fkt > 0 then
    for i := 1 to Anzahl_Fkt do begin
      if Funktion[i]^.Art then
        FreeMem(Funktion[i]^.LFunk,sizeof(Lineare_Funktion))
      else
        FreeMem(Funktion[i]^.NFunk,sizeof(nonlin_Funktion));
      if Funktion[i]^.Restriction <> nil then
        FreeMem(Funktion[i]^.Restriction,sizeof(LRTable));
      FreeMem(Funktion[i],sizeof(Funktionstyp));
      end;}
if Anzahl_Bereiche > 0 then begin
  with ArbeitsBereich^ do begin
    if Anzahl_Fkt > 0 then
      for j := 1 to Anzahl_Fkt do begin
        if Funktion[j]^.Art then                            {lineare Fkt}
          FreeMem(Funktion[j]^.LFunk,sizeof(Lineare_Funktion))
        else
          FreeMem(Funktion[j]^.NFunk,sizeof(nonlin_Funktion));
        FreeMem(Funktion[j]^.Restriction,sizeof(LRTable));
        FreeMem(Funktion[j],sizeof(Funktionstyp));
        end;
    FreeMem(ArbeitsBereich,sizeof(Single_IFS));
    end;
  for i := 1 to Anzahl_Bereiche do
    XmsFreeMem(XmsBereich[i]);
    end;
XmsFreeMem(LoeschXmsBereich);
end;

{----------------------------------------------------------------------------}
begin
Anzahl_Bereiche := 0;
Aktiver_Bereich := 0;
ArbeitsBereich := nil;
for i := 1 to 15 do begin
  LoeschBereichListe[i] := ' ';
  xmsBereich[i] := 0;
  Aktive_Fkt[i] := 0;
  end;
Loeschbereich.Anzahl_Fkt := 0;
Lastop := 0;
xmsBereichsize := (sizeof(Single_IFS) + 15 * sizeof(Funktionstyp) +
                  15 * sizeof(Lineare_Funktion) + 15 * sizeof(nonlin_Funktion) +
                  15 * sizeof(LRTable)) div 1024 + 1;
LoeschXmsBereich := XmsGetMem(xmsBereichsize);
if LoeschXmsBereich = 0 then
  Halt(1);
end.