#include "init.h"

const RGBBLOCKLENGTH = 512;
const LENGTHMIN1 = 511;

typedef unsigned char rgbsatz[512]; //RGBBLOCKLENGTH];
struct rgbdescr {
	 int writemode, singlemode;
	 int rgbposition;
	 long rgbcount;
	 unsigned char rold, gold, bold;
	 long rgbzeichen;
};

FILE *f;	// Filehandle global definieren


void rgbrewrite(unsigned char *s ,struct rgbdescr *d, int b, int h, double v)
{
	 int i,iv;

	 for (i=0;i<=LENGTHMIN1;i++)
	 s[i] = 0;
	 s[0] = b / 256; s[1] = b % 256;
	 s[2] = h / 256; s[3] = h % 256;
	 for (i=4;i<=7;i++) {
		  iv = (int)v;
		  s[i] = iv;
		  v = (v-iv)*256;
	 }
	 d->rgbzeichen = (long)(h+1)*(long)(b+1);
	 d->rgbposition = 8;
	 d->rgbcount = 0;
	 d->rold = 0; d->gold = 0; d->bold = 0;
	 d->singlemode = 0;
	 d->writemode = 1;
}

void byteschreiben(unsigned char *s, struct rgbdescr *d, unsigned char b) {
	 int i;
	 if (d->rgbposition==RGBBLOCKLENGTH) {
		  fwrite(s,1,LENGTHMIN1+1,f);
		  d->rgbposition = 0;
		  for (i=0;i<=LENGTHMIN1;i++)
				s[i] = 0;
	 }
	 s[d->rgbposition] = (char)b;
	 d->rgbposition = d->rgbposition+1;
}

void writecount(unsigned char *s, struct rgbdescr *d, long c)
{
	 long q256 = 65536L;
	 long k256 = 16777216L;

	 if (c>255) {
		  byteschreiben(s,d,0);
		  byteschreiben(s,d,c / k256);
		  byteschreiben(s,d,c / q256 % 256);
		  byteschreiben(s,d,c /  256 % 256);
	 }
	 byteschreiben(s,d,c % 256);
}

void writerun (unsigned char *s, struct rgbdescr *d) {
	 if (d->rgbcount>0) {
		  if (d->singlemode) {
				if (d->rgbcount>1) {
					 byteschreiben(s,d,1);
					 d->singlemode = 0;
					 writecount(s,d,d->rgbcount);
				}
				else
					 if (d->rold==1)
						  byteschreiben(s,d,1);
		  }
		  else {
				writecount(s,d,d->rgbcount);
				d->singlemode = (d->rgbcount==1);
		  }
		  byteschreiben(s,d,d->rold);
		  byteschreiben(s,d,d->gold);
		  byteschreiben(s,d,d->bold);
		  d->rgbzeichen = d->rgbzeichen-d->rgbcount;
	 }
}

void rgbwrite(unsigned char *s,struct rgbdescr *d, unsigned char r, unsigned char g, unsigned char b) {
	 if ((r==d->rold) && (g==d->gold) && (b==d->bold))
		  d->rgbcount = d->rgbcount+1;
	 else {
		  writerun(s,d);
		  d->rgbcount = 1;
		  d->rold = r; d->gold = g; d->bold = b;
	 }
}

void rgbclose (unsigned char *s, struct rgbdescr *d) {
	 if (d->writemode) {
		  if (d->rgbzeichen>d->rgbcount)
				d->rgbcount = d->rgbzeichen;
		  writerun(s,d);
		  fwrite(s,1,LENGTHMIN1+1,f);
	 }
	 fclose(f);
}

void SaveRGBScreen(box)
struct box *box;
{
	 int color[3];
	 unsigned char B[512];
	 struct rgbdescr B_descr;
	 int x, y;
	 int br = box->x2 - box->x1;
	 int ho = box->y2 - box->y1;
	 unsigned pixelcolor;

	 f = fopen(Datei.filename,"wb");
	 rgbrewrite(B,&B_descr,ho,br,1);          /* open output file */

	 for (y=0; y<=ho; y++)
		  for (x=0; x<=br; x++) {
				pixelcolor = getpixel(box->x1+x, box->y1+y);
				GimmeRGB(pixelcolor, color);
				rgbwrite(B,&B_descr, color[0], color[1], color[2]);
		  }
	 rgbclose(B,&B_descr);                    /* close output file */
}

void GimmeRGB(pixelcolor, color)
unsigned pixelcolor;
int *color;
{
	switch(pixelcolor) {
		case EGA_BLACK:  /* dark colors */
			color[0] = 0;
			color[1] = 0;
			color[2] = 0;
			break;
		case EGA_BLUE:
			color[0] = 0;
			color[1] = 0;
			color[2] = 128;
			break;
		case EGA_GREEN:
			color[0] = 0;
			color[1] = 128;
			color[2] = 0;
			break;
		case EGA_CYAN:
			color[0] = 0;
			color[1] = 128;
			color[2] = 128;
			break;
		case EGA_RED:
			color[0] = 128;
			color[1] = 0;
			color[2] = 0;
			break;
		case EGA_MAGENTA:
			color[0] = 128;
			color[1] = 0;
			color[2] = 128;
			break;
		case EGA_BROWN:
		case 6:
			color[0] = 128;
			color[1] = 64;
			color[2] = 0;
			break;
		case EGA_LIGHTGRAY:
			color[0] = 192;
			color[1] = 192;
			color[2] = 192;
			break;
		case EGA_DARKGRAY:       /* light colors */
		case 8:
			color[0] = 128;
			color[1] = 128;
			color[2] = 128;
			break;
		case EGA_LIGHTBLUE:
		case 9:
			color[0] = 0;
			color[1] = 0;
			color[2] = 255;
			break;
		case EGA_LIGHTGREEN:
		case 10:
			color[0] = 0;
			color[1] = 255;
			color[2] = 0;
			break;
		case EGA_LIGHTCYAN:
		case 11:
			color[0] = 0;
			color[1] = 255;
			color[2] = 255;
			break;
		case EGA_LIGHTRED:
		case 12:
			color[0] = 255;
			color[1] = 0;
			color[2] = 0;
			break;
		case EGA_LIGHTMAGENTA:
		case 13:
			color[0] = 255;
			color[1] = 0;
			color[2] = 255;
			break;
		case EGA_YELLOW:
		case 14:
			color[0] = 255;
			color[1] = 255;
			color[2] = 0;
			break;
		case EGA_WHITE:
		case 15:
			color[0] = 255;
			color[1] = 255;
			color[2] = 255;
			break;
		default:        		// Defaultfarbe ist schwarz
			color[0] = 0;
			color[1] = 0;
			color[2] = 0;
			break;
	}
}
