#include "init.h"

// gibt Zeile zurck
int max2(a,b)
double a;
double b;
{
  if (fabs(a)>fabs(b))
	 return(0);
  else
	 return(1);
}

// gibt Wert zurck
double max2d(a,b)
double a;
double b;
{
  if (fabs(a)>fabs(b))
	 return(a);
  else
	 return(b);
}

// gibt Zeile zurck
int max3(a,b,c)
double a;
double b;
double c;
{
  if (fabs(a)> fabs(max2d(b,c)))
	 return(0);
  else
	 return(max2(b,c)+1);
}


int Pivot(matrix,sp)
double matrix[][4];
double sp[];
{
  double dummy[4],pe;
  int i, pz;
  double eps = 0.0000000000000001;

/* lade erste Zeile in dummy Variable */
	for (i=0;i<4;i++)
	  dummy[i]=matrix[0][i];

/* suche Pivotzeile */
	pz=max3(matrix[0][0], matrix[1][0], matrix[2][0]);

/* vertausche Pivotzeile mit erster Zeile */
	for (i=0;i<4;i++)
	{
	  matrix[0][i]  = matrix[pz][i];
	  matrix[pz][i] = dummy[i];
	}

/* 2. Gleichung mit Pivotzeile multipl. */
	if (fabs(matrix[0][0]) < eps)
		return(FALSE);
	pe = -matrix[1][0] / matrix[0][0];
	for (i=0;i<4;i++)
	  matrix[1][i]=pe*matrix[0][i]+matrix[1][i];

/* 3. Gleichung mit Pivotzeile multipl. */
	pe = -matrix[2][0] / matrix[0][0];
	for (i=0;i<4;i++)
	  matrix[2][i]=pe*matrix[0][i]+matrix[2][i];

/* lade zweite Zeile in dummy Variable */
	for (i=0;i<4;i++)
	  dummy[i]=matrix[1][i];

/* suche Pivotzeile */
	pz=max2(matrix[1][1], matrix[2][1])+1;

/* vertausche Pivotzeile mit zweiter Zeile */
	for (i=0;i<4;i++)
	{
	  matrix[1][i]  = matrix[pz][i];
	  matrix[pz][i] = dummy[i];
	}

/* 3. Gleichung mit Pivotzeile multipl. */
	if (fabs(matrix[1][1]) < eps)
		return(FALSE);
	pe = -matrix[2][1] / matrix[1][1];
	for (i=0;i<4;i++)
	  matrix[2][i]=pe*matrix[1][i]+matrix[2][i];

	if (fabs(matrix[2][2]) < eps)
		return(FALSE);

	sp[0]=matrix[2][3]/matrix[2][2];
	sp[1]=(matrix[1][3]-sp[0]*matrix[1][2])/matrix[1][1];
	sp[2]=(matrix[0][3]-sp[0]*matrix[0][2]-sp[1]*matrix[0][1])/matrix[0][0];

	return(TRUE);
}


double P_P_Abstand(x1, y1, z1, x2, y2, z2)
double x1, y1, z1;
double x2, y2, z2;
{
	 double dx, dy, dz;

	 dx = x2-x1;
	 dy = y2-y1;
	 dz = z2-z1;
	 return(sqrt(dx*dx+dy*dy+dz*dz));
}

double P_G_Abstand(px, py, pz, gx1, gy1, gz1, gx2, gy2, gz2)
double px, py, pz;
double gx1, gy1, gz1;      /* Punkt 1 auf der Geraden */
double gx2, gy2, gz2;      /* Punkt 2 auf der Geraden */
/* Liefert Abstand des Punktes P: (px, py, pz)
   von der Geraden G: (gx1, gy1, gz1) und (gx2, gy2, gz2)									 ->  X = G1 + l*A
	Formel: d = Abstand(VektProd((P-G1),A0))			 */
{
	double a, ax0, ay0 ,az0;
	double dx, dy, dz;
	double nx, ny ,nz;

	ax0 = gx1 - gx2;   /* A aus den beiden Geradenpunkten berechnen */
	ay0 = gy1 - gy2;
	az0 = gz1 - gz2;
	a = sqrt(ax0*ax0 + ay0*ay0 + az0*az0);
	ax0 = ax0/a;       /* A0 = Einheitsvektor von A */
	ay0 = ay0/a;
	az0 = az0/a;

	dx = px - gx1;     /* D = P-G1 */
	dy = py - gy1;
	dz = pz - gz1;

	nx =   dy*az0 - dz*ay0;   /* N = VektProd(D, A0) */
	ny = -(dx*az0 - dz*ax0);
	nz =   dx*ay0 - dy*ax0;

	return(sqrt(nx*nx+ny*ny+nz*nz));   /* Lnge von N  == gesuchte Abstand */
}


struct poincare  *InitPoincare()
{
	 struct poincare *poinc;

	 poinc = malloc(sizeof(struct poincare));
	 poinc->init = 1;
	 poinc->koor1 =0;
	 poinc->koor2 =1;
	 poinc->koor3 =2;
	 poinc->x1 = -10.0;
	 poinc->y1 = -10.0;
	 poinc->z1 =   4.0;
	 poinc->x2 =  10.0;
	 poinc->y2 = -10.0;
	 poinc->z2 =   4.0;
	 poinc->x3 =  10.0;
	 poinc->y3 =  10.0;
	 poinc->z3 =   4.0;
	 poinc->d12 =  0.0; /* wird erst spter initialisiert */
	 poinc->d23 =  0.0; /* wird erts spter initialisiert */
	 poinc->stwertx = 0;
	 poinc->stwerty = 1;
	 poinc->stwertz = 2;
	 poinc->sweite  = 3;
	 poinc->modified = 0;
	 return(poinc);
}

double fmax(a,b)
double a, b;
{
	 if(a>b) return(a);
	 else return(b);
}

void ComputePoincare(poinc, x1, y1, z1, x2, y2, z2, box)
struct poincare *poinc;
double x1, y1, z1;
double x2, y2, z2;
struct box *box;
/* Berechnet, ob die Gerade durch die beiden Punkte P1 und P2 die Poincare-
   ebene schneidet, und zeichnet gegebenenfalls den Punkt am Screen
	Die Datenstruktur poinc muss die Begrenzungspunkte des 2D-Ausschnitts
	(links oben, rechts oben, links unten !) und die Breite bzw. Hoehe
	enthalten !!!!!!!!! */
{
	double m[3][4];
	double erg[3], spkt[3];

	int bx, by;

	/* Fllen der Matrix fr Pivotsuche */

	m[0][0] = poinc->x2 - poinc->x1;      /* Ebene: Vektor P1,P2 */
	m[1][0] = poinc->y2 - poinc->y1;
	m[2][0] = poinc->z2 - poinc->z1;
	m[0][1] = poinc->x3 - poinc->x1;      /* Ebene: Vektor P1,P3 */
	m[1][1] = poinc->y3 - poinc->y1;
	m[2][1] = poinc->z3 - poinc->z1;
	m[0][2] = x2 - x1;                    /*  Gerade: Vektor P1,P2 */
	m[1][2] = y2 - y1;
	m[2][2] = z2 - z1;
	m[0][3] = poinc->x1 - x1;
	m[1][3] = poinc->y1 - y1;
	m[2][3] = poinc->z1 - z1;
		 /***** Pivot 3 Gleichungen *******/
	if (Pivot(m,spkt))
	{
		/* echten Schnittpunkt ermitteln (einsetzen in Geradengleichung) */
		erg[0] = x1 + spkt[0]*(x2 - x1);
		erg[1] = y1 + spkt[0]*(y2 - y1);
		erg[2] = z1 + spkt[0]*(z2 - z1);
		// Ist Schnittpunkt zwischen den beiden Punkten?
		if(P_P_Abstand(x1, y1, z1, x2, y2, z2)>
			 fmax(P_P_Abstand(x1, y1, z1, erg[0], erg[1], erg[2]),
					P_P_Abstand(x2, y2, z2, erg[0], erg[1], erg[2]))) {

			// Ist Punkt innerhalb des sichbaren 3D-Rechtecks?
			if(IstPunktInnerhalb(poinc, erg)) {
				// Bildschirmkoordinaten berechnen
/* !!! */   bx = box->x2 - ((box->x2-box->x1)/poinc->d12) *
					  P_G_Abstand(erg[0], erg[1], erg[2], poinc->x2,
									  poinc->y2, poinc->z2, poinc->x3, poinc->y3, poinc->z3);
				by = box->y1 + ((box->y2-box->y1)/poinc->d23) *
					  P_G_Abstand(erg[0], erg[1], erg[2], poinc->x1,
									  poinc->y1, poinc->z1, poinc->x2, poinc->y2, poinc->z2);
				if(bx>box->x1+7 && bx<box->x2-7 && by>box->y1+7 && by<box->y2-7)
					putpixel(bx, by, EGA_YELLOW);
			} // IstPunktInnerhalb()
		}
	}
}

int Poincare(poinc, box)
struct poincare *poinc;
struct box *box;
{
	FILE *file;
	double alt[10];
	int j, s = sizeof(double), err=0;
	unsigned long i;
	int k1 = poinc->koor1;
	int k2 = poinc->koor2;
	int k3 = poinc->koor3;
	int anz = Attraktor.anz_stpkte*anzKoor;
	int notfirst=0;
	double po[80];

	BerechneDrittenPunkt(poinc);

	poinc->d12 = P_P_Abstand(poinc->x1, poinc->y1, poinc->z1,
			  poinc->x2, poinc->y2, poinc->z2);
	poinc->d23 = P_P_Abstand(poinc->x2, poinc->y2, poinc->z2,
			  poinc->x3, poinc->y3, poinc->z3);

	 if(WindowStatus!=1) {
		DrawDouble(&K_Poincare[0].box,poinc->x1,"");
		DrawDouble(&K_Poincare[1].box,poinc->y1,"");
		DrawDouble(&K_Poincare[2].box,poinc->z1,"");
		DrawDouble(&K_Poincare[3].box,poinc->x2,"");
		DrawDouble(&K_Poincare[4].box,poinc->y2,"");
		DrawDouble(&K_Poincare[5].box,poinc->z2,"");
		DrawDouble(&K_Poincare[6].box,poinc->x3,"");
		DrawDouble(&K_Poincare[7].box,poinc->y3,"");
		DrawDouble(&K_Poincare[8].box,poinc->z3,"");
	}

	if(!Direkt) {
		file = fopen("ESA.tmp","rb");
	}
	else {
		for(j=0; j<anz; j++) Punkte[j]=Attraktor.stpkte[j];
		for(j=0; j<anzKoor; j++)
			alt[j] = var_const_list[Koordinaten[j].var-97].fvalue;
	}

	for(i=0; i<Attraktor.n ;i++) {
		if(ms_leftb()) return(0);
		while(ms_rightb());
		if(Direkt)
			for(j=0; j<anz; j+=anzKoor) {
				err=Berechne(&Punkte[j]);
				if(err)
					break;
		}
		else fread(Punkte, s, anz, file);
		if(err) break;

		for (j=0; j<anz; j+=anzKoor) {   /* fr alle Startpunkte */
			if(notfirst) ComputePoincare(poinc,
			Punkte[k1+j], Punkte[k2+j], Punkte[k3+j],
			po[k1+j], po[k2+j], po[k3+j], box);
			po[k1+j] = Punkte[k1+j];
			po[k2+j] = Punkte[k2+j];
			po[k3+j] = Punkte[k3+j];
		}
		notfirst = 1;
	}

	if(Direkt)
		  for(j=0; j<anzKoor; j++)
				var_const_list[Koordinaten[j].var-97].fvalue = alt[j];
	else fclose(file);
	return(0);
}


int PoincareZ(poinc, box)
struct poincare *poinc;
struct box *box;
{
	FILE *file;
	char string[20];
	int s = sizeof(double);
	unsigned long i, n;
	int sx = poinc->stwertx, sx1=sx;
	int sy = poinc->stwerty, sy1=sy;
	int sz = poinc->stwertz, sz1=sz;
	int sw = poinc->sweite , s0;
	int notfirst=0;
	double po[80];

	// 3.Punkt rechtwinkelig einrichten.
	BerechneDrittenPunkt(poinc);

	// Hufig verwendete Werte im voraus berechnen.
	poinc->d12 = P_P_Abstand(poinc->x1, poinc->y1, poinc->z1,
			  poinc->x2, poinc->y2, poinc->z2);
	poinc->d23 = P_P_Abstand(poinc->x2, poinc->y2, poinc->z2,
			  poinc->x3, poinc->y3, poinc->z3);

	 if(WindowStatus!=1) {
		// Neue Kommandofelder ausgeben.
		DrawDouble(&K_PoincareZ[6].box,poinc->x1,"");
		DrawDouble(&K_PoincareZ[7].box,poinc->y1,"");
		DrawDouble(&K_PoincareZ[8].box,poinc->z1,"");
		DrawDouble(&K_PoincareZ[9].box,poinc->x2,"");
		DrawDouble(&K_PoincareZ[10].box,poinc->y2,"");
		DrawDouble(&K_PoincareZ[11].box,poinc->z2,"");
		DrawDouble(&K_PoincareZ[12].box,poinc->x3,"");
		DrawDouble(&K_PoincareZ[13].box,poinc->y3,"");
		DrawDouble(&K_PoincareZ[14].box,poinc->z3,"");
	}

	 // File ffnen
	 if(!(file = fopen(Datei.filename,"rb"))) return(1);
	 // Zahlenreihencharakteristika einlesen
	 fread(string, 1, 6, file);
	 fread(&(Zahlen.min), sizeof(double), 1, file);
	 fread(&(Zahlen.max), sizeof(double), 1, file);
	 fread(&(Zahlen.n), 4, 1, file);
	 // Mindestens 2 Punkte werden vorrausgesetzt.
	 // -> 1 Punkte besteht aus 9 Zahlen!
	 if(Zahlen.n<10) {
		 // So nicht.
		 fclose(file);
		 return(1);
	 }

	 // Schrittweite und Startwerte fr Berechnung vorbereiten.
	 if(sx>sy) {s0=sx; sx=sy; sy=s0; }  /* Der Groesse nach sortieren */
	 if(sx>sz) {s0=sz; sz=sx; sx=s0; }
	 if(sy>sz) {s0=sy; sy=sz; sz=s0; }
	 n = (Zahlen.n-sz)/sw;
	 s0 = sz - sx;

	setcolor(EGA_YELLOW);
	// Schleife ber alle Punkte
	for(i=0; i<n;i++) {
		if(ms_leftb()) {    // linke Maustaste -> abbrechen
			fclose(file);
			return(0);
		}
		while(ms_rightb());
		// Daten von Zahlenreihenfile lesen
		fseek(file, (long) (26+(sx+i*sw)*s), 0);
		fread(Punkte, sizeof(double), s0+1, file);

		// Berechnung erfolgt erst ab 2.Punkt (= not first).
		// SchnittPunkt berechnen und ausgeben.
		if(notfirst) ComputePoincare(poinc,
			Punkte[sx1-sx], Punkte[sy1-sx], Punkte[sz1-sx],
			po[sx1-sx], po[sy1-sx], po[sz1-sx], box);
		// letzten Punkt merken
		po[sx1-sx] = Punkte[sx1-sx];
		po[sy1-sx] = Punkte[sy1-sx];
		po[sz1-sx] = Punkte[sz1-sx];
		// ab jetzt kommen nur mehr "not first" Punkte
		notfirst = 1;
	}
	// Fertig. File schliessen.
	fclose(file);
	return(0);
}



/* Berechne die neuen Grenzen des Poincare 2D-Ausschnitts,
	welcher vom Benutzer mit der Maus ausgwhlt wurde.
	mousepick[0], mousepick[1] .. links oben.
	mousepick[2], mousepick[3] .. rechts unten.
	poinc  ..  zu erneuernde Poincare-Struktur.
	box    ..  Bildschirmbereich, in dem ausgewhlt wurde.  */

void NeuerPoincareAusschnitt(mousepick, poinc, box)
int *mousepick;
struct poincare *poinc;
struct box *box;
{
	int a  = box->x2 - box->x1;             //   a Ŀ
	int b  = box->y2 - box->y1;             //               d1    
// int c  = mousepick[2] - mousepick[0];   //    c1 cĿ c2  
// int d  = mousepick[3] - mousepick[1];   //              d     
	int c1 = mousepick[0] - box->x1;        //                   b
	int c2 = box->x2 - mousepick[2];        //            
	int d1 = mousepick[1] - box->y1;        //               d2    
	int d2 = box->y2 - mousepick[3];        //  
	double x12 = poinc->x2-poinc->x1;
	double y12 = poinc->y2-poinc->y1;
	double z12 = poinc->z2-poinc->z1;
	double x23 = poinc->x3-poinc->x2;
	double y23 = poinc->y3-poinc->y2;
	double z23 = poinc->z3-poinc->z2;
	double s, t;


	// Punkt links oben
	t = (double)c1 / (double)a;
	s = (double)d1 / (double)b;
	poinc->x1 = poinc->x1 + t * x12 + s * x23;
	poinc->y1 = poinc->y1 + t * y12 + s * y23;
	poinc->z1 = poinc->z1 + t * z12 + s * z23;

	// Punkt rechts oben
	t = (double)c2 / (double)a;
	s = (double)d1 / (double)b;
	poinc->x2 = poinc->x2 - t * x12 + s * x23;
	poinc->y2 = poinc->y2 - t * y12 + s * y23;
	poinc->z2 = poinc->z2 - t * z12 + s * z23;

	// Punkt rechts unten
	t = (double)c2 / (double)a;
	s = (double)d2 / (double)b;
	poinc->x3 = poinc->x3 - t * x12 - s * x23;
	poinc->y3 = poinc->y3 - t * y12 - s * y23;
	poinc->z3 = poinc->z3 - t * z12 - s * z23;
}

// Prfe, ob der 3 dimensionale Punkt (pkt[0], pkt[1], pkt[2])
// innerhalb eines Rechtecks, das auf einer Ebenen im 3 dimensionalen
// Raum liegt und in der Struktur *poinc beschrieben ist, liegt.

int IstPunktInnerhalb(poinc, pkt)
struct poincare *poinc;
double *pkt;
{
	double m[3][3], s, t;
	int i, j, ii;
	double eps = 0.0000000000000001;

	// Flle Matrix in der Form:          m[0][]       m[1][]      m[2][]
	//                            m[][0]  s*(x2-x1) +  t*(x3-x2) = px-x1
	//                            m[][1]  s*(y2-y1) +  t*(y3-y2) = py-x1
	//                            m[][2]  s*(z2-z1) +  t*(z3-z2) = pz-x1
	m[0][0] = poinc->x2 - poinc->x1;
	m[0][1] = poinc->y2 - poinc->y1;
	m[0][2] = poinc->z2 - poinc->z1;
	m[1][0] = poinc->x3 - poinc->x2;
	m[1][1] = poinc->y3 - poinc->y2;
	m[1][2] = poinc->z3 - poinc->z2;
	m[2][0] = pkt[0] - poinc->x1;
	m[2][1] = pkt[1] - poinc->y1;
	m[2][2] = pkt[2] - poinc->z1;

	// prfe, ob einer der Werte 0 ist -> Abfangen einer mglichen
	// numerischen Instabilitt (Division durch Null) bzw. Abkrzen
	// der Berechnung!

	j=2;

	for(i=0; i<3; i++) {
		if((fabs(m[0][i]) < eps) && (fabs(m[1][i]) >eps)) { j=0; break; }
		if((fabs(m[1][i]) < eps) && (fabs(m[0][i]) >eps)) { j=1; break; }
	}

	switch(j) {
		case 0:  // ein s Term ist Null
			t = m[2][i]/m[1][i];
			for(ii=0; ii<3; ii++) { if(fabs(m[0][ii]) > eps) break; }
			if(ii<3) s = (m[2][ii]-t*m[1][ii])/m[0][ii];
			else 		s = 10.0; // Instabilitt!
			break;
		case 1:  // ein t Term ist Null
			s = m[2][i]/m[0][i];
			for(ii=0; ii<3; ii++) { if(fabs(m[1][ii]) >eps) break; }
			if(ii<3) t = (m[2][ii]-s*m[0][ii])/m[1][ii];
			else	   t = 10.0; // Instabilitt!
			break;
		case 2:  // keine Null enthalten!
			// Nehme die ersten beiden der Glechungen und lse sie.
			t = (m[2][1]*m[0][0]-m[2][0]*m[0][1])/(m[1][1]*m[0][0]-m[0][1]*m[1][0]);
			s = (m[2][0]-t*m[1][0])/m[0][0];
	}

	if(s>=0.0 && s<=1.0 && t>=0.0 && t<=1.0) return(TRUE);
	else return(FALSE);
}

void BerechneDrittenPunkt(poinc)
struct poincare *poinc;
// Gegeben sind drei 3 dimensionale Punkte(P1, P2, P3).
// Die Funktion berechnet den 3.Punkt so neu, da der
// Vektor P2P1 normal auf P3P2 steht und P3 dabei den
// Abstand auf P2P1 beibehlt.
{
	double p21[3];
	double p32[3];
	double x[3];
	double d;

	// bilde Vektor P2P1 und Vektor P3P2
	p21[0] = poinc->x2 - poinc->x1;
	p21[1] = poinc->y2 - poinc->y1;
	p21[2] = poinc->z2 - poinc->z1;
	p32[0] = poinc->x3 - poinc->x2;
	p32[1] = poinc->y3 - poinc->y2;
	p32[2] = poinc->z3 - poinc->z2;

	// berechne Normalvektor auf P2P1 und P3P2
	x[0] =   p21[1]*p32[2] - p21[2]*p32[1];
	x[1] = -(p21[0]*p32[2] - p21[2]*p32[0]);
	x[2] =   p21[0]*p32[1] - p21[1]*p32[0];

	// berechne Normalvektor auf P2P1 und x
	p32[0] =   x[1]*p21[2] - x[2]*p21[1];
	p32[1] = -(x[0]*p21[2] - x[2]*p21[0]);
	p32[2] =   x[0]*p21[1] - x[1]*p21[0];

	// berechne Einheitsvektor von P3P2
	d = sqrt(p32[0]*p32[0] + p32[1]*p32[1] + p32[2]*p32[2]);
	p32[0] = p32[0]/d;
	p32[1] = p32[1]/d;
	p32[2] = p32[2]/d;

	// berechne Abstand zwischen der Geraden P1P2 und dem Punkt P3
	d = P_G_Abstand(poinc->x3,poinc->y3,poinc->z3,  // Punkt P3
						 poinc->x1,poinc->y1,poinc->z1,  // Gerade P1
						 poinc->x2,poinc->y2,poinc->z2); // Gerade P2

	// Berechne P3 neu
	poinc->x3 = poinc->x2 + d*p32[0];
	poinc->y3 = poinc->y2 + d*p32[1];
	poinc->z3 = poinc->z2 + d*p32[2];

	// kein Returnwert, da Pointerzuweisung!
}
