import loader
loader.loadTamashii('_project/src/tamashii/python_bindings')

import pymashii as ta
import numpy as np
import os
from matplotlib import pyplot as plt


def render(scenePath):
    #ta.var.log_level = "info"
    ta.var.default_camera = "Camera.001"

    s = ta.openScene(scenePath)

    for m in s.models:
        print(f"{m.name} {len(m.meshes)}")

    for c in s.cameras:
        print(f"{c.name}")

    rasterized = ta.captureNextFrame()

    #s.cameras[0].makeCurrent()
    pt = ta.impls.path_tracer.switch()
    pt.integrator = pt.Integrator.PathMis
    ray_taced = pt.render(spp=100, srgb=True)

    r = ta.impls.rasterizer.switch()

    fig, axs = plt.subplots(2, 1, figsize=(10, 10))
    axs[0].imshow(rasterized)
    axs[0].axis('off')
    axs[0].set_title('Rasterized Image')

    axs[1].imshow(ray_taced)
    axs[1].axis('off')
    axs[1].set_title('Path Traced Image')

    plt.show()

if __name__ == '__main__':
    testRabbitScenePath = os.path.dirname(__file__) + "/rabbit.gltf"
    render(testRabbitScenePath)
