import os
import sys
from sys import platform

defaultBaseRepositoryName= 'tamashii'
defaultImplementationPath= '_project/src/tamashii/python_bindings'
defaultLibraryPaths= ['test/IALT_PYTHON']
defaultBinType = "Release"

def loadTamashii(
    implementationPath: str= defaultImplementationPath,
    baseRepositoryName: str= defaultBaseRepositoryName,
    libraryPaths: str= defaultLibraryPaths,
    binType: str= defaultBinType,
    verbose= False):
    currentPath= os.path.abspath(os.path.dirname(__file__))
    
    # Ignore top directory name
    currentPath, _= os.path.split(currentPath)
    
    # Move down to repository base directory
    while len(currentPath) > 0:
        currentPath, head= os.path.split(currentPath)
        if head.lower() == baseRepositoryName.lower():
            # Set working directory
            repoPath= os.path.join(currentPath, head)
            os.chdir(repoPath)
            
            if platform == "linux" or platform == "linux2":
                tamashiiPath= os.path.join(repoPath, implementationPath)
                sys.path.append(tamashiiPath)
            else:
                # Add the path of the implementation's bindings module
                tamashiiPath= os.path.join(repoPath, implementationPath, binType)
                os.add_dll_directory(tamashiiPath)
                sys.path.append(tamashiiPath)
            
            # Add any other library paths
            for path in libraryPaths:
                sys.path.append(os.path.join(repoPath, path))
            
            if verbose:
                print(f"[Loader] Loaded tamashii from '{tamashiiPath}'")
                print(f"[Loader] Added {len(libraryPaths)} library paths")
                
            return
    
    raise ImportError(f'Could not locate the base repository name: {tamashii}')
