import loader
loader.loadTamashii()

import pyialt as ta
import numpy as np
import os
from matplotlib import pyplot as plt
import matplotlib.cm as cm
from PIL import Image

import imtrans

def saveImage(arr, path):
    arr = np.clip(arr, 0, 1) * 255
    arr = arr.astype(np.uint8)
    img = Image.fromarray(arr)
    img.save(path)

def runPathTracer(scenePath):
    ta.var.log_level = "none"
    ta.var.default_camera = "Camera"
    ta.var.default_implementation = "Path Tracer"
    pt = ta.impls.path_tracer
    
    # read light pos hist
    light_pos_hist = []
    with open(os.path.dirname(__file__) + '/output.txt') as f:
        for line in f.readlines():
            l = line.split()
            light_pos_hist += [[float(l[0]), float(l[1]), float(l[2])]]

    s = ta.openScene(scenePath)
    light = s.lights[0]
    light.intensity = 100

    # ta.openWindow()
    for idx, pos in enumerate(light_pos_hist):
        light.position = pos
        ta.frame()

        opti_img = imtrans.lin2srgb(imtrans.acesToneMapping(pt.render(100, srgb=False)))
        saveImage(opti_img, os.path.dirname(__file__) + '/out/out' + str(idx) + '.jpg')
        exit()


def main():
    scene = "C:/Users/llipp/Nextcloud/tamashii-resources/ialt_paper_scenes/pcon/simple_office/gltf_v3/simple_office_v3_withCamera2.gltf"
    runPathTracer(scene)

if __name__ == '__main__':
    main()
