import numpy as np

# -- Color space conversion --
def lin2srgb(lin):
    return np.where(lin <= 0.0031308, 12.92 * lin, 1.055 * (lin**(1.0 / 2.4)) - 0.055)

def srgb2lin(srgb):
    return np.where(srgb <= 0.0404482362771082, srgb / 12.92, ((srgb + 0.055) / 1.055)**2.4)

# -- Tone mapping --
def _u2ToneMapping(img):
	A: float = 0.15
	B: float = 0.50
	C: float = 0.10
	D: float = 0.20
	E: float = 0.02
	F: float = 0.30
	return ((img*(A*img+C*B)+D*E)/(img*(A*img+B)+D*F))-E/F

def u2ToneMapping(img):
	W: float = 11.2
	EXPOSURE_BIAS: float = 2.0
	WHITE_SCALE: float = 1.0 / _u2ToneMapping(W)
	curr = _u2ToneMapping(EXPOSURE_BIAS * img)
	return curr * WHITE_SCALE

def _acesRttAndOdtFit(v):
    a = v * (v + 0.0245786) - 0.000090537
    b = v * (0.983729 * v + 0.4329510) + 0.238081
    return a / b

def acesToneMapping(img):
    aces_input_matrix = np.transpose(np.array([[0.59719, 0.35458, 0.04823], [0.07600, 0.90834, 0.01566], [0.02840, 0.13383, 0.83777]]))
    aces_output_matrix = np.transpose(np.array([[1.60475, -0.53108, -0.07367], [-0.10208,  1.10813, -0.00605], [-0.00327, -0.07276,  1.07602]]))
    return np.clip(np.matmul(_acesRttAndOdtFit(np.matmul(img, aces_input_matrix)), aces_output_matrix), 0.0, 1.0)