clear all; clc; %#ok

run('_workdir/obj_sample_xz_results.m');
figure; hold all;

h = surf(x_coords,z_coords,obj_vals); shading interp; axis equal;
colormap('winter');
% set(h, 'EdgeColor', 'k', 'EdgeAlpha',0.1);

% scale = 0.05;
% quiver3(x_coords,z_coords,obj_vals, -scale*x_grads, -scale*z_grads, 0*x_grads, 0);
scale = 0.1; offset=0.0;
quiver3(x_coords(1:3:end,1:3:end),z_coords(1:3:end,1:3:end),offset+obj_vals(1:3:end,1:3:end), ...
    -scale*x_grads(1:3:end,1:3:end), -scale*z_grads(1:3:end,1:3:end), ...
    -scale*(x_grads(1:3:end,1:3:end).^2+z_grads(1:3:end,1:3:end).^2), 0, 'k');
% quiver3(x_coords(1:3:end,1:3:end),z_coords(1:3:end,1:3:end),obj_vals(1:3:end,1:3:end), ...
%     -scale*x_grads(1:3:end,1:3:end), -scale*z_grads(1:3:end,1:3:end), ...
%     0*x_grads(1:3:end,1:3:end), 0, 'w');

xlabel('x');
ylabel('z');
zlabel('O');

% set(gcf, 'Position', get(0, 'Screensize')); drawnow;
saveas(gcf,'_workdir/testOffice-basic-samples.png');


%%

fdx = diff(obj_vals,1,1) ./ diff(x_coords,1,1);
fdz = diff(obj_vals,1,2) ./ diff(z_coords,1,2);

fdx = fdx(:,1:end-1);
fdz = fdz(1:end-1,:);

xx = x_coords(1:end-1,1:end-1) + diff(x_coords(:,1:end-1),1,1);
zz = z_coords(1:end-1,1:end-1) + diff(z_coords(1:end-1,:),1,2);

quiver(xx(1:3:end,1:3:end),zz(1:3:end,1:3:end), ...
    -scale*fdx(1:3:end,1:3:end),-scale*fdz(1:3:end,1:3:end), 0, 'g'); hold on;
quiver(x_coords(1:3:end,1:3:end),z_coords(1:3:end,1:3:end), ...
    -scale*x_grads(1:3:end,1:3:end), -scale*z_grads(1:3:end,1:3:end), 0, 'k', 'LineWidth',1.5);
axis equal;
xlabel('x');
ylabel('z');
legend('FD grad.', 'our grad.');
