clear all; clc; %#ok

run('_workdir/basic_lbfgs_obj.m');
run('_workdir/basic_lbfgs_evals.m');

run('_workdir/basic_gd_obj.m');
run('_workdir/basic_gd_evals.m');

figure; hold all;

plot(obj_lbfgs(1:evals_lbfgs(1)), 'LineWidth', 2);
plot(evals_lbfgs(1):length(obj_lbfgs) ,obj_lbfgs(evals_lbfgs(1):end), '-.', 'LineWidth', 2);

plot(obj_gd(1:evals_gd(1)), 'LineWidth', 2);
plot(evals_gd(1):length(obj_gd) ,obj_gd(evals_gd(1):end), '-.', 'LineWidth', 2);

legend('L-BFGS, Position only', 'L-BFGS, Pos. & Intensity', ...
       'GD, Position only', 'GD, Pos. & Intensity');
axis tight;
set(gca, 'YScale', 'log', 'FontSize', 14);


xlabel('Render pass');
ylabel('Objective function');

saveas(gcf,'_workdir/testOffice-basic-convergence.pdf');
