clear all; clc; %#ok

run('_workdir/basic_lbfgs_obj.m');
run('_workdir/basic_lbfgs_evals.m');

run('_workdir/basic_gd_obj.m');
run('_workdir/basic_gd_evals.m');

run('_workdir/basic_cma_obj.m');
run('_workdir/basic_cma_evals.m');
%%
% filter best-so-far
% CMA
b = obj_cma(1);
for k=2:evals_cma(1)
    if  obj_cma(k) > b
        obj_cma(k) = b;
    else
        b = obj_cma(k);
    end
end
b = obj_cma(evals_cma(1));
for k=1:evals_cma(2)
    if  obj_cma(evals_cma(1)+k) > b
        obj_cma(evals_cma(1)+k) = b;
    else
        b = obj_cma(evals_cma(1)+k);
    end
end
% GD
b = obj_gd(1);
for k=2:evals_gd(1)
    if  obj_gd(k) > b
        obj_gd(k) = b;
    else
        b = obj_gd(k);
    end
end
b = obj_gd(evals_gd(1));
for k=1:evals_gd(2)
    if  obj_gd(evals_gd(1)+k) > b
        obj_gd(evals_gd(1)+k) = b;
    else
        b = obj_gd(evals_gd(1)+k);
    end
end
% L-BFGS
b = obj_lbfgs(1);
for k=2:evals_lbfgs(1)
    if  obj_lbfgs(k) > b
        obj_lbfgs(k) = b;
    else
        b = obj_lbfgs(k);
    end
end
b = obj_lbfgs(evals_lbfgs(1));
for k=1:evals_lbfgs(2)
    if  obj_lbfgs(evals_lbfgs(1)+k) > b
        obj_lbfgs(evals_lbfgs(1)+k) = b;
    else
        b = obj_lbfgs(evals_lbfgs(1)+k);
    end
end

figure; hold all;

plot(obj_lbfgs(1:evals_lbfgs(1)), 'LineWidth', 2,'Color',[0.3 0.3 0.8]);
plot(evals_lbfgs(1):length(obj_lbfgs) ,obj_lbfgs(evals_lbfgs(1):end), '-.', 'LineWidth', 2,'Color',[0.3 0.3 0.8]);

plot(obj_gd(1:evals_gd(1)), 'LineWidth', 2, 'Color',[0.7 0.7 0.9]);
plot(evals_gd(1):length(obj_gd) ,obj_gd(evals_gd(1):end), '-.', 'LineWidth', 2, 'Color',[0.7 0.7 0.9]);

plot(obj_cma(1:evals_cma(1)), 'LineWidth', 2,'Color',[0.9 0.5 0.5]);
plot((evals_cma(1)+2):length(obj_cma) ,obj_cma((evals_cma(1)+2):end), '-.', 'LineWidth', 2,'Color',[0.9 0.5 0.5]);

% plot([0 1250], [min(obj_lbfgs) min(obj_lbfgs)], 'r:');
legend('L-BFGS, Position only', 'L-BFGS, Pos. & Intensity', ...
       'GD, Position only', 'GD, Pos. & Intensity', ...
       'CMA-ES, Position only', 'CMA-ES, Pos. & Intensity');
% axis tight;
set(gca, 'YScale', 'log', 'FontSize', 14);
axis([-10 1000 3e-2 1]);



xlabel('Nr. of evaluations');
ylabel('Objective function');
%
saveas(gcf,'_workdir/testOffice-basic-convergence-best.pdf');
