clear all; clc; %#ok

obj = read_wobj('D:\_tmp\LigthOptMedia\simpleOffice_basic\simple_office_walls.obj');
co = obj.vertices;
idx = find(strcmp({obj.objects(:).type}, 'f'));
el = [obj.objects( idx(1) ).data.vertices;
      obj.objects( idx(2) ).data.vertices;
	  obj.objects( idx(3) ).data.vertices ];

run('_workdir/obj_sample_xz_results.m');
figure; hold all;

obj_vals = obj_vals(16:end-2 , 24:end-1);
x_coords = x_coords(16:end-2 , 24:end-1);
z_coords = z_coords(16:end-2 , 24:end-1);
x_grads = x_grads(16:end-2 , 24:end-1);
z_grads = z_grads(16:end-2 , 24:end-1);


h = surf(x_coords,-z_coords,obj_vals); shading interp; axis equal;
colormap('winter'); ca = caxis();
% set(h, 'EdgeColor', 'k', 'EdgeAlpha',0.1);
trisurf(el,co(:,2),-co(:,1),co(:,3), 'EdgeAlpha',0.1, 'FaceColor',[0.94,0.94,0.94]);

% scale = 0.05;
% quiver3(x_coords,z_coords,obj_vals, -scale*x_grads, -scale*z_grads, 0*x_grads, 0);
scale = 0.1; offset=0.01;
quiver3(x_coords(1:3:end,1:3:end),-z_coords(1:3:end,1:3:end),offset+obj_vals(1:3:end,1:3:end), ...
    -scale*x_grads(1:3:end,1:3:end), scale*z_grads(1:3:end,1:3:end), ...
    -scale*(x_grads(1:3:end,1:3:end).^2+z_grads(1:3:end,1:3:end).^2), 0, 'w');
% quiver3(x_coords(1:3:end,1:3:end),-z_coords(1:3:end,1:3:end),-offset+obj_vals(1:3:end,1:3:end), ...
%     -scale*x_grads(1:3:end,1:3:end), scale*z_grads(1:3:end,1:3:end), ...
%     -scale*(x_grads(1:3:end,1:3:end).^2+z_grads(1:3:end,1:3:end).^2), 0, 'w');

axis tight;

xlabel('x');
ylabel('z');
zlabel('objective');

view(22,32);
set(gca, 'FontSize',24);
set(gcf, 'Position', get(0, 'Screensize')); drawnow;
saveas(gcf,'_workdir/testOffice-basic-samples.png');


%%

fdx = diff(obj_vals,1,1) ./ diff(x_coords,1,1);
fdz = diff(obj_vals,1,2) ./ diff(z_coords,1,2);

fdx = fdx(:,1:end-1);
fdz = fdz(1:end-1,:);

xx = x_coords(1:end-1,1:end-1) - 0.5*diff(x_coords(:,1:end-1),1,1);
zz = z_coords(1:end-1,1:end-1) - 0.5*diff(z_coords(1:end-1,:),1,2);

xx = imfilter(xx, [1 1;1 1]/4, 'replicate');
zz = imfilter(zz, [1 1;1 1]/4, 'replicate');
fdx = imfilter(fdx, [1 1;1 1]/4, 'replicate');
fdz = imfilter(fdz, [1 1;1 1]/4, 'replicate');

figure;
imagesc(x_coords(:,1),-z_coords(1,:),obj_vals);
colormap('winter'); caxis(ca); set(gca,'YDir','normal');
hold on;

quiver(x_coords(1:3:end,1:3:end),-z_coords(1:3:end,1:3:end), ...
    -scale*x_grads(1:3:end,1:3:end), scale*z_grads(1:3:end,1:3:end), 0, 'k', 'LineWidth',3);

quiver(xx(1:3:end,1:3:end),-zz(1:3:end,1:3:end), ...
    -scale*fdx(1:3:end,1:3:end),scale*fdz(1:3:end,1:3:end), 0, 'Color',[0.8 0.8 0.8]);
axis equal;
xlabel('x');
ylabel('z');
hl=legend('our grad.','FD grad.'); set(hl, 'FontSize', 24); %set(hl, 'Color',[0.8 0.8 0.8]);
set(gca,'XLim',[-2.0336    1.1873],'YLim',[-0.7043    1.8360]);

set(gca, 'FontSize',24);
set(gcf, 'Position', get(0, 'Screensize')); drawnow;
saveas(gcf,'_workdir/testOffice-basic-FD.png');

%%
% 
% quiver(xx(10:15,10:15),-zz(10:15,10:15), ...
%     -scale*fdx(10:15,10:15),scale*fdz(10:15,10:15), 0, 'g'); hold on;
% quiver(x_coords(10:15,10:15),-z_coords(10:15,10:15), ...
%     -scale*x_grads(10:15,10:15), scale*z_grads(10:15,10:15), 0, 'k', 'LineWidth',1.5);
% axis equal;

% check coords - should be zero error
max(max(abs( xx(2:end-1,2:end-1) - x_coords(2:end-2,2:end-2) )))
max(max(abs( zz(2:end-1,2:end-1) - z_coords(2:end-2,2:end-2) )))

mean(mean(abs( fdx(2:end-1,2:end-1) - x_grads(2:end-2,2:end-2) ))) / max(max(abs( x_grads(2:end-2,2:end-2) ))) *0.5+...
mean(mean(abs( fdz(2:end-1,2:end-1) - z_grads(2:end-2,2:end-2) ))) / max(max(abs( z_grads(2:end-2,2:end-2) ))) *0.5
% "average relative error" < 5%
