clear all; clc; %#ok
cd '_workdir';
%%
run('basic_lbfgs_LT_obj.m');
run('basic_lbfgs_LT_evals.m');

run('basic_gd_LT_obj.m');
run('basic_gd_LT_evals.m');

evals_gd_LT = evals_gd;
evals_lbfgs_LT = evals_lbfgs;
obj_gd_LT = obj_gd;
obj_lbfgs_LT = obj_lbfgs;


run('basic_lbfgs_obj.m');
run('basic_lbfgs_evals.m');

run('basic_gd_obj.m');
run('basic_gd_evals.m');
%%
% 
% obj_gd_LT = bestSoFar(obj_gd_LT);
% obj_lbfgs_LT = bestSoFar(obj_lbfgs_LT);
% 
% obj_gd = bestSoFar(obj_gd);
% obj_lbfgs = bestSoFar(obj_lbfgs);

%%

figure; hold all;

obj_lbfgs_LT = bestSoFar(obj_lbfgs_LT);
obj_lbfgs = bestSoFar(obj_lbfgs);

plot(obj_gd_LT(1:evals_gd_LT(1)), 'LineWidth', 2, 'Color',[0.5 0.5 0.8]);
plot(evals_gd_LT(1):length(obj_gd_LT) ,obj_gd_LT(evals_gd_LT(1):end), '-.', 'LineWidth', 2, 'Color',[0.5 0.5 0.8]);

plot(obj_lbfgs_LT(1:evals_lbfgs_LT(1)), 'LineWidth', 3, 'Color',[0.2 0.2 0.6]);
plot(evals_lbfgs_LT(1):length(obj_lbfgs_LT) ,obj_lbfgs_LT(evals_lbfgs_LT(1):end), '-.', 'LineWidth', 3, 'Color',[0.2 0.2 0.6]);

plot(obj_gd(1:evals_gd(1)), 'LineWidth', 1.5, 'Color',[0.9 0.8 0.4]);
plot(evals_gd(1):length(obj_gd) ,obj_gd(evals_gd(1):end), '-.', 'LineWidth', 1.5, 'Color',[0.9 0.8 0.4]);

plot(obj_lbfgs(1:evals_lbfgs(1)), 'LineWidth', 3.5, 'Color',[0.5 0.5 0.0]);
plot(evals_lbfgs(1):length(obj_lbfgs) ,obj_lbfgs(evals_lbfgs(1):end), '-.', 'LineWidth', 3.5, 'Color',[0.5 0.5 0.0]);


hl = legend(...
    'GD light trace, Position only', '... Pos. & Intensity', ...
    'L-BFGS light trace, Position only','... Pos. & Intensity',...
    'GD path trace, Position only', '... Pos. & Intensity',...
    'L-BFGS path trace, Position only', '... Pos. & Intensity');

xywh = get(gcf, 'Position'); xywh(3:4)=[640 360];
set(gcf, 'Position', xywh);
% axis tight;
set(gca, 'YScale', 'log', 'FontSize', 14);
set(gca, 'YLim', [3.5e-2 1]);
set(gca, 'XLim', [0 180]);

set(hl,'Position',[0.4089    0.5075    0.4953    0.4179]);

xlabel('Nr. of evaluations');
ylabel('Objective function');
%%
saveas(gcf,'testOffice-basic-convergence-all.pdf');

%%
figure; hold all;
obj_lbfgs_LT = bestSoFar(obj_lbfgs_LT);
obj_lbfgs = bestSoFar(obj_lbfgs);

plot(obj_lbfgs_LT(1:evals_lbfgs_LT(1)), 'LineWidth', 2, 'Color',[0.4 0.4 0.8]);
plot(evals_lbfgs_LT(1):length(obj_lbfgs_LT) ,obj_lbfgs_LT(evals_lbfgs_LT(1):end), '-.', 'LineWidth', 2, 'Color',[0.4 0.4 0.8]);

plot(obj_lbfgs(1:evals_lbfgs(1)), 'LineWidth', 1, 'Color',[0.9 0.4 0.4]);
plot(evals_lbfgs(1):length(obj_lbfgs) ,obj_lbfgs(evals_lbfgs(1):end), '-.', 'LineWidth', 1, 'Color',[0.9 0.4 0.4]);

legend('Light trace, Position only', 'Light trace, Pos. & Intensity', ...
       'Path trace, Position only', 'Path trace, Pos. & Intensity');

xywh = get(gcf, 'Position'); xywh(3:4)=[640 360];
set(gcf, 'Position', xywh);
axis tight;
set(gca, 'YScale', 'log', 'FontSize', 14);


xlabel('Nr. of evaluations');
ylabel('Objective function');



%%
function x = bestSoFar(x)
    b = x(1);
    for k=1:length(x)
        if  x(k) < b
            b = x(k);
        else
            x(k)=b;
        end
    end
end