clear all; clc; %#ok

run('_workdir/intensity_lbfgs_obj.m');
run('_workdir/intensity_adam_obj.m');
run('_workdir/intensity_gd_obj.m');

scale = 1/max([obj_lbfgs(1) obj_adam(1) obj_gd(1)]);

figure; hold all;
plot(scale * obj_lbfgs, 'LineWidth', 2);
plot(scale * obj_adam, 'LineWidth', 2);
plot(scale * obj_gd, 'LineWidth', 2);

legend('L-BFGS', 'ADAM', 'Grad. Desc.');


axis([0 100 1e-10 2]);
set(gca, 'YScale', 'log', 'FontSize', 14);


xlabel('Nr. of evaluations');
ylabel('Normalized objective function');

saveas(gcf,'_workdir/testOffice-intensity-optimization.pdf');
