clear all; clc; %#ok need 'clear all' to avoid caching old input scripts

cd '_workdir_finitediff_simpleOffice';
try
    cd '_workdir'; % a bit hacky: if we run the test twice, the second one ends up in subdir of the first due to 'move' cmd behaviour
    haveSecondResults = 1;
catch
    haveSecondResults = 0;
end

run finitediff_results;
abs_err_2 = abs( fd_grad - repmat(our_grad,length(fd_h),1) );
fd_h_2 = fd_h;
our_grad_2 = our_grad;

if haveSecondResults==1
    cd ..
    run finitediff_results;
end

abs_err = abs( fd_grad - repmat(our_grad,length(fd_h),1) );

%%
figure;

rel_err_magn = (sum(abs_err.^2,2).^.5)/norm(our_grad);
rel_err_magn_2 = (sum(abs_err_2.^2,2).^.5)/norm(our_grad_2);

loglog(fd_h, rel_err_magn ,'k.-', fd_h_2, rel_err_magn_2 ,'r--', 'LineWidth',1.5);

hold on; plot(fd_h, 0.01+0*fd_h, ':k');

xlabel('finite diff. step size');
ylabel('rel. error magnitude');
%legend('Our grad.', 'Naive grad.', '1%');
legend('Light tracing', 'Path tracing', '1%');
set(gca,'FontSize',16);
set(gca, 'XLim', [min(fd_h)/1.1 max(fd_h)]);
set(gca, 'YLim', [5e-3 1e2]);
xywh = get(gcf, 'Position'); xywh(3:4)=[640 360];
set(gcf, 'Position', xywh);
%%
saveas(gcf,'simpleOffice-finiteDiff-comp.pdf');

%%
figure;

rel_err = abs_err./norm(our_grad);
rel_err_2 = abs_err_2./norm(our_grad_2);


%loglog(fd_h, rel_err(:,2),'g' );
loglog(fd_h, rel_err_magn,'k-','LineWidth',2.5);
hold on;

plot(fd_h_2, rel_err_magn_2,'k--','LineWidth',2.5);
plot(fd_h, rel_err(:,1),'r', fd_h, rel_err(:,2),'g', fd_h, rel_err(:,3),'b' );

plot(fd_h_2, rel_err_2(:,2),'--g' ); plot(fd_h_2, rel_err_2(:,1),'--r', fd_h_2, rel_err_2(:,2),'--g', fd_h_2, rel_err_2(:,3),'--b' );

plot(fd_h, 0.01+0*fd_h, ':k');
hf = fill([fd_h, fliplr(fd_h_2)], [rel_err_magn', fliplr(rel_err_magn_2')],'k');
set(hf,'FaceAlpha',0.05,'EdgeAlpha',0);

set(gca,'FontSize',16);

xlabel('finite diff. step size');
ylabel('rel. error');

set(gca, 'XLim', [min(fd_h)/1.1 max(fd_h)]);
set(gca, 'YLim', [2e-4 1e2]);

xywh = get(gcf, 'Position'); xywh(3:4)=[640 400];
set(gcf, 'Position', xywh);
hl = legend('our grad. (magn.)', 'naive grad. (magn.)', 'x','y','z'); %hl = legend('x','y','z','ours (magn.)', 'naive (magn.)');
xywh = get(hl, 'Position'); xywh(1:2)= [ 0.5    0.5973 ];
set(hl, 'Position', xywh);
%%
saveas(gcf,'simpleOffice-finiteDiff-comp-axis.pdf');
%%
cd ..
