clear variables; clc;

d = 3;

H = eye(d);
b = zeros(d,1);
c = 0;

p0 = getParams(H,b,c,d);

%%
N = 1;
xi = [-1 1.5 -1]; %lhsdesign(N,d)*2-1; % [0,1] --> [-2,2]   
fx = zeros(N,1);
dfx = zeros(N,d);

runSetup();

for i = 1:N
    [fxi,dfi] = runSim(xi(i,:));
    fx(i) = fxi;
    dfx(i,:) = dfi;
end
%%
maxStep = 1.0;
for iter=1:10
    %%
    p = p0;
    
    opts = optimoptions('fminunc','Display','final-detailed','MaxFunctionEvaluations',5000);
    opto = @(p) objective(p, xi,fx,dfx,d,1.0,0.0,1e5,1e-2);
    p = fminunc( opto, p, opts );

    [f,df, H,b,c] = getFunction(p,d);
    minEV = min(real(eig(H))) %#ok

    %%
%     [x,y] = meshgrid(-2:0.2:1.5); %linspace(min(xi(:,1)),max(xi(:,1)),20),linspace(min(xi(:,2)),max(xi(:,2)),20));  %

    [x,y,z] = meshgrid(-5:0.4:5);
    fs = 0*x;
    dx = 0*x;
    dy = 0*y;
    dz = 0*z;
    for k = 1:size(x,1)
        for l = 1:size(x,2)
            for m = 1:size(x,3)
                fs(k,l,m)  =  f([ x(k,l,m) ; y(k,l,m); z(k,l,m) ]);
                dfdz    = df([ x(k,l,m) ; y(k,l,m); z(k,l,m) ]);
                dx(k,l) = dfdz(1);
                dy(k,l) = dfdz(2);
                dz(k,l) = dfdz(3);
            end
        end
    end
    figure; 
    isosurface(x,y,z,fs,mean(fs(:))); alpha(0.4); hold on;
    isosurface(x,y,z,fs,mean(fs(:))+std(fs(:))); alpha(0.2);
    isosurface(x,y,z,fs,mean(fs(:))-std(fs(:))); alpha(0.6);

    gradscale = 1;
    quiver3( xi(:,1), xi(:,2), xi(:,3), gradscale*dfx(:,1), gradscale*dfx(:,2),  gradscale*dfx(:,3), 0, 'r');
%     quiver3( x, y, z, gradscale*dx, gradscale*dy, gradscale*(dx.^2+dy.^2), 0, 'g', 'ShowArrowHead','off');

    [bestF, bestI] = min(fx);
    % cond(H)
    x_star = -H\b;
    
    if  norm( x_star - xi(bestI,:)' ) > maxStep
        x_star = xi(bestI,:)' + maxStep * ( x_star - xi(bestI,:)' )./norm( x_star - xi(bestI,:)' );
    end
    plot3( x_star(1), x_star(2), x_star(3) ,'gd' ); hold on;
    plot3( xi(:,1), xi(:,2), xi(:,3), 'ro', 'MarkerSize',8 ); axis equal;
    xlabel('x'); ylabel('y'); zlabel('z');
    drawnow; hold off;
    
    %%
    [fxi,dfi] = runSim(x_star');

    if length(fx) > 5 % only keep limited memory of past function evals
        [~,idx] = sort(fx); idx = idx(1:(5)); %keep the best evaluations 
        xi = xi(idx,:); fx = fx(idx,:); dfx = dfx(idx,:);
    end
    xi = [xi ; x_star']; %#ok
    fx = [fx ; fxi]; %#ok
    dfx= [dfx; dfi]; %#ok

    fprintf('%.6g ',[bestF, fxi, (fxi-bestF)]); %disp(iter);
    %%
end

% -------------------------------------------------------------------------

function p = getParams(H,b,c,d)
%     % direct mapping
%     p = [ H(:) ; b ; c ];

    % symmetric construction
    idx = tril( reshape( (1:(d*d)),d,d) ); idx = idx(idx>0);
    p = [ H(idx) ; b ; c ];
end

function [f,df, H,b,c] = getFunction(p,d)
%     % direct mapping
%     h = d*d;
%     H = reshape( p(1:(d*d)),d,d);
    
    % symmetric construction
    idx = tril( reshape( (1:(d*d)),d,d) ); idx = idx(idx>0);
    h = length(idx);
    H = zeros(d,d); H(idx) = p(1:h);
    
    H = (H+H')./2;
    b = p((h+1):(end-1));
    c = p(end);

     f = @(z) 0.5*(z'*H*z) + b'*z + c;
    df = @(z) H*z + b;
end

function obj = objective(p, x0,f0,d0,d,alpha,beta,gamma,epsilon)
    [f,df, H] = getFunction(p,d);
    
    obj = 0;
    for k = 1:length(f0)
        % value fit
        obj = obj + 0.5*( f( x0(k,:)' )-f0(k) )^2;
        % gradient fit
        obj = obj + alpha * sum( ( df( x0(k,:)' )-d0(k,:)' ).^2 ,1);
        % regularizer(s)
        obj = obj + beta * norm(H,'fro')^2;
        pdr = min(real(eig(H)));
        if  pdr<epsilon
            obj = obj + gamma * (epsilon-pdr)^2;
        end
    end
    
end

function runSetup()
    !prepareWorkdir.bat
    !mklink /J _workdir\gltf_v3 ..\..\..\tamashii-resources\ialt_paper_scenes\pcon\simple_office\gltf_v3
    cd _workdir
end

function [fxi,dfi] = runSim(xi)
    disp('sim'); disp(xi);
    
    dlmwrite('params.txt',xi');
    
    [~, cout] = system('inter_adj_light_trace.exe -headless 1 -runPredefinedTest single-eval-pos-params -load_scene "gltf_v3\simple_office_v3.gltf" -numRaysXperLight 2048 -numRaysYperLight 2048 -constRandSeed 0 -useSHdiffOnlyCoeffObjective 1');

    obj_str = regexp(cout,'obj = [ e\-\+0-9\.]*;', 'match');
    eval(obj_str{1});
    fxi = obj;

    dp_str = regexp(cout,'dp  = \[[ e\-\+0-9\.]*\];', 'match');
    eval(dp_str{1});
    dfi = dp;

    disp([fxi dfi]);
end

