clear; clc;

if ~contains(path, 'OptimTest')
    addpath 'D:\m\OptimTest';
    disp(path);
end
%%
% Note: expected optimal solution (no SH version) is around  [ -0.479571    2.00059 -0.0689892] with objective 0.0563
runSetup();

%     [fxi,dfi] = runSim(xi(i,:));
%     fx(i) = fxi;
%     df(i,:) = dfi;

xi = [1;1;0.]; % for position opt test
%xi = repmat(sqrt(40 *2),10,1); % for intensity opt test
% xi= [ 20  0  0  0  0  0  0 0  0  0]'; % should be the true solution for intensity opt test
alpha = 0.2; % init step size

%%

max_evals = 200;
repeat_runs = 25;

options = optimoptions(@fminunc,'Display','off','Algorithm','quasi-newton','FunctionTolerance',1e-16,'StepTolerance',1e-16,'SpecifyObjectiveGradient',true,'OutputFcn',@optimCallback, 'MaxFunctionEvaluations',max_evals);
opts = cmaes('defaults'); opts.DispFinal='off'; opts.DispModulo=Inf; opts.MaxFunEvals = max_evals;


fvalsC = zeros(repeat_runs, max_evals);
fvalsCL = zeros(repeat_runs, max_evals);
fvalsA = zeros(repeat_runs, max_evals);
fvalsH = zeros(repeat_runs, max_evals);
fvalsM = zeros(repeat_runs, max_evals);
%%
% if restart load data ...
% start = repeat-1;
start=1;
for repeat=start:repeat_runs
    
    [xoC,foC,~, plot_xC,plot_fC,plot_evalsC] = myBFGSCMAopt( xi, @runSim, alpha , 50  ,1);
    [xoCL,foCL,~, plot_xCL,plot_fCL,plot_evalsCL] = myLBFGSCMAopt( xi, @runSim, alpha , 50  ,1);
    [xoA,foA,~, plot_xA,plot_fA,plot_evalsA] = myADAMopt( xi, @runSim, alpha, max_evals )	;

    plot_xM=[]; plot_fM=[]; plot_evalsM=[]; [xoM,foM,~,output] = fminunc(@runSim,xi,options);

    [xoH,foH,evals,~,stats,sol] = cmaes(@runSim,xi,alpha,opts);
    cmaesdata = dlmread('outcmaesfit.dat','',1,0);
    plot_evalsH = [1; cmaesdata(:,2)];
    plot_fH = [max(cmaesdata(:,5)); cmaesdata(:,5)];
    cmaesdata = dlmread('outcmaesxmean.dat','',1,0);
    assert(all( plot_evalsH == cmaesdata(:,2) ));
    plot_xH =  cmaesdata(:,6:end);

    % aggregate over plot_f* and plot_evals* ...
    fvalsC = expandData(fvalsC,plot_fC,plot_evalsC,repeat);
    fvalsCL = expandData(fvalsCL,plot_fCL,plot_evalsCL,repeat);
    fvalsA = expandData(fvalsA,plot_fA,plot_evalsA,repeat);
    fvalsM = expandData(fvalsM,plot_fM,plot_evalsM,repeat);
    fvalsH = expandData(fvalsH,plot_fH,plot_evalsH,repeat);
    %% save all
    save('data_intermediate.mat');
end
delete('outcmaes*.dat'); delete('variablescmaes.mat');
% save all
save('data.mat');
%%
% normalize for plotting
f_max = 1; %max([fvalsC(:); fvalsA(:); fvalsM(:); fvalsH(:)]);
%
figure;
statsPlot(fvalsC ./f_max,'k','our method');
% statsPlot(fvalsCL./f_max,[0.5 0.5 0.0],'our method (L)');
statsPlot(fvalsA ./f_max,'g','ADAM');
statsPlot(fvalsM ./f_max,'r','quasi-Newton');
statsPlot(fvalsH ./f_max,'b','CMA-ES');
hl=legend();
set(hl,'FontSize',16);
set(gca,'FontSize',16);
% axis([0 max_evals , 0.05 2]); %axis tight; %
xlabel('Nr. of function evaluations');
ylabel('Best-so-far objective value');

%%
function runSetup()
    !prepareWorkdir.bat
    !mklink /J _workdir\gltf_v3 ..\..\..\tamashii-resources\ialt_paper_scenes\pcon\simple_office\gltf_v3
    !mklink /J _workdir\gltf_10pointLights ..\..\..\tamashii-resources\ialt_paper_scenes\pcon\simple_office\gltf_10pointLights
    cd _workdir
end

function [fxi,dfi] = runSim(xi)
    dfi = 0*xi;
    fxi = 0*xi(1,:)';
    disp('sim'); disp(xi');
    
    for simRun = 1:size(xi,2)
%         x = xi(:,simRun)';
%         fxi(simRun) = 1e-5*abs(randn(1))  + (1e-3 * ((1-x(:,1)).^2 + 100*(x(:,2)-x(:,1).^2).^2));
%         dfi(:,simRun) = (1e-5*randn(size(x)) + (1e-3 * [ 2*x(:,1) - 400*x(:,1).*(- x(:,1).^2 + x(:,2)) - 2  ,  - 200*x(:,1).^2 + 200*x(:,2) ,0]))';

        dlmwrite('params.txt',xi(:,simRun));

        [~, cout] = system('inter_adj_light_trace.exe -headless 1 -runPredefinedTest single-eval-pos-params -load_scene "gltf_v3\simple_office_v3.gltf" -numRaysXperLight 512 -numRaysYperLight 512 -constRandSeed 0 -useSHdiffOnlyCoeffObjective 1');
%         [~, cout] = system('inter_adj_light_trace.exe -headless 1 -runPredefinedTest single-eval-intensity-params -load_scene "gltf_10pointLights\simple_office_v3_withCamera2_10pointLights_groundTruthTarget.gltf" -numRaysXperLight 512 -numRaysYperLight 512 -constRandSeed 1 -useSHdiffOnlyCoeffObjective 1');

        obj_str = regexp(cout,'obj = [ e\-\+0-9\.]*;', 'match');
        eval(obj_str{1});
        fxi(simRun) = obj;

        dp_str = regexp(cout,'dp  = \[[ e\-\+0-9\.]*\];', 'match');
        eval(dp_str{1});
        dfi(:,simRun) = dp';
    end
    
    disp([fxi dfi']);
end


function stop = optimCallback(x,optimValues,~)
    stop = false;
    plot_xM = evalin('base', 'plot_xM');
    assignin('base', 'plot_xM', [plot_xM; x']);
    plot_fM = evalin('base', 'plot_fM');
    assignin('base', 'plot_fM', [plot_fM; optimValues.fval]);
    plot_evalsM = evalin('base', 'plot_evalsM');
    assignin('base', 'plot_evalsM', [plot_evalsM; optimValues.funccount]);
end


function fvals = expandData(fvals,fs,evals,ii)
    last = 0; max = size(fvals,2);
    for jj = 1:length(evals)
        next = evals(jj);
        if next > max, next = max; end
        fvals(ii,(last+1):next) = fs(jj);
        last = next;
    end
    fvals(ii,last:end) = fs(end);
end

function statsPlot(fvals,colorspec,legendName)
    max_evals = length(fvals);
    hl = semilogy(1:max_evals, max(fvals),':','LineWidth',1.2,'HandleVisibility','off'); hold on; %1:max_evals, min(fvals),':', , 1:max_evals, mean(fvals),'--' 1:max_evals, mean(fvalsC)+std(fvalsC), 1:max_evals, mean(fvalsC)-std(fvalsC) );
    set(hl, 'Color',colorspec);
    hp = plot(1:max_evals, median(fvals),'LineWidth',1.8, 'DisplayName',legendName);
    set(hp, 'Color',colorspec);

    hf = fill([1:max_evals, fliplr(1:max_evals)], [prctile(fvals,75), fliplr(prctile(fvals,25))],colorspec,'HandleVisibility','off');
    set(hf, 'FaceAlpha',0.1,'EdgeAlpha',0);
end

% function x = bestSoFar(x)
%     b = x(1);
%     for k=1:length(x)
%         if  x(k) < b
%             b = x(k);
%         else
%             x(k)=b;
%         end
%     end
% end