clear; clc;

if ~contains(path, 'gek_2016') % Gradient-enhanced Kriging, 2016, JHS de Baar, UNSW Canberra from https://www.mathworks.com/matlabcentral/fileexchange/60230-gradient-enhanced-kriging
    addpath 'D:\m\gek_2016';
    disp(path);
end
%%

N = 3;
options.debug = 0; % gives output for debugging, set to 0 for no output
options.estvar = 'yes';
% maximum likelihood settings:
% options.hyperinit = [1 1 .1];
% options.hyperspace = [1 1 1];
% options.hyperest = 'brute';
% options.brutesize = 1e3;
options.hyperinit = [1 1 4 4];
options.hyperspace = [1 1 1 1];
options.fminopts = optimset('Display','notify','TolFun',1e-12,'TolX',1e-4,'MaxIter',1e4,'MaxFunEvals',1e4);

errf = 1e-4; errdf = 1e-2;
d=2;

%%
xi = lhsdesign(N,d)*4-2; % [0,1] --> [-2,2]
fx = zeros(N,1);
df = zeros(N,d);

runSetup();

for i = 1:N
    [fxi,dfi] = runSim(xi(i,:));
    fx(i) = fxi;
    df(i,:) = dfi;
end
%%
stopcount=0;
for iter = 1:40
    
    x_min = [-2;-2]; x_max = [2;2]; % box constraint for next evaluation point
%     if length(fx) > 3*N % only keep limited memory of past function evals
%         [~,idx] = sort(fx); idx = idx(1:(3*N)); %keep the 3N best evaluations 
%         xi = xi(idx,:); fx = fx(idx,:); df = df(idx,:);
%         x_min = min(xi); x_max = max(xi); % restrict search to box covered by values
%         disp([x_min x_max]);
%     end
%%
    gekmodel = gekPart1(xi,fx,errf*ones(size(fx)),df,errdf*ones(size(df)),options);

    [bestF, bestI] = min(fx);
    ei = @(x) expectedImprovement(x, bestF, gekmodel);
%     if( mod(iter,5)==0 ) % sometimes optimize on the surrogate alone
%         ei = @(x) gekPart2(gekmodel, x');
%     end
    fminopts = optimoptions(@fmincon,'Display','notify');
    x_start = rand(2,1)*4-2; x_start = xi(bestI,:)';
    [x,expImp] = fmincon(ei,x_start,[],[],[],[],x_min,x_max,[],fminopts);
%%
    [fxi,dfi] = runSim(x');
    
    xi = [xi ; x']; %#ok
    fx = [fx ; fxi]; %#ok
    df = [df ; dfi]; %#ok

    fprintf('%.6g ',[bestF, fxi, (fxi-bestF), -expImp]); disp(iter);
%%

    figure;
    % scale = 1e-4; quiver3(xi(:,1),xi(:,2), fx , scale*dfdx(:,1),scale*dfdx(:,2), scale*0*fx ,0);
    [X,Y] = meshgrid(-3:.1:3);
    xout = [reshape((X),numel(X),1) reshape((Y),numel(Y),1) ];
    [fout, varfout, gradout, vargradout, report] = gekPart2(gekmodel,xout);
    F = reshape(fout,size(X));
    V = reshape(varfout,size(X));
    surf(X,Y,F,'EdgeAlpha',0.1,'FaceAlpha',1); hold on;
    surf(X,Y,F-sqrt(abs(V)),'EdgeAlpha',0,'FaceAlpha',0.3);
    surf(X,Y,F+sqrt(abs(V)),'EdgeAlpha',0,'FaceAlpha',0.3);
    plot3(x(1),x(2),fx(end), 'wo');
    plot3(xi(:,1),xi(:,2), fx, 'rx'); hold on; %axis equal;
    plot3(xi(bestI,1),xi(bestI,2), bestF, 'go');
    hold off; view(-80,60); drawnow; pause(0.2);
    saveas(gcf,['gek_iter_' num2str(iter) '.png']);
    
%%
    if abs(expImp)<1e-10, stopcount = stopcount+1; else, stopcount=0; end
    if stopcount >= 3, break; end
end


function runSetup()
    !prepareWorkdir.bat
    !mklink /J _workdir\gltf_v3 ..\..\..\tamashii-resources\ialt_paper_scenes\pcon\simple_office\gltf_v3
    cd _workdir
end

function [fxi,dfi] = runSim(xi)
    if length(xi)==2, xi = [xi(1) 1.8 xi(2)]; end
    disp('sim'); disp(xi);
    
    dlmwrite('params.txt',xi');
    
    [~, cout] = system('inter_adj_light_trace.exe -headless 1 -runPredefinedTest single-eval-pos-params -load_scene "gltf_v3\simple_office_v3.gltf" -numRaysXperLight 2048 -numRaysYperLight 2048 -constRandSeed 0 -useSHdiffOnlyCoeffObjective 1');

    obj_str = regexp(cout,'obj = [ e\-\+0-9\.]*;', 'match');
    eval(obj_str{1});
    fxi = obj;

    dp_str = regexp(cout,'dp  = \[[ e\-\+0-9\.]*\];', 'match');
    eval(dp_str{1});
    dfi = dp([1 3]);

    disp([fxi dfi]);
end

function ei = expectedImprovement(x , bestF, gekmodel)
    [fx,varx] = gekPart2(gekmodel, x');
    sig = sqrt(varx);
    ei = -(  (bestF - fx) * normcdf( (bestF-fx)/sig ) + sig * normpdf( (bestF-fx)/sig )  );
end
