clc;
errf = 1e-4; errdf = 1e-2;
xi_copy = xi; fx_copy = fx; df_copy = df;

% idx = fx < mean(fx) + 0.5*(var(fx)^0.5)
% [~,idx] = sort(fx); idx = idx(1:6)
% xi = xi(idx,:); fx = fx(idx,:); df = df(idx,:);

options = [];
options.debug = 2; % gives output for debugging, set to 0 for no output
options.estvar = 'yes';
% maximum likelihood settings:
options.hyperinit = [1 1 4 4];
options.hyperspace = [1 1 1 1];
% options.hyperest = 'none';
% options.brutesize = 1e3;
options.fminopts = optimset('Display','iter','TolFun',1e-12,'TolX',1e-4,'MaxIter',1e4,'MaxFunEvals',1e4);
%%
    gekmodel = gekPart1(xi,fx,errf*ones(size(fx)),df,errdf*ones(size(df)),options);
    
    figure;
    plot3(xi(:,1),xi(:,2), fx, 'rx'); hold on; %axis equal;
    scale = 1e-0; quiver3(xi(:,1),xi(:,2), fx , scale*df(:,1),scale*df(:,2), 0*fx ,0);
    [X,Y] = meshgrid(-3:.1:3);
    xout = [reshape((X),numel(X),1) reshape((Y),numel(Y),1) ];
    [fout, varfout, gradout, vargradout, report] = gekPart2(gekmodel,xout);
    F = reshape(fout,size(X));
    V = reshape(varfout,size(X));
    surf(X,Y,F,'EdgeAlpha',0.1); hold on;
    surf(X,Y,F-sqrt(V),'EdgeAlpha',0,'FaceAlpha',0.3);
    surf(X,Y,F+sqrt(V),'EdgeAlpha',0,'FaceAlpha',0.3);
    plot3(x(1),x(2),fx(end), 'wo');
    hold off; view(-80,60); drawnow; pause(0.2);
    
xi = xi_copy; fx = fx_copy; df = df_copy;