clear variables; clc;
[x,z] = meshgrid( -1.5:0.2:0.5 , -0.5:0.2:1.5 );
numel(x)

phi = 0*x;
dphidx = 0*x;
dphidy = 0*x;
dphidz = 0*x;

!prepareWorkdir.bat
cd('_workdir');
%%
for i = 1:size(x,1)
    for j = 1:size(x,2)
        %%
        disp(['*** run ' num2str( (i-1)*size(x,2)+j ) ' of ' num2str(numel(x)) ' ...']);
        dlmwrite('_params.txt',[ x(i,j) ; 0.0 ; z(i,j) ]);
        !diffradiancecache.exe -load_scene 'assets\scenes\TwoPlanes\twoplanes_lowres.gltf' -default_camera Camera.001 -default_implementation DiffRadianceCache - > _stdout.txt
        %%
        out = fileread('_stdout.txt');
        tokens = regexp(out,'objfcn = \r\n(?<objfcn>[ 0-9.e+-]*).*objgrad = [ \r\n(?<objgrad>[ 0-9.e+-]*)','names');
        system(['move _stdout.txt _stdout_' num2str(x(i,j)) '_' num2str(z(i,j)) '.txt']);
        
        phi(i,j) = str2double(tokens.objfcn);
        dphi = str2num(tokens.objgrad); %#ok
        dphidx(i,j) = dphi(1);
        dphidy(i,j) = dphi(2);
        dphidz(i,j) = dphi(3);
    end
end
%%
save('_results.mat', 'phi', 'dphidx', 'dphidy', 'dphidz');
%%
cd('..');
%%
scale=0.01;
surf(x,z,scale*phi); axis equal; hold on;
quiver3(x,z,0*phi , dphidx,dphidz,dphidy,'r','LineWidth',2);
xlabel('x');ylabel('z');
