clear variables; clc;
[x,z] = meshgrid( 0:-0.05:-6 , 0:-0.05:-5 );
% [x,z] = meshgrid( 0:-1.0:-6 , 0:-1.0:-5 );
% numel(x)/60/60

phi = 0*x;
dphidx = 0*x;
dphidy = 0*x;
dphidz = 0*x;
%%
!prepareWorkdir.bat
cd('_workdir');
%%
for i = 1:size(x,1)
    for j = 1:size(x,2)
        %%
        disp(['*** run ' num2str( (i-1)*size(x,2)+j ) ' of ' num2str(numel(x)) ' ...']);
        ofname = ['_stdout_' num2str(x(i,j)) '_' num2str(z(i,j)) '.txt'];
        if  exist(ofname, 'file')~=2 % if not found ... run
            dlmwrite('_params.txt',[ x(i,j) ; 3 ; z(i,j) ]);
            !diffradiancecache.exe -load_scene 'assets\scenes\blender_export\Test-Office-v0.2.gltf' -default_camera Camera.001 -default_implementation DiffRadianceCache - > _stdout.txt
            system(['move _stdout.txt ' ofname]);
        else
            disp('... stdout file found');
        end
        %%
        out = fileread(ofname);
        tokens = regexp(out,'objfcn = \r\n(?<objfcn>[ 0-9.e+-]*).*objgrad = [ \r\n(?<objgrad>[ 0-9.e+-]*)','names');
        
        phi(i,j) = str2double(tokens.objfcn);
        dphi = str2num(tokens.objgrad); %#ok
        if  all(size(dphi)==[1 3])
            dphidx(i,j) = dphi(1);
            dphidy(i,j) = dphi(2);
            dphidz(i,j) = dphi(3);
        else
            disp(['failed to read gradient: ' tokens.objgrad]);
        end
    end
end
%%
save('_results.mat', 'x','z','phi', 'dphidx', 'dphidy', 'dphidz');
%%
cd('..');
%%
scale=2.1;
figure;  surf(x,z,scale*phi, 'EdgeAlpha',0); axis equal;
% hold on; quiver3(x,z,0*phi , -dphidx,-dphidz,-dphidy,'r','LineWidth',2);
xlabel('x');ylabel('z');
%%
phi(phi==0)=min(phi(phi>0));
figure;  imagesc(x(1,:)',z(:,1),phi);
hold on; quiver(x,z , -dphidx,-dphidz,'r','LineWidth',0.5);
