clear variables; clc;
raw = dlmread('_workdir/_results.txt');
%%
p = raw(:,[2 4 3]); % parameters (swap z-y for y-up data)
o = raw(:,5);   % objective
g = raw(:,[6 8 7]); % gradient (swap z-y for y-up data)

if  0
%%  filter out non-improving steps (eg. line search in L-BFGS)
    filter = 0*o;
    filter(1)=1; best=o(1); best_i=1;
    for i=2:length(o)
        if  o(i)<best
            best=o(i);
            best_i=i;
        end
        filter(i)=best_i;
    end
    p = p(filter,:);
    o = o(filter);
    g = g(filter,:);
end

figure; surf([p(:,1) p(:,1)],[p(:,2) p(:,2)],[p(:,3) p(:,3)],[o o],'FaceCol','no','EdgeCol','interp','LineWidth',6); axis equal;
hold on; plot3(p(end,1),p(end,2),p(end,3),'rd','MarkerSize',8); plot3(p(1,1),p(1,2),p(1,3),'ro','MarkerSize',8);
quiver3(p(:,1),p(:,2),p(:,3) , -g(:,1),-g(:,2),-g(:,3) ,'LineWidth',0.8);
xlabel('x');ylabel('z');zlabel('y'); % y-up data

%%
figure; semilogy(o);
