clc; clear all;

data = dlmread('_workdir_GD_goodDerivs/resultsGD.txt');
dataOld = dlmread('_workdir_GD_oldDerivs/resultsGD.txt');
%%

n = data(:,1);
obj = data(:,5);

nOld = dataOld(:,1);
objOld = dataOld(:,5);

plot(n, obj  ,  nOld, objOld ,'-.', 'LineWidth', 2);
axis([ 0 300 0.05 0.2 ]);

set(gca,'FontSize',16);
% title('Gradient descent convergence');
xlabel('Gradient descent step');
ylabel('Objective');
legend('Our derivatives', 'Naive derivatives' ,'Location','NorthWest');

saveas(gcf,'gradient-descent-convergence.pdf');

final_pos = data(end,2:4)
final_pos_old = dataOld(end,2:4)

%%
figure;

xyz = data(:,2:4);
plot3(xyz(:,1),xyz(:,2),xyz(:,3)); axis equal;

