
#include <nanobind/nanobind.h>
#include <tamashii/tamashii.hpp>
#include <tamashii/bindings/bindings.hpp>
#include <tamashii/bindings/core_module.hpp>
#include <tamashii/bindings/exports.hpp>
#include <tamashii/implementations/bindings/default_rasterizer.hpp>
#include <tamashii/implementations/bindings/default_path_tracer.hpp>

#include "../renderer.hpp"

T_USE_PYTHON_NAMESPACE
T_USE_NANOBIND_LITERALS

// The module name has to match the name set in the CMakeLists.txt
NB_MODULE(pymashii, m) {
    tamashii::registerBackend(std::make_shared<VulkanRenderBackendDefault>());
    // Export core module and default impls
    Exports& exports = CoreModule::exportCore(m);
    exportDefaultRasterizer(m, exports);
    exportDefaultPathTracer(m, exports);

    // Define custom module content
    //m.def("add", [](int a, int b) { return a + b; }, "a"_a, "b"_a);

	// Modify parts of the core module
    //exports.light().def("customMethod", [](python::Light& self) {
	//	return "This string was returned from a custom method";
	//});
}
