
#include <nanobind/nanobind.h>
#include <tamashii/tamashii.hpp>
#include <tamashii/core/common/common.hpp>
#include <tamashii/core/common/vars.hpp>
#include <tamashii/bindings/bindings.hpp>
#include <tamashii/bindings/core_module.hpp>
#include <tamashii/bindings/exports.hpp>

#include "../example_impl.hpp"

T_USE_PYTHON_NAMESPACE
T_USE_NANOBIND_LITERALS

// The module name has to match the name set in the CMakeLists.txt
NB_MODULE(pycompute, m) {
    // Create and define the core module infrastructure
    tamashii::registerBackend(std::make_shared<VulkanRenderBackendExampleCompute>());
    CoreModule::exportCore(m);

    // Do the same setup as in the ::main() function
    var::default_implementation.value("Example Compute");

    // Add ::runComputation as an instance method, so it cannot be called without an active tamashii instance
    m.def("runComputation", []() { CoreModule::initGuard(); ExampleComputeImpl::runComputation(); });
}
