#include <tamashii/core/platform/system.hpp>
#include <tamashii/core/common/input.hpp>

#include <filesystem>
#include <thread>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include <sys/time.h>
#include <libgen.h>
#include <csignal>
#include <dlfcn.h>

T_USE_NAMESPACE

/**
* System stuff
**/
void sys::initSystem(SystemInfo_s& aSystemInfo) {
    // add ctrl + c callback
    std::signal(SIGINT, [](int) { EventSystem::queueEvent(EventType::ACTION, Input::A_EXIT); });
    // check desktop attributes
//	win32.desktopBitsPixel = systemInfo.bitsPixel = GetDeviceCaps(hDC, BITSPIXEL);
//	win32.desktopWidth = systemInfo.maxWindowWidth = GetDeviceCaps(hDC, HORZRES);
//	win32.desktopHeight = systemInfo.maxWindowHeight = GetDeviceCaps(hDC, VERTRES);
//	win32.desktopRefreshrate = systemInfo.monitorRefreshRate = GetDeviceCaps(hDC, VREFRESH);

    aSystemInfo.os = SystemInfo_s::Platform_e::LINUX;
    aSystemInfo.processorPackageCount = 1;
    aSystemInfo.processorThreadCount = sysconf( _SC_NPROCESSORS_ONLN );
    aSystemInfo.processorCoreCount = std::thread::hardware_concurrency();

    uint64_t nBytes = sysconf(_SC_PHYS_PAGES) * sysconf(_SC_PAGESIZE);
    aSystemInfo.totalSystemMemory = nBytes / 1024 / 1024;
}
std::filesystem::path sys::openFileDialog(const std::string& aTitle, const std::vector<std::pair<std::string, std::vector<std::string>>>& aFilter){
    char filename[1024];
    // --file-filter='Scene (.gltf,.glb) | *.gltf *.glb'
    std::string open_str = "zenity --file-selection --title='" + aTitle + "'";

    for (auto it = aFilter.begin(); it != aFilter.end(); it++){
        open_str += " --file-filter='" + it->first + " |";
        for (const std::string &str : it->second) {
            open_str += " " + str;
        }
        open_str += "'";
    }

    FILE *f = popen(open_str.c_str(), "r");
    if(fgets(filename, 1024, f) == nullptr) return "";
    int ret = pclose(f);
    if(ret != 0) return "";
    std::string path(filename);
    path.erase(std::remove(path.begin(), path.end(), '\n'), path.end());
    return path;
}
std::filesystem::path sys::saveFileDialog(const std::string& aTitle, const std::string& aExtension)
{
	std::string ext = aExtension;
	ext.erase(remove(ext.begin(), ext.end(), '.'), ext.end());
    char filename[1024];
    // --file-filter='Scene (.gltf,.glb) | *.gltf *.glb'
    std::string open_str = "zenity --file-selection --save --title='" + aTitle + "' --filename='untitled." + ext +"'";

    FILE *f = popen(open_str.c_str(), "r");
    if(fgets(filename, 1024, f) == nullptr) return "";
    int ret = pclose(f);
    if(ret != 0) return "";
    std::string path(filename);
    path.erase(std::remove(path.begin(), path.end(), '\n'), path.end());
    if(std::filesystem::path(path).extension().string() != ("." + ext)) {
        path += "." + ext;
    }
    return path;
}
void sys::shutdown() {
	exit(0);
}

//#include <iostream>
//#include <sstream>
//#include <stdlib.h>
//#include <unistd.h>
//#include <stdio.h>
//#include <string.h>

//// Create terminal and redirect output to it, returns 0 on success,
//// -1 otherwise.
//int make_terminal() {
//    char  pidarg[256]; // the '--pid=' argument of tail
//    pid_t child;       // the pid of the child proc
//    pid_t parent;      // the pid of the parent proc
//    FILE* fp;          // file to which output is redirected
//    int   fn;          // file no of fp

//    int p[2], i;

//    if (pipe(p) < 0){

//    }


//    // Open file for redirection
//    fp = fopen("/tmp/asdf.log","w");
//    fn = fileno(fp);

//    // Get pid of current process and create string with argument for tail
//    parent = getpid();
//    sprintf( pidarg, "--pid=%d", parent );

//    // Create child process
//    child = fork();
//    if( child == 0 ) {
//        // CHILD PROCESS
//        close(p[0]);
//        // Replace child process with a gnome-terminal running:
//        //      tail -f /tmp/asdf.log --pid=<parent_pid>
//        // This prints the lines outputed in asdf.log and exits when
//        // the parent process dies.
//        execlp( "gnome-terminal", "gnome-terminal", "--fd=5", NULL);

//        // if there's an error, print out the message and exit
//        perror("execlp()");
//        exit( -1 );
//    } else {
//        // PARENT PROCESS
//        close(p[1]);
//        write(p[0], "asd", 3);
////        close(1);      // close stdout
////        int ok = dup2( fn, 1 ); // replace stdout with the file

////        if( ok != 1 ) {
////            perror("dup2()");
////            return -1;
////        }

////        // Make stdout flush on newline, doesn't happen by default
////        // since stdout is actually a file at this point.
////        setvbuf( stdout, NULL, _IONBF, BUFSIZ );
//    }

//    return 0;
//}

/**
* System Console
**/
void sys::createConsole(const std::string& aName) {
    if(isatty(fileno(stdin))){
        // from terminal
    } else {
        // from desktop
        //make_terminal();
    }
}
void sys::destroyConsole() {
}

void* sys::loadLibrary(const std::string& aName)
{
    return dlopen(aName.c_str(), RTLD_LAZY | RTLD_GLOBAL);
}

bool sys::unloadLibrary(void* aLib)
{
    return dlclose(aLib);
}

void* sys::loadFunction(void* aLib, const std::string& aName)
{
    return dlsym(aLib, aName.c_str());
}



