% settings
% x right | y up | z back
lp = [1 1 0];
alpha = 0.5;
useHeitz = 0;
tinyEps = 0; % 1e-2

% our ggx functions
[ggxD,~,ggxG1NWi,ggxG1NWo,~,~] = getGGXFunction(sym('lp',[3,1],'real'));
fcn_d_ggx = matlabFunction(ggxD);
fcn_g1_ggx_nwo = matlabFunction(ggxG1NWo);

% wi
hp = [0 0 0];
wi = lp - hp;
wi = wi./norm(wi);

n = [0 1 0];
alpha2 = alpha * alpha;
nDotWi = dot(wi,n);

if useHeitz
    theta_o = acos(nDotWi);
    a = 1 / (alpha * tan(theta_o));
    Lambda = (-1 + sqrt(1 + 1/a^2)) / 2;
    g1_ggx = 1 / (1 + Lambda);
else
    g1_ggx = fcn_g1_ggx_nwo(alpha2,hp(1),hp(2),hp(3),lp(1),lp(2),lp(3),n(1),n(2),n(3),tinyEps);
end

%% Weak White Furnace Test
integral = 0;
dtheta = 0.05;
dphi = 0.05;
for theta = 0:dtheta:pi
    for phi = 0:dphi:2*pi
        % reflected vector
        wo = [cos(phi)*sin(theta) cos(theta) sin(phi)*sin(theta)];
        % half vector
        m = (wi + wo) / norm(wi + wo);

        nDotM = dot(n,m);
        ndotWi = dot(wi,n);
        ndotWo = dot(wo,n);

        if nDotM > 0
            if useHeitz
                theta_h = acos(nDotM);
                ggxD = 1 / (1 + (tan(theta_h)/alpha)^2)^2;
                ggxD = ggxD / (pi * alpha2 * nDotM^4);
            else
                ggxD = fcn_d_ggx(alpha2,hp(1),hp(2),hp(3),lp(1),lp(2),lp(3),n(1),n(2),n(3),wo(1),wo(2),wo(3));
            end
        else
            ggxD = 0;
        end

        ggx = (ggxD * g1_ggx) / (4*abs(ndotWi));
        % integrate
        integral = integral + sin(theta) * ggx;
    end
end
integral = integral * dphi * dtheta;
display(num2str(integral) + " => Integral should be 1");
