withareatosa = false;
withpdf = true;
withsamplecount = true;

%#define PDF_TRIANGLE_UNIFORM(area) (1.0f/(area))
%#define PDF_SQUARE_UNIFORM(area) (1.0f/(area))
% solidAngleToArea return (area * abs(cosTheta)) / (dist * dist);
% areaToSolidAngle return (dist * dist) / (area * abs(cosTheta));

% x right
% y up
% z back
%% triangle
v0 = [-1 0 -1];
v1 = [1 0 1];
v2 = [1 0 -1];
v0v1 = v1 - v0;
v0v2 = v2 - v0;

normal = cross(v0v1, v0v2);
area = norm(normal);
normal = normal./area;
area = area/2;
%% light
lpos = [0 1 0];
lnormal = [0 -1 0];
ltangent = [1 0 0];
lbitangent = [0 0 1];
ldim = [2 2];
larea = ldim(1) * ldim(2);
lhdim = ldim .* 0.5;
color = [1 1 1];
intensity = 1;

sampleCount = 100000;
rng('default')  % For reproducibility
p = haltonset(4,'Skip',1e3,'Leap',1e2);

r1 = p(1:sampleCount,1);
r2 = p(1:sampleCount,2);
r3 = p(1:sampleCount,3);
r4 = p(1:sampleCount,4);

lposNew = sampleRectUniform(r3, r4, lpos, ltangent, lbitangent, ldim);
fcn = getCosDist2GradFunc();

%% on triangle
pos = sampleTriangleUniform(r1, r2, v0, v1, v2);

dir = lposNew - pos;
dirLength = vecnorm(dir,2,2);
dirLength2 = dirLength .* dirLength;
dirNorm = dir ./ dirLength;
tcos = dot(dirNorm, repmat(normal, size(dir,1), 1), 2);
lcos = dot(-dirNorm, repmat(lnormal, size(dir,1), 1), 2);

%grad1 = fcn(lpos(1),lpos(2),lpos(3),normal(1),normal(2),normal(3),pos(:,1)',pos(:,2)',pos(:,3)',1e-2)';
grad1 = ones(sampleCount, 1);
if withsamplecount
    grad1 = grad1 ./ sampleCount;
end
if withpdf
    grad1 = grad1 ./ (1/area);
end
if withareatosa
    grad1 = grad1 .* tcos .* larea .* lcos ./ dirLength2;    
end
disp(sum(grad1,1))

%% ray tracing
dir = sampleHemisphereUniform(r1, r2);

[intersect, t, u, v, xcoor] = TriangleRayIntersection(lposNew, dir', v0, v1, v2);
t(intersect == 0,:) = [];
dir(intersect == 0,:) = [];
lposNew(intersect == 0,:) = [];
intersect(intersect == 0,:) = [];
hitPos = lposNew + dir .* t;

dir = lposNew - hitPos;
dirLength = vecnorm(dir,2,2);
dirLength2 = dirLength .* dirLength;
dirNorm = dir ./ dirLength;
tcos = dot(dirNorm, repmat(normal, size(dir,1), 1), 2);
lcos = dot(-dirNorm, repmat(lnormal, size(dir,1), 1), 2);

%grad2 = fcn(lpos(1),lpos(2),lpos(3),normal(1),normal(2),normal(3),hitPos(:,1)',hitPos(:,2)',hitPos(:,3)',1e-2)';
grad2 = ones(size(intersect, 1), 1);
if withsamplecount
    grad2 = grad2 ./ sampleCount;
end
if withpdf
    grad2 = grad2 ./ (1 / (2 * pi));
    grad2 = grad2 ./ (1/larea);
end
if withareatosa
    grad2 = grad2 .* lcos;
else
    grad2 = grad2 .* dirLength2 ./ (larea .* tcos);
end
disp(sum(grad2,1))

function fcn = getCosDist2GradFunc()
    % geometric term cos(incoming angle) / distance^2
    lp = sym('lp',[3,1],'real');
    hp = sym('qp',[3,1],'real');
    n = sym('n',[3,1],'real');
    syms tinyEps real;
    
    rd = lp - hp;
    rl = norm(rd);
    rd = rd./rl;
    
    cosOverR2 = simplify(dot(n, rd)/(rl*rl+tinyEps));
    
    dCosOverR2dp = simplify( gradient( cosOverR2, lp ) );
    fcn = matlabFunction( dCosOverR2dp);
end

% pos in rectangle dist half dim around p
function p = sampleRectUniform(r1, r2, p, t, b, dim)
    p = p + (r1 - 0.5) .* dim(1) .* t;
    p = p + (r2 - 0.5) .* dim(2) .* b;
end

function p = sampleTriangleUniform(r1, r2, v0, v1, v2)
	sqrt_r1 = sqrt(r1);
    baryx = 1.0 - sqrt_r1;
    baryy = sqrt_r1 .* (1.0 - r2);
    baryz = sqrt_r1 .* r2;
	p = v0 .* baryx + v1 .* baryy + v2 .* baryz;
end

% oriented in -y direction
function dir =  sampleHemisphereUniform(r1, r2)
    z = r1;
	r = sqrt(max(0.0, 1.0 - z .* z));
	theta = 2 * pi * r2;
    x = r .* cos(theta);
    y = r .* sin(theta);
	dir = [x -z y];
end