withCosDivR2 = true;
withpdf = true;
withsamplecount = true;

%#define PDF_TRIANGLE_UNIFORM(area) (1.0f/(area))
%#define PDF_SPHERE_UNIFORM(radius) (1.0f/(M_4PI * radius * radius))

% x right
% y up
% z back
%% triangle
v0 = [-1 0 -1];
v1 = [1 0 1];
v2 = [1 0 -1];
v0v1 = v1 - v0;
v0v2 = v2 - v0;

normal = cross(v0v1, v0v2);
area = norm(normal);
normal = normal./area;
area = area/2;
%% light
lpos = [0 1 0];
color = [1 1 1];
intensity = 1;

sampleCount = 100000;
rng('default')  % For reproducibility
p = haltonset(2,'Skip',1e3,'Leap',1e2);

r1 = p(1:sampleCount,1);
r2 = p(1:sampleCount,2);

fcn = getCosDist2GradFunc();

%% on triangle
pos = sampleTriangleUniform(r1, r2, v0, v1, v2);
dir = lpos - pos;
dirLength = vecnorm(dir,2,2);
dirLength2 = dirLength .* dirLength;
dirNorm = dir ./ dirLength;
cosIn = dot(dirNorm, repmat(normal, size(dir,1), 1), 2);

grad1 = fcn(lpos(1),lpos(2),lpos(3),normal(1),normal(2),normal(3),pos(:,1)',pos(:,2)',pos(:,3)',1e-2)';
%grad1 = ones(sampleCount, 1);
if withsamplecount
    grad1 = grad1 ./ sampleCount;
end
if withpdf
    grad1 = grad1 ./ (1/area);
end
if withCosDivR2
    grad1 = grad1 .* cosIn ./ dirLength2;
end
disp(sum(grad1,1))

%% ray tracing
dir = sampleSphereUniform(r1, r2);

[intersect, t, u, v, xcoor] = TriangleRayIntersection(lpos, dir', v0, v1, v2);
t(intersect == 0,:) = [];
dir(intersect == 0,:) = [];
intersect(intersect == 0,:) = [];
hitPos = lpos + dir .* t;

dir = lpos - hitPos;
dirLength = vecnorm(dir,2,2);
dirLength2 = dirLength .* dirLength;
dirNorm = dir ./ dirLength;
cosIn = dot(dirNorm, repmat(normal, size(dir,1), 1), 2);

grad2 = fcn(lpos(1),lpos(2),lpos(3),normal(1),normal(2),normal(3),hitPos(:,1)',hitPos(:,2)',hitPos(:,3)',1e-2)';
%grad2 = ones(size(intersect, 1), 1);
if withsamplecount
    grad2 = grad2 ./ sampleCount;
end
if withpdf
    grad2 = grad2 ./ (1 / (4 * pi));
end
if ~withCosDivR2
    grad2 = grad2 .* dirLength2 ./ cosIn;
end
disp(sum(grad2,1))

function fcn = getCosDist2GradFunc()
    % geometric term cos(incoming angle) / distance^2
    lp = sym('lp',[3,1],'real');
    hp = sym('qp',[3,1],'real');
    n = sym('n',[3,1],'real');
    syms tinyEps real;
    
    rd = lp - hp;
    rl = norm(rd);
    rd = rd./rl;
    
    cosOverR2 = simplify(dot(n, rd)/(rl*rl+tinyEps));
    
    dCosOverR2dp = simplify( gradient( cosOverR2, lp ) );
    fcn = matlabFunction( dCosOverR2dp);
end

function p = sampleTriangleUniform(r1, r2, v0, v1, v2)
	sqrt_r1 = sqrt(r1);
    baryx = 1.0 - sqrt_r1;
    baryy = sqrt_r1 .* (1.0 - r2);
    baryz = sqrt_r1 .* r2;
	p = v0 .* baryx + v1 .* baryy + v2 .* baryz;
end

function dir =  sampleSphereUniform(r1, r2)
	z = 1 - 2 * r1; 
	r = sqrt(max(0, 1 - z .* z));
	theta = 2 * pi * r2;
    x = r .* cos(theta);
    y = r .* sin(theta);
	dir = [x y z];
    dir = dir;
end