% adjusted for out dir deriv (lp)
function [ggxD,ggxG,ggxG1NWi,ggxG1NWo,diffuseLambert,specularGGX] = getGGXFunction(lp)
    n = sym('n',[3,1],'real');
    wi = sym('wi',[3,1],'real');
    albedo = sym('albedo',[3,1],'real');
    syms alpha2 tinyEps real;
    syms eta_ext eta_int real;

    % wo
    hp = sym('hp',[3,1],'real');
    hpToLp = lp - hp;
    hpToLpLength = norm(hpToLp);
    hpToLpNorm = hpToLp./hpToLpLength;

    % m
    m = hpToLpNorm + wi;
    m = m ./ norm(m);
    
    % dots
    nDotM = dot(n, m);
    nDotWo = dot(n, hpToLpNorm);
    nDotWi = dot(n, wi);
    nDotW = dot(m, wi);
    
    %% F
    [fNWo] = getFresnelFunction(abs(nDotWo), eta_ext, eta_int);
    eta = eta_ext / eta_int;
	eta2 = eta * eta;
    %% D
    d_t = 1.0 + (alpha2 - 1.0) * nDotM * nDotM;
    ggxD = alpha2 / (pi * d_t * d_t);
    %% G
    % Walter et al. 2007. Microfacet models for refraction through rough surfaces.
    % g1 n dot wi
    cos_theta2_nwi = nDotWi * nDotWi;
    tan_theta2_nwi = (1 - cos_theta2_nwi) / (cos_theta2_nwi+tinyEps);
    ggxG1NWi = 2/(1 + sqrt(1 + alpha2 * tan_theta2_nwi));
    % g1 n dot wo
    cos_theta2_nwo = nDotWo * nDotWo;
    tan_theta2_nwo = (1 - cos_theta2_nwo) / (cos_theta2_nwo+tinyEps);
    ggxG1NWo = 2/(1 + sqrt(1 + alpha2 * tan_theta2_nwo));
    % g
    ggxG = (ggxG1NWi * ggxG1NWo);
    %% specular (ggx)
    specularGGX = (ggxD * ggxG) / (4*abs(nDotWi)*abs(nDotWo)+tinyEps);
    %% diffuse (requires rest of the internal scattering eq) * 1/(pi * (1-albedo) * ri)
    diffuseLambert = (1.0 - fNWo);
    
end

