%% dielectric
function [dielectricFresnel] = getFresnelFunction(cosThetaI, eta_ext, eta_int)

    eta = eta_ext / eta_int;

    sinThetaTSq = eta * eta .* (1 - cosThetaI .* cosThetaI);
    %cosThetaT = sqrt(max(1 - sinThetaTSq, 0));
    cosThetaT = sqrt(1 - sinThetaTSq);

    rs =  (eta_ext * cosThetaI - eta_int * cosThetaT) ./ (eta_ext * cosThetaI + eta_int * cosThetaT); % ⊥
    rp =  (eta_int * cosThetaI - eta_ext * cosThetaT) ./ (eta_int * cosThetaI + eta_ext * cosThetaT); % ∥

    % No polarization -- return the unpolarized reflectance
    dielectricFresnel = 0.5 * (rs .* rs + rp .* rp);
    %dielectricFresnel = piecewise(sinThetaTSq > 1.0, 1.0, dielectricFresnel);
    %dielectricFresnel = piecewise(eta == 1.0, 0.0, dielectricFresnel);
end